/*
 * Decompiled with CFR 0.152.
 */
package plume;

import checkers.nullness.quals.NonNull;
import checkers.nullness.quals.Nullable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import plume.Filter;
import plume.RandomSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UtilMDE {
    private static final String lineSep = System.getProperty("line.separator");
    private static HashMap<String, Class<?>> primitiveClasses = new HashMap(8);
    private static HashMap<String, String> primitiveClassesJvm;
    private static HashMap<String, String> primitiveClassesFromJvm;
    private static PromiscuousLoader thePromiscuousLoader;
    @NonNull
    static final String userHome;
    private static Random r;
    static HashMap<String, Class<?>[]> args_seen;

    private UtilMDE() {
        throw new Error("do not instantiate");
    }

    public static boolean intersectionCardinalityAtLeast(BitSet a, BitSet b, int i) {
        int size = Math.min(a.length(), b.length());
        if (size > 10 * i) {
            BitSet intersection = a.get(0, 4 * i);
            intersection.and(b);
            if (intersection.cardinality() >= i) {
                return true;
            }
        }
        return UtilMDE.intersectionCardinality(a, b) >= i;
    }

    public static boolean intersectionCardinalityAtLeast(BitSet a, BitSet b, BitSet c, int i) {
        int size = Math.min(a.length(), b.length());
        if ((size = Math.min(size, c.length())) > 10 * i) {
            BitSet intersection = a.get(0, 4 * i);
            intersection.and(b);
            intersection.and(c);
            if (intersection.cardinality() >= i) {
                return true;
            }
        }
        return UtilMDE.intersectionCardinality(a, b, c) >= i;
    }

    public static int intersectionCardinality(BitSet a, BitSet b) {
        BitSet intersection = (BitSet)a.clone();
        intersection.and(b);
        return intersection.cardinality();
    }

    public static int intersectionCardinality(BitSet a, BitSet b, BitSet c) {
        BitSet intersection = (BitSet)a.clone();
        intersection.and(b);
        intersection.and(c);
        return intersection.cardinality();
    }

    public static InputStream fileInputStream(File file) throws IOException {
        InputStream in = file.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
        return in;
    }

    public static InputStreamReader fileReader(String filename) throws FileNotFoundException, IOException {
        return UtilMDE.fileReader(new File(filename), null);
    }

    public static InputStreamReader fileReader(File file) throws FileNotFoundException, IOException {
        return UtilMDE.fileReader(file, null);
    }

    public static InputStreamReader fileReader(File file, @Nullable String charsetName) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(file);
        InputStreamReader file_reader = charsetName == null ? new InputStreamReader(in) : new InputStreamReader((InputStream)in, charsetName);
        return file_reader;
    }

    public static BufferedReader bufferedFileReader(String filename) throws FileNotFoundException, IOException {
        return UtilMDE.bufferedFileReader(new File(filename));
    }

    public static BufferedReader bufferedFileReader(File file) throws FileNotFoundException, IOException {
        return UtilMDE.bufferedFileReader(file, null);
    }

    public static BufferedReader bufferedFileReader(String filename, @Nullable String charsetName) throws FileNotFoundException, IOException {
        return UtilMDE.bufferedFileReader(new File(filename), charsetName);
    }

    public static BufferedReader bufferedFileReader(File file, @Nullable String charsetName) throws FileNotFoundException, IOException {
        InputStreamReader file_reader = UtilMDE.fileReader(file, charsetName);
        return new BufferedReader(file_reader);
    }

    public static LineNumberReader lineNumberFileReader(String filename) throws FileNotFoundException, IOException {
        return UtilMDE.lineNumberFileReader(new File(filename));
    }

    public static LineNumberReader lineNumberFileReader(File file) throws FileNotFoundException, IOException {
        InputStreamReader file_reader = file.getName().endsWith(".gz") ? new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), "ISO-8859-1") : new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1");
        return new LineNumberReader(file_reader);
    }

    public static BufferedWriter bufferedFileWriter(String filename) throws IOException {
        return UtilMDE.bufferedFileWriter(filename, false);
    }

    public static BufferedWriter bufferedFileWriter(String filename, boolean append) throws IOException {
        OutputStreamWriter file_writer = filename.endsWith(".gz") ? new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(filename, append))) : new FileWriter(filename, append);
        return new BufferedWriter(file_writer);
    }

    @Deprecated
    public static BufferedReader BufferedFileReader(String filename) throws FileNotFoundException, IOException {
        return UtilMDE.bufferedFileReader(filename);
    }

    @Deprecated
    public static LineNumberReader LineNumberFileReader(String filename) throws FileNotFoundException, IOException {
        return UtilMDE.lineNumberFileReader(filename);
    }

    @Deprecated
    public static LineNumberReader LineNumberFileReader(File file) throws FileNotFoundException, IOException {
        return UtilMDE.lineNumberFileReader(file);
    }

    @Deprecated
    public static BufferedWriter BufferedFileWriter(String filename) throws IOException {
        return UtilMDE.bufferedFileWriter(filename);
    }

    @Deprecated
    public static BufferedWriter BufferedFileWriter(String filename, boolean append) throws IOException {
        return UtilMDE.bufferedFileWriter(filename, append);
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        Class<?> result = primitiveClasses.get(className);
        if (result != null) {
            return result;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            int pos = className.lastIndexOf(46);
            String inner_name = className.substring(0, pos) + "$" + className.substring(pos + 1);
            try {
                return Class.forName(inner_name);
            }
            catch (ClassNotFoundException ee) {
                throw e;
            }
        }
    }

    public static String classnameToJvm(String classname) {
        int dims = 0;
        while (classname.endsWith("[]")) {
            ++dims;
            classname = classname.substring(0, classname.length() - 2);
        }
        String result = primitiveClassesJvm.get(classname);
        if (result == null) {
            result = "L" + classname + ";";
        }
        for (int i = 0; i < dims; ++i) {
            result = "[" + result;
        }
        return result.replace('.', '/');
    }

    public static String primitive_name_to_jvm(String primitive_name) {
        String result = primitiveClassesJvm.get(primitive_name);
        if (result == null) {
            throw new IllegalArgumentException("Not the name of a primitive type: " + primitive_name);
        }
        return result;
    }

    public static String arglistToJvm(String arglist) {
        if (!arglist.startsWith("(") || !arglist.endsWith(")")) {
            throw new Error("Malformed arglist: " + arglist);
        }
        String result = "(";
        String comma_sep_args = arglist.substring(1, arglist.length() - 1);
        StringTokenizer args_tokenizer = new StringTokenizer(comma_sep_args, ",", false);
        while (args_tokenizer.hasMoreTokens()) {
            String arg = args_tokenizer.nextToken().trim();
            result = result + UtilMDE.classnameToJvm(arg);
        }
        result = result + ")";
        return result;
    }

    public static String classnameFromJvm(String classname) {
        String result;
        int dims = 0;
        while (classname.startsWith("[")) {
            ++dims;
            classname = classname.substring(1);
        }
        if (classname.startsWith("L") && classname.endsWith(";")) {
            result = classname.substring(1, classname.length() - 1);
        } else {
            result = primitiveClassesFromJvm.get(classname);
            if (result == null) {
                throw new Error("Malformed base class: " + classname);
            }
        }
        for (int i = 0; i < dims; ++i) {
            result = result + "[]";
        }
        return result.replace('/', '.');
    }

    public static String arglistFromJvm(String arglist) {
        if (!arglist.startsWith("(") || !arglist.endsWith(")")) {
            throw new Error("Malformed arglist: " + arglist);
        }
        String result = "(";
        int pos = 1;
        while (pos < arglist.length() - 1) {
            if (pos > 1) {
                result = result + ", ";
            }
            int nonarray_pos = pos;
            while (arglist.charAt(nonarray_pos) == '[') {
                ++nonarray_pos;
            }
            char c = arglist.charAt(nonarray_pos);
            if (c == 'L') {
                int semi_pos = arglist.indexOf(";", nonarray_pos);
                result = result + UtilMDE.classnameFromJvm(arglist.substring(pos, semi_pos + 1));
                pos = semi_pos + 1;
                continue;
            }
            String maybe = UtilMDE.classnameFromJvm(arglist.substring(pos, nonarray_pos + 1));
            if (maybe == null) {
                throw new Error("Malformed arglist: " + arglist);
            }
            result = result + maybe;
            pos = nonarray_pos + 1;
        }
        return result + ")";
    }

    public static Class<?> loadClassFromFile(String className, String pathname) throws FileNotFoundException, IOException {
        return thePromiscuousLoader.loadClassFromFile(className, pathname);
    }

    public static void addToClasspath(String dir) {
        String pathSep = System.getProperty("path.separator");
        String cp = System.getProperty("java.class.path", ".").replace('\\', '/');
        StringTokenizer tokenizer = new StringTokenizer(cp, pathSep, false);
        boolean found = false;
        while (tokenizer.hasMoreTokens() && !found) {
            found = tokenizer.nextToken().equals(dir);
        }
        if (!found) {
            System.setProperty("java.class.path", dir + pathSep + cp);
        }
    }

    public static long count_lines(String filename) throws IOException {
        LineNumberReader reader = UtilMDE.lineNumberFileReader(filename);
        long count = 0L;
        while (reader.readLine() != null) {
            ++count;
        }
        return count;
    }

    public static String inferLineSeparator(String filename) throws IOException {
        return UtilMDE.inferLineSeparator(new File(filename));
    }

    public static String inferLineSeparator(File filename) throws IOException {
        String s;
        BufferedReader r = UtilMDE.bufferedFileReader(filename);
        int unix = 0;
        int dos = 0;
        int mac = 0;
        while ((s = r.readLine()) != null) {
            if (s.endsWith("\r\n")) {
                ++dos;
                continue;
            }
            if (s.endsWith("\r")) {
                ++mac;
                continue;
            }
            if (!s.endsWith("\n")) continue;
            ++unix;
        }
        if (dos > mac && dos > unix || lineSep.equals("\r\n") && dos >= unix && dos >= mac) {
            return "\r\n";
        }
        if (mac > dos && mac > unix || lineSep.equals("\r") && mac >= dos && mac >= unix) {
            return "\n";
        }
        if (unix > dos && unix > mac || lineSep.equals("\n") && unix >= dos && unix >= mac) {
            return "\n";
        }
        return lineSep;
    }

    public static boolean equalFiles(String file1, String file2) {
        return UtilMDE.equalFiles(file1, file2, false);
    }

    public static boolean equalFiles(String file1, String file2, boolean trimLines) {
        try {
            LineNumberReader reader1 = UtilMDE.lineNumberFileReader(file1);
            LineNumberReader reader2 = UtilMDE.lineNumberFileReader(file2);
            String line1 = reader1.readLine();
            String line2 = reader2.readLine();
            while (line1 != null && line2 != null) {
                if (trimLines) {
                    line1 = line1.trim();
                    line2 = line2.trim();
                }
                if (!line1.equals(line2)) {
                    return false;
                }
                line1 = reader1.readLine();
                line2 = reader2.readLine();
            }
            return line1 == null && line2 == null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean canCreateAndWrite(File file) {
        if (file.exists()) {
            return file.canWrite();
        }
        File directory = file.getParentFile();
        if (directory == null) {
            directory = new File(".");
        }
        return directory.canWrite();
    }

    public static File createTempDir(String prefix, String suffix) throws IOException {
        String fs = File.separator;
        String path = System.getProperty("java.io.tmpdir") + fs + System.getProperty("user.name") + fs;
        File pathFile = new File(path);
        pathFile.mkdirs();
        File tmpfile = File.createTempFile(prefix + "_", "_", pathFile);
        String tmpDirPath = tmpfile.getPath() + suffix;
        tmpfile.delete();
        File tmpDir = new File(tmpDirPath);
        tmpDir.mkdirs();
        return tmpDir;
    }

    public static void deleteDir(String dirName) {
        UtilMDE.deleteDir(new File(dirName));
    }

    public static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
        dir.delete();
    }

    public static File expandFilename(File name) {
        boolean changed;
        String path = name.getPath();
        String newname = UtilMDE.expandFilename(path);
        boolean bl = changed = newname != path;
        if (changed) {
            return new File(newname);
        }
        return name;
    }

    public static String expandFilename(String name) {
        if (name.contains("~")) {
            return name.replace("~", userHome);
        }
        return name;
    }

    public static String java_source(File name) {
        return name.getPath().replace("\\", "\\\\");
    }

    public static void writeObject(Object o, File file) throws IOException {
        FilterOutputStream bytes = new BufferedOutputStream(new FileOutputStream(file), 8192);
        if (file.getName().endsWith(".gz")) {
            bytes = new GZIPOutputStream(bytes);
        }
        ObjectOutputStream objs = new ObjectOutputStream(bytes);
        objs.writeObject(o);
        objs.close();
    }

    public static Object readObject(File file) throws IOException, ClassNotFoundException {
        FilterInputStream istream = new BufferedInputStream(new FileInputStream(file), 8192);
        if (file.getName().endsWith(".gz")) {
            istream = new GZIPInputStream(istream);
        }
        ObjectInputStream objs = new ObjectInputStream(istream);
        return objs.readObject();
    }

    public static String readerContents(Reader r) {
        try {
            int ch;
            StringBuilder contents = new StringBuilder();
            while ((ch = r.read()) != -1) {
                contents.append((char)ch);
            }
            r.close();
            return contents.toString();
        }
        catch (Exception e) {
            throw new Error("Unexpected error in readerContents(" + r + ")", e);
        }
    }

    public static String readFile(File file) {
        try {
            BufferedReader reader = UtilMDE.bufferedFileReader(file);
            StringBuilder contents = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                contents.append(line);
                contents.append(lineSep);
                line = reader.readLine();
            }
            reader.close();
            return contents.toString();
        }
        catch (Exception e) {
            throw new Error("Unexpected error in readFile(" + file + ")", e);
        }
    }

    public static void writeFile(File file, String contents) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(contents, 0, contents.length());
            writer.close();
        }
        catch (Exception e) {
            throw new Error("Unexpected error in writeFile(" + file + ")", e);
        }
    }

    public static final int hash(double x) {
        return UtilMDE.hash(Double.doubleToLongBits(x));
    }

    public static final int hash(double a, double b) {
        double result = 17.0;
        result = result * 37.0 + a;
        result = result * 37.0 + b;
        return UtilMDE.hash(result);
    }

    public static final int hash(double a, double b, double c) {
        double result = 17.0;
        result = result * 37.0 + a;
        result = result * 37.0 + b;
        result = result * 37.0 + c;
        return UtilMDE.hash(result);
    }

    public static final int hash(double[] a) {
        double result = 17.0;
        if (a != null) {
            result = result * 37.0 + (double)a.length;
            for (int i = 0; i < a.length; ++i) {
                result = result * 37.0 + a[i];
            }
        }
        return UtilMDE.hash(result);
    }

    public static final int hash(double[] a, double[] b) {
        return UtilMDE.hash(UtilMDE.hash(a), UtilMDE.hash(b));
    }

    public static final int hash(long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return (int)l;
        }
        int result = 17;
        int hibits = (int)(l >> 32);
        int lobits = (int)l;
        result = result * 37 + hibits;
        result = result * 37 + lobits;
        return result;
    }

    public static final int hash(long a, long b) {
        long result = 17L;
        result = result * 37L + a;
        result = result * 37L + b;
        return UtilMDE.hash(result);
    }

    public static final int hash(long a, long b, long c) {
        long result = 17L;
        result = result * 37L + a;
        result = result * 37L + b;
        result = result * 37L + c;
        return UtilMDE.hash(result);
    }

    public static final int hash(long[] a) {
        long result = 17L;
        if (a != null) {
            result = result * 37L + (long)a.length;
            for (int i = 0; i < a.length; ++i) {
                result = result * 37L + a[i];
            }
        }
        return UtilMDE.hash(result);
    }

    public static final int hash(long[] a, long[] b) {
        return UtilMDE.hash(UtilMDE.hash(a), UtilMDE.hash(b));
    }

    public static final int hash(@Nullable String a) {
        return a == null ? 0 : a.hashCode();
    }

    public static final int hash(@Nullable String a, @Nullable String b) {
        long result = 17L;
        result = result * 37L + (long)UtilMDE.hash(a);
        result = result * 37L + (long)UtilMDE.hash(b);
        return UtilMDE.hash(result);
    }

    public static final int hash(@Nullable String a, @Nullable String b, @Nullable String c) {
        long result = 17L;
        result = result * 37L + (long)UtilMDE.hash(a);
        result = result * 37L + (long)UtilMDE.hash(b);
        result = result * 37L + (long)UtilMDE.hash(c);
        return UtilMDE.hash(result);
    }

    public static final int hash(@Nullable String[] a) {
        long result = 17L;
        if (a != null) {
            result = result * 37L + (long)a.length;
            for (int i = 0; i < a.length; ++i) {
                result = result * 37L + (long)UtilMDE.hash(a[i]);
            }
        }
        return UtilMDE.hash(result);
    }

    public static <T> List<T> randomElements(Iterator<T> itor, int num_elts) {
        return UtilMDE.randomElements(itor, num_elts, r);
    }

    public static <T> List<T> randomElements(Iterator<T> itor, int num_elts, Random random) {
        RandomSelector<T> rs = new RandomSelector<T>(num_elts, random);
        while (itor.hasNext()) {
            rs.accept(itor.next());
        }
        return rs.getValues();
    }

    @Nullable
    public static <T> Integer incrementMap(Map<T, Integer> m, T key, int count) {
        Integer old = m.get(key);
        int new_total = old == null ? count : old + count;
        return m.put(key, new Integer(new_total));
    }

    public static <K, V> String mapToString(Map<K, V> m) {
        StringBuilder sb = new StringBuilder();
        UtilMDE.mapToString(sb, m, "");
        return sb.toString();
    }

    public static <K, V> void mapToString(Appendable sb, Map<K, V> m, String linePrefix) {
        try {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                sb.append(linePrefix);
                sb.append(entry.getKey().toString());
                sb.append(" => ");
                sb.append(entry.getValue().toString());
                sb.append(lineSep);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <K extends Comparable<? super K>, V> Collection<K> sortedKeySet(Map<K, V> m) {
        ArrayList<K> theKeys = new ArrayList<K>(m.keySet());
        Collections.sort(theKeys);
        return theKeys;
    }

    public static <K, V> Collection<K> sortedKeySet(Map<K, V> m, Comparator<K> comparator) {
        ArrayList<K> theKeys = new ArrayList<K>(m.keySet());
        Collections.sort(theKeys, comparator);
        return theKeys;
    }

    public static Method methodForName(String method) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        int oparenpos = method.indexOf(40);
        int dotpos = method.lastIndexOf(46, oparenpos);
        int cparenpos = method.indexOf(41, oparenpos);
        if (dotpos == -1 || oparenpos == -1 || cparenpos == -1) {
            throw new Error("malformed method name should contain a period, open paren, and close paren: " + method + " <<" + dotpos + "," + oparenpos + "," + cparenpos + ">>");
        }
        for (int i = cparenpos + 1; i < method.length(); ++i) {
            if (Character.isWhitespace(method.charAt(i))) continue;
            throw new Error("malformed method name should contain only whitespace following close paren");
        }
        String classname = method.substring(0, dotpos);
        String methodname = method.substring(dotpos + 1, oparenpos);
        String all_argnames = method.substring(oparenpos + 1, cparenpos).trim();
        Class<?>[] argclasses = args_seen.get(all_argnames);
        if (argclasses == null) {
            String[] argnames = all_argnames.equals("") ? new String[]{} : UtilMDE.split(all_argnames, ',');
            argclasses = new Class[argnames.length];
            for (int i = 0; i < argnames.length; ++i) {
                String argname = argnames[i].trim();
                int numbrackets = 0;
                while (argname.endsWith("[]")) {
                    argname = argname.substring(0, argname.length() - 2);
                    ++numbrackets;
                }
                if (numbrackets > 0) {
                    argname = "L" + argname + ";";
                    while (numbrackets > 0) {
                        argname = "[" + argname;
                        --numbrackets;
                    }
                }
                argclasses[i] = UtilMDE.classForName(argname);
            }
            args_seen.put(all_argnames, argclasses);
        }
        return UtilMDE.methodForName(classname, methodname, argclasses);
    }

    public static Method methodForName(String classname, String methodname, Class<?>[] params) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> c = Class.forName(classname);
        Method m = c.getDeclaredMethod(methodname, params);
        return m;
    }

    public static String backticks(String ... command) {
        return UtilMDE.backticks(Arrays.asList(command));
    }

    public static String backticks(List<String> command) {
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        try {
            Process p = pb.start();
            String output = UtilMDE.streamString(p.getInputStream());
            return output;
        }
        catch (IOException e) {
            return "IOException: " + e.getMessage();
        }
    }

    public static boolean propertyIsTrue(Properties p, String key) {
        String pvalue = p.getProperty(key);
        if (pvalue == null) {
            return false;
        }
        return (pvalue = pvalue.toLowerCase()).equals("true") || pvalue.equals("yes") || pvalue.equals("1");
    }

    @Nullable
    public static String appendProperty(Properties p, String key, String value) {
        return (String)p.setProperty(key, p.getProperty(key, "") + value);
    }

    @Deprecated
    @Nullable
    public static String setDefault(Properties p, String key, String value) {
        String currentValue = p.getProperty(key);
        if (currentValue == null) {
            p.setProperty(key, value);
        }
        return currentValue;
    }

    @Nullable
    public static String setDefaultMaybe(Properties p, String key, String value) {
        String currentValue = p.getProperty(key);
        if (currentValue == null) {
            p.setProperty(key, value);
        }
        return currentValue;
    }

    public static void setFinalField(Object o, String fieldName, @Nullable Object value) throws NoSuchFieldException {
        for (Class<?> c = o.getClass(); c != Object.class; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                f.set(o, value);
                return;
            }
            catch (NoSuchFieldException e) {
                if (c.getSuperclass() != Object.class) continue;
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new Error("This can't happen: " + e);
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    @Nullable
    public static Object getPrivateField(Object o, String fieldName) throws NoSuchFieldException {
        for (Class<?> c = o.getClass(); c != Object.class; c = c.getSuperclass()) {
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f.get(o);
            }
            catch (NoSuchFieldException e) {
                if (c.getSuperclass() != Object.class) continue;
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new Error("This can't happen: " + e);
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    @Nullable
    public static Object getFromSet(Set<?> set, Object key) {
        if (key == null) {
            return null;
        }
        for (Object elt : set) {
            if (!key.equals(elt)) continue;
            return elt;
        }
        return null;
    }

    public static void streamCopy(InputStream from, OutputStream to) {
        byte[] buffer = new byte[1024];
        try {
            while (true) {
                int bytes;
                if ((bytes = from.read(buffer)) == -1) {
                    return;
                }
                to.write(buffer, 0, bytes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }

    public static String streamString(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        UtilMDE.streamCopy(is, baos);
        return baos.toString();
    }

    public static String replaceString(String target, String oldStr, String newStr) {
        int pos;
        if (oldStr.equals("")) {
            throw new IllegalArgumentException();
        }
        StringBuffer result = new StringBuffer();
        int lastend = 0;
        while ((pos = target.indexOf(oldStr, lastend)) != -1) {
            result.append(target.substring(lastend, pos));
            result.append(newStr);
            lastend = pos + oldStr.length();
        }
        result.append(target.substring(lastend));
        return result.toString();
    }

    public static String[] split(String s, char delim) {
        Vector<String> result = new Vector<String>();
        int delimpos = s.indexOf(delim);
        while (delimpos != -1) {
            result.add(s.substring(0, delimpos));
            s = s.substring(delimpos + 1);
            delimpos = s.indexOf(delim);
        }
        result.add(s);
        Object[] result_array = new String[result.size()];
        result.copyInto(result_array);
        return result_array;
    }

    public static String[] split(String s, String delim) {
        int delimlen = delim.length();
        if (delimlen == 0) {
            throw new Error("Second argument to split was empty.");
        }
        Vector<String> result = new Vector<String>();
        int delimpos = s.indexOf(delim);
        while (delimpos != -1) {
            result.add(s.substring(0, delimpos));
            s = s.substring(delimpos + delimlen);
            delimpos = s.indexOf(delim);
        }
        result.add(s);
        Object[] result_array = new String[result.size()];
        result.copyInto(result_array);
        return result_array;
    }

    public static String[] splitLines(String s) {
        return s.split("\r\n?|\n\r?", -1);
    }

    public static String join(Object[] a, String delim) {
        if (a.length == 0) {
            return "";
        }
        if (a.length == 1) {
            return String.valueOf(a[0]);
        }
        StringBuffer sb = new StringBuffer(String.valueOf(a[0]));
        for (int i = 1; i < a.length; ++i) {
            sb.append(delim).append(a[i]);
        }
        return sb.toString();
    }

    public static String joinLines(Object ... a) {
        return UtilMDE.join(a, lineSep);
    }

    public static String join(List<?> v, String delim) {
        if (v.size() == 0) {
            return "";
        }
        if (v.size() == 1) {
            return v.get(0).toString();
        }
        StringBuffer sb = new StringBuffer(v.get(0).toString());
        for (int i = 1; i < v.size(); ++i) {
            sb.append(delim).append(v.get(i));
        }
        return sb.toString();
    }

    public static String joinLines(List<String> v, String delim) {
        return UtilMDE.join(v, lineSep);
    }

    public static String escapeNonJava(String orig) {
        StringBuffer sb = new StringBuffer();
        int post_esc = 0;
        int orig_len = orig.length();
        block5: for (int i = 0; i < orig_len; ++i) {
            char c = orig.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    if (post_esc < i) {
                        sb.append(orig.substring(post_esc, i));
                    }
                    sb.append('\\');
                    post_esc = i;
                    continue block5;
                }
                case '\n': {
                    if (post_esc < i) {
                        sb.append(orig.substring(post_esc, i));
                    }
                    sb.append("\\n");
                    post_esc = i + 1;
                    continue block5;
                }
                case '\r': {
                    if (post_esc < i) {
                        sb.append(orig.substring(post_esc, i));
                    }
                    sb.append("\\r");
                    post_esc = i + 1;
                    continue block5;
                }
            }
        }
        if (sb.length() == 0) {
            return orig;
        }
        sb.append(orig.substring(post_esc));
        return sb.toString();
    }

    public static String escapeNonJava(Character ch) {
        char c = ch.charValue();
        switch (c) {
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
        }
        return new String(new char[]{c});
    }

    public static String escapeNonASCII(String orig) {
        StringBuffer sb = new StringBuffer();
        int orig_len = orig.length();
        for (int i = 0; i < orig_len; ++i) {
            char c = orig.charAt(i);
            sb.append(UtilMDE.escapeNonASCII(c));
        }
        return sb.toString();
    }

    private static String escapeNonASCII(char c) {
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c >= ' ' && c <= '~') {
            return new String(new char[]{c});
        }
        if (c < '\u0100') {
            String octal = Integer.toOctalString(c);
            while (octal.length() < 3) {
                octal = '0' + octal;
            }
            return "\\" + octal;
        }
        String hex = Integer.toHexString(c);
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        return "\\u" + hex;
    }

    public static String unescapeNonJava(String orig) {
        StringBuffer sb = new StringBuffer();
        int post_esc = 0;
        int this_esc = orig.indexOf(92);
        while (this_esc != -1) {
            if (this_esc == orig.length() - 1) {
                sb.append(orig.substring(post_esc, this_esc + 1));
                post_esc = this_esc + 1;
                break;
            }
            switch (orig.charAt(this_esc + 1)) {
                case 'n': {
                    sb.append(orig.substring(post_esc, this_esc));
                    sb.append('\n');
                    post_esc = this_esc + 2;
                    break;
                }
                case 'r': {
                    sb.append(orig.substring(post_esc, this_esc));
                    sb.append('\r');
                    post_esc = this_esc + 2;
                    break;
                }
                case '\\': {
                    sb.append(orig.substring(post_esc, this_esc + 1));
                    post_esc = this_esc + 2;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    char ch;
                    sb.append(orig.substring(post_esc, this_esc));
                    char octal_char = '\u0000';
                    int ii = this_esc + 1;
                    while (ii < orig.length() && (ch = orig.charAt(ii++)) >= '0' && ch <= '8') {
                        octal_char = (char)(octal_char * 8 + Character.digit(ch, 8));
                    }
                    sb.append(octal_char);
                    post_esc = ii - 1;
                    break;
                }
                default: {
                    sb.append(orig.substring(post_esc, this_esc));
                    post_esc = this_esc + 1;
                }
            }
            this_esc = orig.indexOf(92, post_esc);
        }
        if (post_esc == 0) {
            return orig;
        }
        sb.append(orig.substring(post_esc));
        return sb.toString();
    }

    public static String removeWhitespaceAround(String arg, String delimiter) {
        arg = UtilMDE.removeWhitespaceBefore(arg, delimiter);
        arg = UtilMDE.removeWhitespaceAfter(arg, delimiter);
        return arg;
    }

    public static String removeWhitespaceAfter(String arg, String delimiter) {
        int delim_len = delimiter.length();
        int delim_index = arg.indexOf(delimiter);
        while (delim_index > -1) {
            int non_ws_index;
            for (non_ws_index = delim_index + delim_len; non_ws_index < arg.length() && Character.isWhitespace(arg.charAt(non_ws_index)); ++non_ws_index) {
            }
            if (non_ws_index != delim_index + delim_len) {
                arg = arg.substring(0, delim_index + delim_len) + arg.substring(non_ws_index);
            }
            delim_index = arg.indexOf(delimiter, delim_index + 1);
        }
        return arg;
    }

    public static String removeWhitespaceBefore(String arg, String delimiter) {
        int delim_len = delimiter.length();
        int delim_index = arg.indexOf(delimiter);
        while (delim_index > -1) {
            int non_ws_index;
            for (non_ws_index = delim_index - 1; non_ws_index >= 0 && Character.isWhitespace(arg.charAt(non_ws_index)); --non_ws_index) {
            }
            if (non_ws_index != delim_index - 1) {
                arg = arg.substring(0, non_ws_index + 1) + arg.substring(delim_index);
            }
            delim_index = arg.indexOf(delimiter, non_ws_index + 2);
        }
        return arg;
    }

    public static String nplural(int n, String noun) {
        if (n == 1) {
            return n + " " + noun;
        }
        if (noun.endsWith("ch") || noun.endsWith("s") || noun.endsWith("sh") || noun.endsWith("x")) {
            return n + " " + noun + "es";
        }
        return n + " " + noun + "s";
    }

    public static String lpad(String s, int length) {
        if (s.length() < length) {
            StringBuffer buf = new StringBuffer();
            for (int i = s.length(); i < length; ++i) {
                buf.append(' ');
            }
            return buf.toString() + s;
        }
        return s.substring(0, length);
    }

    public static String rpad(String s, int length) {
        if (s.length() < length) {
            StringBuffer buf = new StringBuffer(s);
            for (int i = s.length(); i < length; ++i) {
                buf.append(' ');
            }
            return buf.toString();
        }
        return s.substring(0, length);
    }

    public static String rpad(int num, int length) {
        return UtilMDE.rpad(String.valueOf(num), length);
    }

    public static String rpad(double num, int length) {
        return UtilMDE.rpad(String.valueOf(num), length);
    }

    public static int count(String s, int ch) {
        int result = 0;
        int pos = s.indexOf(ch);
        while (pos > -1) {
            ++result;
            pos = s.indexOf(ch, pos + 1);
        }
        return result;
    }

    public static int count(String s, String sub) {
        int result = 0;
        int pos = s.indexOf(sub);
        while (pos > -1) {
            ++result;
            pos = s.indexOf(sub, pos + 1);
        }
        return result;
    }

    public static Vector<Object> tokens(String str, String delim, boolean returnTokens) {
        return UtilMDE.makeVector(new StringTokenizer(str, delim, returnTokens));
    }

    public static Vector<Object> tokens(String str, String delim) {
        return UtilMDE.makeVector(new StringTokenizer(str, delim));
    }

    public static Vector<Object> tokens(String str) {
        return UtilMDE.makeVector(new StringTokenizer(str));
    }

    public static String backTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        String result = sw.toString();
        return result;
    }

    @Deprecated
    public static String backTrace() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new Throwable().printStackTrace(pw);
        pw.close();
        String result = sw.toString();
        return result;
    }

    public static <T> List<T> sortList(List<T> l, Comparator<? super T> c) {
        ArrayList<T> result = new ArrayList<T>(l);
        Collections.sort(result, c);
        return result;
    }

    public static <T> List<T> removeDuplicates(List<T> l) {
        HashSet<T> hs = new HashSet<T>(l.size());
        ArrayList<T> result = new ArrayList<T>();
        for (T t : l) {
            if (!hs.add(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> Vector<T> makeVector(Enumeration<T> e) {
        Vector<T> result = new Vector<T>();
        while (e.hasMoreElements()) {
            result.addElement(e.nextElement());
        }
        return result;
    }

    public static <T> List<List<T>> create_combinations(int dims, int start, List<T> objs) {
        if (dims < 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        for (int i = start; i < objs.size(); ++i) {
            if (dims == 1) {
                ArrayList<T> simple = new ArrayList<T>();
                simple.add(objs.get(i));
                results.add(simple);
                continue;
            }
            List<List<T>> combos = UtilMDE.create_combinations(dims - 1, i, objs);
            Iterator<List<T>> j = combos.iterator();
            while (j.hasNext()) {
                ArrayList<T> simple = new ArrayList<T>();
                simple.add(objs.get(i));
                simple.addAll((Collection)j.next());
                results.add(simple);
            }
        }
        return results;
    }

    public static ArrayList<ArrayList<Integer>> create_combinations(int arity, int start, int cnt) {
        ArrayList<ArrayList<Integer>> results = new ArrayList<ArrayList<Integer>>();
        if (arity == 0) {
            results.add(new ArrayList());
            return results;
        }
        for (int i = start; i <= cnt; ++i) {
            ArrayList<ArrayList<Integer>> combos = UtilMDE.create_combinations(arity - 1, i, cnt);
            Iterator<ArrayList<Integer>> j = combos.iterator();
            while (j.hasNext()) {
                ArrayList<Integer> simple = new ArrayList<Integer>();
                simple.add(new Integer(i));
                simple.addAll((Collection)j.next());
                results.add(simple);
            }
        }
        return results;
    }

    public static String unqualified_name(String qualified_name) {
        int offset = qualified_name.lastIndexOf(46);
        if (offset == -1) {
            return qualified_name;
        }
        return qualified_name.substring(offset + 1);
    }

    public static String unqualified_name(Class<?> cls) {
        return UtilMDE.unqualified_name(cls.getName());
    }

    public static String human_readable(long val) {
        double dval = val;
        String mag = "";
        if (val >= 1000L) {
            if (val < 1000000L) {
                dval = (double)val / 1000.0;
                mag = "K";
            } else if (val < 1000000000L) {
                dval = (double)val / 1000000.0;
                mag = "M";
            } else {
                dval = (double)val / 1.0E9;
                mag = "G";
            }
        }
        String precision = "0";
        if (dval < 10.0) {
            precision = "2";
        } else if (dval < 100.0) {
            precision = "1";
        }
        return String.format("%,1." + precision + "f" + mag, dval);
    }

    static {
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClassesJvm = new HashMap(8);
        primitiveClassesJvm.put("boolean", "Z");
        primitiveClassesJvm.put("byte", "B");
        primitiveClassesJvm.put("char", "C");
        primitiveClassesJvm.put("double", "D");
        primitiveClassesJvm.put("float", "F");
        primitiveClassesJvm.put("int", "I");
        primitiveClassesJvm.put("long", "J");
        primitiveClassesJvm.put("short", "S");
        primitiveClassesFromJvm = new HashMap(8);
        primitiveClassesFromJvm.put("Z", "boolean");
        primitiveClassesFromJvm.put("B", "byte");
        primitiveClassesFromJvm.put("C", "char");
        primitiveClassesFromJvm.put("D", "double");
        primitiveClassesFromJvm.put("F", "float");
        primitiveClassesFromJvm.put("I", "int");
        primitiveClassesFromJvm.put("J", "long");
        primitiveClassesFromJvm.put("S", "short");
        thePromiscuousLoader = new PromiscuousLoader();
        userHome = System.getProperty("user.home");
        r = new Random();
        args_seen = new HashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NullableStringComparator
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && s2 != null) {
                return 1;
            }
            if (s1 != null && s2 == null) {
                return -1;
            }
            return s1.compareTo(s2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RemoveFirstAndLastIterator<T>
    implements Iterator<T> {
        Iterator<T> itor;
        T nothing = new Object();
        T first = this.nothing;
        T current = this.nothing;

        public RemoveFirstAndLastIterator(Iterator<T> itor) {
            this.itor = itor;
            if (itor.hasNext()) {
                this.first = itor.next();
            }
            if (itor.hasNext()) {
                this.current = itor.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.itor.hasNext();
        }

        @Override
        public T next() {
            if (!this.itor.hasNext()) {
                throw new NoSuchElementException();
            }
            T tmp = this.current;
            this.current = this.itor.next();
            return tmp;
        }

        public T getFirst() {
            boolean invalid;
            boolean bl = invalid = this.first == this.nothing;
            if (invalid) {
                throw new NoSuchElementException();
            }
            return this.first;
        }

        public T getLast() {
            if (this.itor.hasNext()) {
                throw new Error();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FilteredIterator<T>
    implements Iterator<T> {
        Iterator<T> itor;
        Filter<T> filter;
        T invalid_t = new Object();
        T current = this.invalid_t;
        boolean current_valid = false;

        public FilteredIterator(Iterator<T> itor, Filter<T> filter) {
            this.itor = itor;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            while (!this.current_valid && this.itor.hasNext()) {
                this.current = this.itor.next();
                this.current_valid = this.filter.accept(this.current);
            }
            return this.current_valid;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                boolean ok;
                this.current_valid = false;
                boolean bl = ok = this.current != this.invalid_t;
                assert (ok);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MergedIterator<T>
    implements Iterator<T> {
        Iterator<Iterator<T>> itorOfItors;
        Iterator<T> current = new ArrayList().iterator();

        public MergedIterator(Iterator<Iterator<T>> itorOfItors) {
            this.itorOfItors = itorOfItors;
        }

        @Override
        public boolean hasNext() {
            while (!this.current.hasNext() && this.itorOfItors.hasNext()) {
                this.current = this.itorOfItors.next();
            }
            return this.current.hasNext();
        }

        @Override
        public T next() {
            this.hasNext();
            return this.current.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MergedIterator2<T>
    implements Iterator<T> {
        Iterator<T> itor1;
        Iterator<T> itor2;

        public MergedIterator2(Iterator<T> itor1_, Iterator<T> itor2_) {
            this.itor1 = itor1_;
            this.itor2 = itor2_;
        }

        @Override
        public boolean hasNext() {
            return this.itor1.hasNext() || this.itor2.hasNext();
        }

        @Override
        public T next() {
            if (this.itor1.hasNext()) {
                return this.itor1.next();
            }
            if (this.itor2.hasNext()) {
                return this.itor2.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IteratorEnumeration<T>
    implements Enumeration<T> {
        Iterator<T> itor;

        public IteratorEnumeration(Iterator<T> itor) {
            this.itor = itor;
        }

        @Override
        public boolean hasMoreElements() {
            return this.itor.hasNext();
        }

        @Override
        public T nextElement() {
            return this.itor.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EnumerationIterator<T>
    implements Iterator<T> {
        Enumeration<T> e;

        public EnumerationIterator(Enumeration<T> e) {
            this.e = e;
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public T next() {
            return this.e.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class WildcardFilter
    implements FilenameFilter {
        String prefix;
        String suffix;

        public WildcardFilter(String filename) {
            int astloc = filename.indexOf("*");
            if (astloc == -1) {
                throw new Error("No asterisk in wildcard argument: " + filename);
            }
            this.prefix = filename.substring(0, astloc);
            this.suffix = filename.substring(astloc + 1);
            if (filename.indexOf("*") != -1) {
                throw new Error("Multiple asterisks in wildcard argument: " + filename);
            }
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(this.prefix) && name.endsWith(this.suffix);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PromiscuousLoader
    extends ClassLoader {
        private PromiscuousLoader() {
        }

        public Class<?> loadClassFromFile(String className, String pathname) throws FileNotFoundException, IOException {
            FileInputStream fi = new FileInputStream(pathname);
            int numbytes = fi.available();
            byte[] classBytes = new byte[numbytes];
            fi.read(classBytes);
            fi.close();
            Class<?> return_class = this.defineClass(className, classBytes, 0, numbytes);
            this.resolveClass(return_class);
            return return_class;
        }
    }
}

