/*
 * Decompiled with CFR 0.152.
 */
package plume;

import checkers.nullness.quals.Nullable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import plume.EntryReader;
import plume.Option;
import plume.Options;
import plume.UtilMDE;

public class TaskManager {
    @Option(value="-r Include only those tasks assigned to the specified person")
    @Nullable
    public static String responsible = null;
    @Option(value="-m Include only those tasks required for the specified milestone")
    @Nullable
    public static String milestone = null;
    @Option(value="-c Include only completed tasks")
    public static boolean completed = false;
    @Option(value="-o Include only open tasks")
    public static boolean open = false;
    @Option(value="-v Print progress information")
    public static boolean verbose = false;
    @Option(value="-f Specify output format")
    public static OutputFormat format = OutputFormat.short_ascii;
    @Option(value="Regex that matches an entire comment (not just a comment start)")
    public static String comment_re = "^%.*";
    @Option(value="Regex that matches an include directive; group 1 is the file name")
    public static String include_re = "\\\\include\\{(.*)\\}";
    private static String usage_string = "TaskManger [options] <task-file> <task_file> ...";
    public static final String lineSep = System.getProperty("line.separator");
    public List<Task> tasks = new ArrayList<Task>();

    public TaskManager() {
    }

    public TaskManager(String[] filenames) throws IOException {
        for (String filename : filenames) {
            EntryReader.Entry entry;
            filename = UtilMDE.expandFilename(filename);
            EntryReader reader = new EntryReader(filename, comment_re, include_re);
            while ((entry = reader.get_entry()) != null) {
                try {
                    this.tasks.add(new Task(entry.body, entry.filename, entry.line_number));
                }
                catch (IOException e) {
                    throw new Error("Error parsing " + entry.filename + " at line " + entry.line_number, e);
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        Options options = new Options(usage_string, TaskManager.class);
        String[] filenames = options.parse_or_usage(args);
        if (verbose) {
            System.out.printf("Option settings: %s%n", options.settings());
        }
        if (filenames.length == 0) {
            options.print_usage("Error: No task files specified");
            System.exit(254);
        }
        TaskManager tm = new TaskManager(filenames);
        if (verbose) {
            System.out.printf("All tasks:%n", new Object[0]);
            for (Task task : tm.tasks) {
                System.out.printf("%s\n\n", task.all_vals());
            }
        }
        TaskManager matches = tm.responsible_match(responsible);
        matches = matches.milestone_match(milestone);
        if (open) {
            matches = matches.open_only();
        }
        if (completed) {
            matches = matches.completed_only();
        }
        switch (format) {
            case short_ascii: {
                System.out.println(matches.toString_short_ascii());
                break;
            }
            case short_html: {
                System.out.println(matches.toString_short_html());
                break;
            }
            case milestone_html: {
                System.out.println(matches.toString_milestone_html());
            }
        }
    }

    public String toString_short_ascii() {
        StringBuilder out = new StringBuilder();
        for (Task task : this.tasks) {
            out.append(task.toString_short_ascii() + lineSep);
        }
        return out.toString();
    }

    public String toString_short_html() {
        StringBuilder out = new StringBuilder();
        double total = 0.0;
        String responsible = null;
        out.append("<table>" + lineSep);
        for (Task task : this.tasks) {
            if (!task.responsible.equals(responsible)) {
                responsible = task.responsible;
                total = 0.0;
            }
            out.append(task.toString_short_html(total += (double)(task.duration.floatValue() - task.completed.floatValue())) + lineSep);
        }
        out.append("</table>" + lineSep);
        return out.toString();
    }

    public String toString_milestone_html() {
        StringBuilder out = new StringBuilder();
        out.append("<table border cellspacing=0 cellpadding=2>" + lineSep);
        out.append("<tr> <th> Responsible <th> C/D <th> Total <th> Task </tr>" + lineSep);
        double total = 0.0;
        String responsible = null;
        for (Task task : this.tasks) {
            if (!task.responsible.equals(responsible)) {
                if (responsible != null) {
                    out.append("<tr bgcolor=grey><td colspan=4></td></tr>" + lineSep);
                }
                responsible = task.responsible;
                total = 0.0;
            }
            out.append(task.toString_milestone_html(total += (double)(task.duration.floatValue() - task.completed.floatValue())) + lineSep);
        }
        out.append("</table>" + lineSep);
        return out.toString();
    }

    public void add(Task task) {
        this.tasks.add(task);
    }

    public TaskManager responsible_match(@Nullable String responsible) {
        TaskManager tm = new TaskManager();
        for (Task task : this.tasks) {
            if (responsible != null && !responsible.equalsIgnoreCase(task.responsible)) continue;
            tm.add(task);
        }
        return tm;
    }

    public TaskManager milestone_match(@Nullable String milestone) {
        TaskManager tm = new TaskManager();
        if (milestone == null) {
            return tm;
        }
        for (Task task : this.tasks) {
            if (!milestone.equalsIgnoreCase(task.milestone)) continue;
            tm.add(task);
        }
        return tm;
    }

    public TaskManager completed_only() {
        TaskManager tm = new TaskManager();
        for (Task task : this.tasks) {
            if (!(task.duration.floatValue() <= task.completed.floatValue())) continue;
            tm.add(task);
        }
        return tm;
    }

    public TaskManager open_only() {
        TaskManager tm = new TaskManager();
        for (Task task : this.tasks) {
            if (!(task.duration.floatValue() > task.completed.floatValue())) continue;
            tm.add(task);
        }
        return tm;
    }

    public static class Task {
        String filename;
        long line_number;
        String task;
        String responsible;
        @Nullable
        Date assigned_date;
        @Nullable
        String milestone;
        Float duration;
        Float completed;
        @Nullable
        String description;
        @Nullable
        String notes;

        private void checkRep() {
            assert (this.filename != null) : "No filename at line " + this.line_number;
            assert (this.task != null) : "No task at line " + this.line_number;
            assert (this.responsible != null) : "No responsible at line " + this.line_number;
            assert (this.duration != null) : "No duration at line " + this.line_number;
            assert (this.completed != null) : "No completed at line " + this.line_number;
        }

        public Task(String body, String filename, long line_number) throws IOException {
            this.filename = filename;
            this.line_number = line_number;
            String[] lines = body.split(lineSep);
            for (int ii = 0; ii < lines.length; ++ii) {
                String value;
                String item;
                String line = lines[ii];
                if (line.matches("^[_a-zA-Z]+:.*")) {
                    String[] sa = line.split(" *: *", 2);
                    item = sa[0];
                    value = sa[1];
                    if (value.length() == 0) {
                        value = null;
                    }
                } else if (line.matches("^[-a-zA-Z]+>.*")) {
                    String nline;
                    item = line.replaceFirst(" *>.*", "");
                    value = "";
                    ++ii;
                    while (ii < lines.length && !(nline = lines[ii]).equals("<" + item)) {
                        value = value + nline + lineSep;
                        ++ii;
                    }
                } else {
                    throw new IOException("malformed line: " + line);
                }
                if (item.equals("task")) {
                    if (value == null) {
                        throw new Error("Task with no value at line " + line_number);
                    }
                    this.task = value;
                    continue;
                }
                if (item.equals("responsible")) {
                    if (value == null) {
                        this.responsible = "none";
                        continue;
                    }
                    this.responsible = value;
                    continue;
                }
                if (item.equals("assigned_date")) {
                    if (value == null) {
                        this.assigned_date = null;
                        continue;
                    }
                    SimpleDateFormat df = new SimpleDateFormat("yy-MM-dd");
                    try {
                        this.assigned_date = df.parse(value);
                        if ($assertionsDisabled || this.assigned_date != null) continue;
                        throw new AssertionError((Object)value);
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                }
                if (item.equals("milestone")) {
                    if (value == null) {
                        throw new Error("Milestone with no value at line " + line_number);
                    }
                    this.milestone = value;
                    continue;
                }
                if (item.equals("duration")) {
                    if (value == null) {
                        throw new Error("Duration with no value at line " + line_number);
                    }
                    this.duration = Float.valueOf(Float.parseFloat(value));
                    continue;
                }
                if (item.equals("completed")) {
                    if (value == null) {
                        throw new Error("Completed with no value at line " + line_number);
                    }
                    this.completed = Float.valueOf(Float.parseFloat(value));
                    continue;
                }
                if (item.equals("description")) {
                    if (value == null) {
                        throw new Error("Description with no value at line " + line_number);
                    }
                    this.description = value;
                    continue;
                }
                if (item.equals("notes")) {
                    if (value == null) {
                        throw new Error("Notes with no value at line " + line_number);
                    }
                    this.notes = value;
                    continue;
                }
                throw new IOException("unknown field " + item);
            }
            this.checkRep();
        }

        public static String short_str(float f) {
            if ((double)f - Math.floor(f) > 0.1) {
                return String.format("%.1f", Float.valueOf(f));
            }
            return String.format("%d", Math.round(f));
        }

        private String completion_str() {
            return String.format("%s/%s", Task.short_str(this.completed.floatValue()), Task.short_str(this.duration.floatValue()));
        }

        public String toString_short_ascii() {
            return String.format("%-10s %-10s %-6s %s", this.responsible, this.milestone, this.completion_str(), this.task);
        }

        public String toString_short_html(double total) {
            return String.format("<tr> <td> %s </td><td> %s </td><td> %s </td><td> %f </td><td> %s </td></tr>", this.responsible, this.milestone, this.completion_str(), total, this.task);
        }

        public String toString_milestone_html(double total) {
            String resp_str = this.responsible;
            if (resp_str.equals("none")) {
                resp_str = "<font color=red><b>" + resp_str + "</b></font>";
            }
            return String.format("<tr> <td> %s </td><td> %s </td><td> %.1f </td><td><a href=%s?file=%s&line=%d> %s </a></td></tr>", resp_str, this.completion_str(), total, "show_task_details.php", this.filename, this.line_number, this.task);
        }

        public String all_vals() {
            StringBuilder out = new StringBuilder();
            out.append("task:            " + this.task + lineSep);
            out.append("responsible:     " + this.responsible + lineSep);
            out.append("assigned_date:   " + this.assigned_date + lineSep);
            out.append("milestone:       " + this.milestone + lineSep);
            out.append("duration:        " + this.duration + lineSep);
            out.append("completed:       " + this.completed + lineSep);
            out.append("description:     " + this.description + lineSep);
            out.append("notes:           " + this.notes + lineSep);
            return out.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputFormat {
        short_ascii,
        short_html,
        milestone_html;

    }
}

