/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.text.DecimalFormat;

public final class Stopwatch {
    long elapsedMillis = 0L;
    long startTime = 0L;
    private static DecimalFormat[] timeFormat = new DecimalFormat[]{new DecimalFormat("#.#"), new DecimalFormat("#.#"), new DecimalFormat("#.#"), new DecimalFormat("#.#"), new DecimalFormat("#.#")};

    public Stopwatch() {
        this(true);
    }

    public Stopwatch(boolean start) {
        if (start) {
            this.start();
        }
    }

    public void reset() {
        this.startTime = 0L;
        this.elapsedMillis = 0L;
        this.start();
    }

    public void clear() {
        this.startTime = 0L;
        this.elapsedMillis = 0L;
    }

    public void start() {
        if (this.startTime != 0L) {
            throw new Error("Stopwatch is not stopped");
        }
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        if (this.startTime == 0L) {
            throw new Error("Stopwatch is not started");
        }
        this.elapsedMillis += System.currentTimeMillis() - this.startTime;
        this.startTime = 0L;
    }

    public long snapshot() {
        return System.currentTimeMillis() - this.startTime;
    }

    public long elapsedMillis() {
        return this.elapsedMillis;
    }

    public double elapsedSeconds() {
        return (double)this.elapsedMillis / 1000.0;
    }

    public String stop_start() {
        this.stop();
        String result = this.format();
        this.start();
        return result;
    }

    public String format() {
        return this.format(1);
    }

    public String format(int digits) {
        long runningMillis = this.elapsedMillis;
        if (this.startTime != 0L) {
            runningMillis += System.currentTimeMillis() - this.startTime;
        }
        return timeFormat[digits].format((double)runningMillis / 1000.0) + "s";
    }
}

