/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.PrintStream;
import java.util.Stack;

public final class SimpleLog {
    public boolean enabled;
    public PrintStream logfile = System.out;
    public String indent_str = "";
    public String indent_str_one_level = "  ";
    public boolean always_traceback = false;
    public boolean line_oriented = true;
    public Stack<Long> start_times = new Stack();

    public SimpleLog(boolean enabled, boolean always_traceback) {
        this.enabled = enabled;
        this.always_traceback = always_traceback;
        this.push_start_time();
    }

    public SimpleLog(boolean enabled) {
        this(enabled, false);
    }

    public SimpleLog() {
        this(true);
    }

    public SimpleLog(String filename, boolean enabled) {
        this(enabled);
        try {
            this.logfile = new PrintStream(filename);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't open " + filename, e);
        }
    }

    public final boolean enabled() {
        return this.enabled;
    }

    public final void log(String format, Object ... args) {
        if (this.enabled) {
            format = this.add_newline(format);
            this.logfile.print(this.indent_str);
            this.logfile.printf(format, args);
            if (this.always_traceback) {
                this.tb();
            }
        }
    }

    public final void log_tb(String format, Object ... args) {
        if (this.enabled) {
            this.log(format, args);
            this.tb();
        }
    }

    public final void tb() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] ste_arr = t.getStackTrace();
        for (int ii = 2; ii < ste_arr.length; ++ii) {
            StackTraceElement ste = ste_arr[ii];
            this.logfile.printf("%s  %s%n", this.indent_str, ste);
        }
    }

    private final String add_newline(String format) {
        if (!this.line_oriented) {
            return format;
        }
        if (format.endsWith("%n")) {
            return format;
        }
        return format + "%n";
    }

    public final void indent() {
        if (this.enabled) {
            this.indent_str = this.indent_str + this.indent_str_one_level;
            this.push_start_time();
        }
    }

    public final void indent(String format, Object ... args) {
        if (this.enabled) {
            this.log(format, args);
            this.indent();
        }
    }

    public final void clear() {
        if (this.enabled) {
            this.indent_str = "";
            this.start_times.clear();
            this.push_start_time();
        }
    }

    public final void clear(String format, Object ... args) {
        if (this.enabled) {
            this.clear();
            this.log(format, args);
        }
    }

    public final void exdent() {
        if (this.enabled) {
            this.indent_str = this.indent_str.substring(0, this.indent_str.length() - this.indent_str_one_level.length());
            this.pop_start_time();
        }
    }

    @Deprecated
    public final void exdent(String format, Object ... args) {
        if (this.enabled) {
            this.exdent();
            this.log(format, args);
        }
    }

    public final void exdent_time(String format, Object ... args) {
        if (this.enabled) {
            this.log_time(format, args);
            this.exdent();
        }
    }

    @Deprecated
    public final void start_time() {
        this.reset_start_time();
    }

    public final void reset_start_time() {
        if (this.enabled) {
            this.pop_start_time();
            this.push_start_time();
        }
    }

    public final void push_start_time() {
        if (this.enabled) {
            this.start_times.push(System.currentTimeMillis());
        }
    }

    public final void pop_start_time() {
        this.start_times.pop();
    }

    public final void log_time(String format, Object ... args) {
        if (this.enabled) {
            Long start_time = this.start_times.peek();
            if (start_time == null) {
                throw new Error("Too many pops before calling log_time");
            }
            long elapsed = System.currentTimeMillis() - start_time;
            this.logfile.print(this.indent_str);
            if (elapsed > 1000L) {
                this.logfile.printf("[%,f secs] ", (double)elapsed / 1000.0);
            } else {
                this.logfile.print("[" + elapsed + " ms] ");
            }
            format = this.add_newline(format);
            this.logfile.printf(format, args);
        }
    }
}

