/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomSelector<T> {
    private int num_elts = -1;
    private int observed;
    private Random generator;
    private ArrayList<T> values = new ArrayList();
    private boolean coin_toss_mode = false;
    private double keep_probability = -1.0;

    public RandomSelector(int num_elts) {
        this(num_elts, new Random());
    }

    public RandomSelector(int num_elts, Random r) {
        this.num_elts = num_elts;
        this.observed = 0;
        this.generator = r;
    }

    public RandomSelector(double keep_probability, Random r) {
        this.keep_probability = keep_probability;
        this.coin_toss_mode = true;
        this.observed = 0;
        this.generator = r;
    }

    public void accept(T next) {
        int n;
        if (this.coin_toss_mode) {
            if (this.generator.nextDouble() < this.keep_probability) {
                this.values.add(next);
            }
            return;
        }
        ++this.observed;
        if (this.generator.nextDouble() < (double)this.num_elts / (double)n) {
            if (this.values.size() < this.num_elts) {
                this.values.add(next);
            } else {
                int rem = (int)((double)this.values.size() * this.generator.nextDouble());
                this.values.set(rem, next);
            }
        }
    }

    public List<T> getValues() {
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(this.values);
        return ret;
    }
}

