/*
 * Decompiled with CFR 0.152.
 */
package plume;

import checkers.nullness.quals.NonNull;
import checkers.nullness.quals.Nullable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import plume.EntryReader;
import plume.Option;
import plume.Options;
import plume.Pair;
import plume.TimeLimitProcess;
import plume.UtilMDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVersionControl {
    @NonNull
    static final String userHome = System.getProperty("user.home");
    @Option(value="File with list of checkouts.  Set it to /dev/null to suppress reading.", noDocDefault=true)
    public String checkouts = new File(userHome, ".mvc-checkouts").getPath();
    @Option(value="Directory under which to search for checkouts; default=home dir")
    public List<String> dir = new ArrayList<String>();
    @Option(value="Directory under which to NOT search for checkouts")
    public List<String> ignore_dir = new ArrayList<String>();
    private List<File> ignoreDirs = new ArrayList<File>();
    @Option(value="Search for all checkouts, not just those listed in a file")
    public boolean search = false;
    @Option(value="Display commands as they are executed")
    public boolean show;
    @Option(value="Print the directory before executing commands")
    public boolean print_directory;
    @Option(value="Do not execute commands; just print them.  Implies --show --redo-existing")
    public boolean dry_run;
    @Option(value="Redo existing checkouts; relevant only to checkout command")
    public boolean redo_existing;
    @Option(value="Timeout for each command, in seconds")
    public int timeout = 600;
    @Option(value="-q Run quietly (e.g., no output about missing directories)")
    public boolean quiet = true;
    @Option(value="Print debugging output")
    public static boolean debug;
    @Option(value="Debug 'replacers' that filter command output")
    public boolean debug_replacers;
    private static Action CHECKOUT;
    private static Action STATUS;
    private static Action UPDATE;
    private static Action LIST;
    private Action action;
    static IsDirectoryFilter idf;

    public static void main(String[] args) {
        MultiVersionControl.setupSVNKIT();
        MultiVersionControl mvc = new MultiVersionControl(args);
        LinkedHashSet<Checkout> checkouts = new LinkedHashSet<Checkout>();
        try {
            MultiVersionControl.readCheckouts(new File(mvc.checkouts), checkouts);
        }
        catch (IOException e) {
            System.err.println("Problem reading file " + mvc.checkouts + ": " + e.getMessage());
        }
        if (mvc.search) {
            for (String adir : mvc.ignore_dir) {
                File afile = new File(adir.replaceFirst("^~", userHome));
                if (!afile.exists()) {
                    System.err.printf("Warning: Directory to ignore while searching for checkouts does not exist:%n  %s%n", adir);
                    continue;
                }
                if (!afile.isDirectory()) {
                    System.err.printf("Warning: Directory to ignore while searching for checkouts is not a directory:%n  %s%n", adir);
                    continue;
                }
                mvc.ignoreDirs.add(afile);
            }
            for (String adir : mvc.dir) {
                adir = adir.replaceFirst("^~", userHome);
                if (debug) {
                    System.out.println("Searching for checkouts under " + adir);
                }
                if (!new File(adir).isDirectory()) {
                    System.err.printf("Directory in which to search for checkouts is not a directory: %s%n", adir);
                    System.exit(2);
                }
                MultiVersionControl.findCheckouts(new File(adir), checkouts, mvc.ignoreDirs);
            }
        }
        if (debug) {
            System.out.println("Processing checkouts read from " + checkouts);
        }
        mvc.process(checkouts);
    }

    private static void setupSVNKIT() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    private MultiVersionControl() {
    }

    public MultiVersionControl(String[] args) {
        this.parseArgs(args);
    }

    public void parseArgs(String[] args) {
        String action_string;
        Options options = new Options("mvc [options] {checkout,status,update,list}", this);
        Object[] remaining_args = options.parse_or_usage(args);
        if (remaining_args.length != 1) {
            options.print_usage("Please supply exactly one argument (found %d)%n%s", remaining_args.length, UtilMDE.join(remaining_args, " "));
            System.exit(1);
        }
        if ("checkout".startsWith(action_string = remaining_args[0])) {
            this.action = CHECKOUT;
        } else if ("status".startsWith(action_string)) {
            this.action = STATUS;
        } else if ("update".startsWith(action_string)) {
            this.action = UPDATE;
        } else if ("list".startsWith(action_string)) {
            this.action = LIST;
        } else {
            options.print_usage("Unrecognized action \"%s\"", action_string);
            System.exit(1);
        }
        if (this.dir.isEmpty()) {
            this.dir.add(userHome);
        }
        if (this.dry_run) {
            this.show = true;
            this.redo_existing = true;
        }
        if (this.action == CHECKOUT) {
            this.search = false;
            this.show = true;
            this.timeout *= 10;
        }
        if (debug) {
            this.show = true;
        }
    }

    static void readCheckouts(File file, Set<Checkout> checkouts) throws IOException {
        RepoType currentType = RepoType.BZR;
        String currentRoot = null;
        boolean currentRootIsRepos = false;
        EntryReader er = new EntryReader(file);
        for (String line : er) {
            String dirname;
            String root;
            if (debug) {
                System.out.println("line: " + line);
            }
            if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
            String[] splitTwo = line.split("[ \t]+");
            if (debug) {
                System.out.println("split length: " + splitTwo.length);
            }
            if (splitTwo.length == 2) {
                String word1 = splitTwo[0];
                String word2 = splitTwo[1];
                if (word1.equals("BZRROOT:") || word1.equals("BZRREPOS:")) {
                    currentType = RepoType.BZR;
                    currentRoot = word2;
                    currentRootIsRepos = word1.equals("BZRREPOS:");
                    continue;
                }
                if (word1.equals("CVSROOT:")) {
                    String[] rootWords;
                    String possibleRoot;
                    currentType = RepoType.CVS;
                    currentRoot = word2;
                    currentRootIsRepos = false;
                    if (!currentRoot.startsWith(":ext:") || !new File(possibleRoot = (rootWords = currentRoot.split(":"))[rootWords.length - 1]).isDirectory()) continue;
                    currentRoot = possibleRoot;
                    continue;
                }
                if (word1.equals("HGROOT:") || word1.equals("HGREPOS:")) {
                    currentType = RepoType.HG;
                    currentRoot = word2;
                    currentRootIsRepos = word1.equals("HGREPOS:");
                    continue;
                }
                if (word1.equals("GITROOT:") || word1.equals("GITREPOS:")) {
                    currentType = RepoType.GIT;
                    currentRoot = word2;
                    currentRootIsRepos = word1.equals("GITREPOS:");
                    continue;
                }
                if (word1.equals("SVNROOT:") || word1.equals("SVNREPOS:")) {
                    currentType = RepoType.SVN;
                    currentRoot = word2;
                    currentRootIsRepos = word1.equals("SVNREPOS:");
                    continue;
                }
            }
            if (currentRoot == null) {
                System.err.printf("need root before directory at line %d of file %s%n", er.getLineNumber(), er.getFileName());
                System.exit(1);
            }
            if ((root = currentRoot).endsWith("/")) {
                root = root.substring(0, root.length() - 1);
            }
            String module = null;
            int spacePos = line.lastIndexOf(32);
            if (spacePos == -1) {
                dirname = line;
            } else {
                dirname = line.substring(0, spacePos);
                module = line.substring(spacePos + 1);
            }
            File dir = new File(dirname.replaceFirst("^~", userHome));
            if (module == null) {
                module = dir.getName();
            }
            if (currentType != RepoType.CVS) {
                if (!currentRootIsRepos) {
                    root = root + "/" + module;
                }
                module = null;
            }
            Checkout checkout = new Checkout(currentType, dir, root, module);
            checkouts.add(checkout);
        }
    }

    private static void findCheckouts(File dir, Set<Checkout> checkouts, List<File> ignoreDirs) {
        File[] childdirs;
        if (!dir.isDirectory()) {
            return;
        }
        if (ignoreDirs.contains(dir)) {
            return;
        }
        String dirName = dir.getName().toString();
        File parent = dir.getParentFile();
        if (parent != null) {
            if (dirName.equals(".bzr")) {
                checkouts.add(new Checkout(RepoType.BZR, parent, null, null));
                return;
            }
            if (dirName.equals("CVS")) {
                MultiVersionControl.addCheckoutCvs(dir, parent, checkouts);
                return;
            }
            if (dirName.equals(".hg")) {
                checkouts.add(MultiVersionControl.dirToCheckoutHg(dir, parent));
                return;
            }
            if (dirName.equals(".svn")) {
                checkouts.add(MultiVersionControl.dirToCheckoutSvn(parent));
                return;
            }
        }
        if ((childdirs = dir.listFiles(idf)) == null) {
            System.err.printf("childdirs is null (permission or other I/O problem?) for %s%n", dir.toString());
            return;
        }
        for (File childdir : childdirs) {
            MultiVersionControl.findCheckouts(childdir, checkouts, ignoreDirs);
        }
    }

    static void addCheckoutCvs(File cvsDir, File dir, Set<Checkout> checkouts) {
        assert (cvsDir.getName().toString().equals("CVS")) : cvsDir.getName();
        File repositoryFile = new File(cvsDir, "Repository");
        File rootFile = new File(cvsDir, "Root");
        if (!repositoryFile.exists() || !rootFile.exists()) {
            return;
        }
        String pathInRepo = UtilMDE.readFile(repositoryFile).trim();
        String repoRoot = UtilMDE.readFile(rootFile).trim();
        File repoFileRoot = new File(pathInRepo);
        while (repoFileRoot.getParentFile() != null) {
            File newRepoFileRoot;
            repoFileRoot = newRepoFileRoot = repoFileRoot.getParentFile();
        }
        Pair<File, File> stripped = MultiVersionControl.removeCommonSuffixDirs(dir, new File(pathInRepo), repoFileRoot, "CVS");
        File cDir = (File)stripped.a;
        if (cDir == null) {
            System.out.printf("dir (%s) is parent of path in repo (%s)", dir, pathInRepo);
            System.exit(1);
        }
        String pathInRepoAtCheckout = stripped.b != null ? ((File)stripped.b).toString() : cDir.getName();
        checkouts.add(new Checkout(RepoType.CVS, cDir, repoRoot, pathInRepoAtCheckout));
    }

    static Checkout dirToCheckoutHg(File hgDir, File dir) {
        String repository = null;
        File hgrcFile = new File(hgDir, "hgrc");
        if (hgrcFile.exists()) {
            Ini ini;
            try {
                ini = new Ini(new FileReader(hgrcFile));
            }
            catch (IOException e) {
                throw new Error("Problem reading file " + hgrcFile);
            }
            Profile.Section pathsSection = (Profile.Section)ini.get("paths");
            if (pathsSection != null && (repository = (String)pathsSection.get("default")) != null && repository.endsWith("/")) {
                repository = repository.substring(0, repository.length() - 1);
            }
        }
        return new Checkout(RepoType.HG, dir, repository, null);
    }

    static Checkout dirToCheckoutGit(File gitDir, File dir) {
        String repository = UtilMDE.backticks("git", "config", "remote.origin.url");
        return new Checkout(RepoType.GIT, dir, repository, null);
    }

    static Checkout dirToCheckoutSvn(File dir) {
        SVNInfo info;
        SVNWCClient wcClient = new SVNWCClient((ISVNAuthenticationManager)null, null);
        try {
            info = wcClient.doInfo(new File(dir.toString()), SVNRevision.WORKING);
        }
        catch (SVNException e) {
            throw new Error("Problem in dirToCheckoutSvn(" + dir + "): ", e);
        }
        SVNURL url = info.getURL();
        SVNURL repoRoot = info.getRepositoryRootURL();
        if (repoRoot == null) {
            System.err.println("Problem:  old svn working copy in " + dir.toString());
            System.err.println("Check it out again to get a 'Repository Root' entry in the svn info output.");
            System.err.println("  repoUrl = " + url);
            System.exit(2);
        }
        if (debug) {
            System.out.println();
            System.out.println("repoRoot = " + repoRoot);
            System.out.println(" repoUrl = " + url);
            System.out.println("     dir = " + dir.toString());
        }
        Pair<File, File> stripped = MultiVersionControl.removeCommonSuffixDirs(dir, new File(url.getPath()), new File(repoRoot.getPath()), ".svn");
        File cDir = (File)stripped.a;
        if (cDir == null) {
            System.out.printf("dir (%s) is parent of repository URL (%s)", dir, url.getPath());
            System.exit(1);
        }
        if (stripped.b == null) {
            System.out.printf("dir (%s) is child of repository URL (%s)", dir, url.getPath());
            System.exit(1);
        }
        String pathInRepoAtCheckout = ((File)stripped.b).toString();
        try {
            url = url.setPath(pathInRepoAtCheckout, false);
        }
        catch (SVNException e) {
            throw new Error(e);
        }
        if (debug) {
            System.out.println("stripped: " + stripped);
            System.out.println("repoRoot = " + repoRoot);
            System.out.println(" repoUrl = " + url);
            System.out.println("    cDir = " + cDir.toString());
        }
        assert (url.toString().startsWith(repoRoot.toString())) : "repoRoot=" + repoRoot + ", url=" + url;
        return new Checkout(RepoType.SVN, cDir, url.toString(), null);
    }

    static Pair<File, File> removeCommonSuffixDirs(File p1, File p2, File p2_limit, String p1_contains) {
        File r2;
        if (debug) {
            System.out.printf("removeCommonSuffixDirs(%s, %s, %s, %s)%n", p1, p2, p2_limit, p1_contains);
        }
        File r1 = p1;
        for (r2 = p2; !(r1 == null || r2 == null || p2_limit != null && r2.equals(p2_limit) || !r1.getName().equals(r2.getName()) || p1_contains != null && !new File(r1.getParentFile(), p1_contains).isDirectory()); r1 = r1.getParentFile(), r2 = r2.getParentFile()) {
        }
        if (debug) {
            System.out.printf("removeCommonSuffixDirs => %s %s%n", r1, r2);
        }
        return Pair.of(r1, r2);
    }

    public void process(Set<Checkout> checkouts) {
        ProcessBuilder pb = new ProcessBuilder("");
        ProcessBuilder pb2 = new ProcessBuilder(new ArrayList<String>());
        ProcessBuilder pb3 = new ProcessBuilder(new ArrayList<String>());
        pb.redirectErrorStream(true);
        pb2.redirectErrorStream(true);
        pb3.redirectErrorStream(true);
        block38: for (Checkout c : checkouts) {
            if (debug) {
                System.out.println(c);
            }
            File dir = c.directory;
            ArrayList<Replacer> replacers = new ArrayList<Replacer>();
            ArrayList<Replacer> replacers3 = new ArrayList<Replacer>();
            switch (c.repoType) {
                case BZR: {
                    break;
                }
                case CVS: {
                    replacers.add(new Replacer("(^|\\n)([?]) ", "$1$2 " + dir + "/"));
                    break;
                }
                case GIT: {
                    replacers.add(new Replacer("(^|\\n)fatal:", "$1fatal in " + dir + ":"));
                    break;
                }
                case HG: {
                    replacers.add(new Replacer("(^|\\n)real URL is .*\\n", "$1"));
                    replacers.add(new Replacer("(^|\\n)(abort: .*)", "$1$2: " + dir));
                    replacers.add(new Replacer("(^|\\n)([MARC!?I]) ", "$1$2 " + dir + "/"));
                    replacers.add(new Replacer("(^|\\n)(\\*\\*\\* failed to import extension .*: No module named demandload\\n)", "$1"));
                    replacers.add(new Replacer("(^|\\n)(abort: repository default(-push)? not found!: .*\\n)", ""));
                    break;
                }
                case SVN: {
                    replacers.add(new Replacer("(svn: Network connection closed unexpectedly)", "$1 for " + dir));
                    replacers.add(new Replacer("(svn: Repository) (UUID)", "$1 " + dir + " $2"));
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            replacers.add(new Replacer("(remote: )?Warning: untrusted X11 forwarding setup failed: xauth key data not generated\r*\n(remote: )?Warning: No xauth data; using fake authentication data for X11 forwarding\\.\r*\n", ""));
            replacers.add(new Replacer("(working copy ')", "$1" + dir));
            pb.command("echo", "command", "not", "set");
            pb.directory(dir);
            pb2.command(new ArrayList<String>());
            pb2.directory(dir);
            pb3.command(new ArrayList<String>());
            pb3.directory(dir);
            boolean show_normal_output = false;
            block7 : switch (this.action) {
                case LIST: {
                    System.out.println(c);
                    continue block38;
                }
                case CHECKOUT: {
                    pb.directory(dir.getParentFile());
                    String dirbase = dir.getName();
                    if (c.repository == null) {
                        System.out.printf("Skipping checkout with unknown repository:%n  %s%n", dir);
                        continue block38;
                    }
                    switch (c.repoType) {
                        case BZR: {
                            throw new Error("not yet implemented");
                        }
                        case CVS: {
                            assert (c.module != null) : "@SuppressWarnings(nullness): dependent type CVS";
                            pb.command("cvs", "-d", c.repository, "checkout", "-P", "-ko", c.module);
                            break block7;
                        }
                        case GIT: {
                            pb.command("git", "clone", c.repository, dirbase);
                            break block7;
                        }
                        case HG: {
                            pb.command("hg", "clone", c.repository, dirbase);
                            break block7;
                        }
                        case SVN: {
                            if (c.module != null) {
                                pb.command("svn", "checkout", c.repository, c.module);
                                break block7;
                            }
                            pb.command("svn", "checkout", c.repository);
                            break block7;
                        }
                    }
                    assert (false);
                    break;
                }
                case STATUS: {
                    show_normal_output = true;
                    switch (c.repoType) {
                        case BZR: {
                            throw new Error("not yet implemented");
                        }
                        case CVS: {
                            assert (c.repository != null);
                            pb.command("cvs", "-q", "diff", "-b", "--brief", "-N");
                            String removeRegexp = "\n=+\nRCS file: .*(\nretrieving revision .*)?\ndiff .*(\nFiles .* and .* differ)?";
                            replacers.add(new Replacer(removeRegexp, ""));
                            replacers.add(new Replacer("(^|\\n)Index: ", "$1" + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)(cvs \\[diff aborted)(\\]:)", "$1$2 in " + dir + "$3"));
                            replacers.add(new Replacer("(^|\\n)(Permission denied)", "$1$2 in " + dir));
                            replacers.add(new Replacer("(^|\\n)(cvs diff: cannot find )", "$1$2" + dir));
                            replacers.add(new Replacer("(^|\\n)(cvs diff: in directory )", "$1$2" + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)(cvs diff: ignoring )", "$1$2" + dir + "/"));
                            break block7;
                        }
                        case GIT: {
                            pb.command("git", "status");
                            replacers.add(new Replacer("(^|\\n)nothing to commit \\(working directory clean\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)no changes added to commit \\(use \"git add\" and/or \"git commit -a\"\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)nothing added to commit but untracked files present \\(use \"git add\" to track\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)#\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)# On branch master\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)# Changed but not updated:\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)#   \\(use \"git add <file>...\" to update what will be committed\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)#   \\(use \"git checkout -- <file>...\" to discard changes in working directory\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)# Untracked files:\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)#   \\(use \"git add <file>...\" to include in what will be committed\\)\\n", "$1"));
                            replacers.add(new Replacer("(^|\\n)(#\tmodified:   )", "$1" + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)(#\t)", "$1untracked: " + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)# Your branch is ahead of .*\\n", "$1unpushed changesets: " + pb.directory() + "\n"));
                            break block7;
                        }
                        case HG: {
                            pb.command("hg", "status");
                            pb2.command("hg", "outgoing", "-l", "1");
                            replacers.add(new Replacer("^comparing with .*\\nsearching for changes\\nchangeset[^\u0001]*", "unpushed changesets: " + pb.directory() + "\n"));
                            replacers.add(new Replacer("^\\n?comparing with .*\\nsearching for changes\\nno changes found\n", ""));
                            pb3.command("hg", "shelve", "-l");
                            replacers3.add(new Replacer("^hg: unknown command 'shelve'\\n(.*\\n)+", ""));
                            replacers3.add(new Replacer("^(.*\\n)+", "shelved changes: " + pb.directory() + "\n"));
                            break block7;
                        }
                        case SVN: {
                            replacers.add(new Replacer("(^|\\n)([ACDIMRX?!~ ][CM ][L ][+ ][$ ]) *", "$1$2 " + dir + "/"));
                            pb.command("svn", "status");
                            break block7;
                        }
                    }
                    assert (false);
                    break;
                }
                case UPDATE: {
                    switch (c.repoType) {
                        case BZR: {
                            throw new Error("not yet implemented");
                        }
                        case CVS: {
                            replacers.add(new Replacer("(^|\\n)(cvs update: ((in|skipping) directory|conflicts found in )) +", "$1$2 " + dir + "/"));
                            replacers.add(new Replacer("(^|\\n)(Merging differences between 1.16 and 1.17 into )", "$1$2 " + dir + "/"));
                            assert (c.repository != null);
                            pb.command("cvs", "-Q", "update", "-d");
                            replacers.add(new Replacer("(cvs update: move away )", "$1" + dir + "/"));
                            replacers.add(new Replacer("(cvs \\[update aborted)(\\])", "$1 in " + dir + "$2"));
                            break block7;
                        }
                        case GIT: {
                            replacers.add(new Replacer("(^|\\n)Already up-to-date\\.\\n", "$1"));
                            pb.command("git", "pull", "-q");
                            break block7;
                        }
                        case HG: {
                            replacers.add(new Replacer("(^|\\n)([?!AMR] ) +", "$1$2 " + dir + "/"));
                            pb.command("hg", "-q", "update");
                            pb2.command("hg", "-q", "fetch");
                            break block7;
                        }
                        case SVN: {
                            replacers.add(new Replacer("(^|\\n)([?!AMR] ) +", "$1$2 " + dir + "/"));
                            replacers.add(new Replacer("(svn: Failed to add file ')(.*')", "$1" + dir + "/" + "$2"));
                            assert (c.repository != null);
                            pb.command("svn", "-q", "update");
                            break block7;
                        }
                    }
                    assert (false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (debug) {
                System.out.println(dir + ":");
            }
            if (dir.exists()) {
                if (this.action == CHECKOUT && !this.redo_existing && !this.quiet) {
                    System.out.println("Skipping checkout (dir already exists): " + dir);
                    continue;
                }
            } else {
                File parent = dir.getParentFile();
                if (parent == null) {
                    System.err.printf("Directory %s does not exist, nor does its parent%n", dir);
                    continue;
                }
                switch (this.action) {
                    case CHECKOUT: {
                        if (parent.exists()) break;
                        if (this.show) {
                            System.out.printf("Parent directory %s does not exist%s%n", parent, this.dry_run ? "" : " (creating)");
                        }
                        if (this.dry_run || parent.mkdirs()) break;
                        System.err.println("Could not create directory: " + parent);
                        System.exit(1);
                        break;
                    }
                    case STATUS: 
                    case UPDATE: {
                        if (this.quiet) continue block38;
                        System.out.println("Cannot find directory: " + dir);
                        continue block38;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            if (this.print_directory) {
                System.out.println(dir + " :");
            }
            this.perform_command(pb, replacers, show_normal_output);
            if (pb2.command().size() > 0) {
                this.perform_command(pb2, replacers, show_normal_output);
            }
            if (pb3.command().size() <= 0) continue;
            this.perform_command(pb3, replacers3, show_normal_output);
        }
    }

    void perform_command(ProcessBuilder pb, List<Replacer> replacers, boolean show_normal_output) {
        if (this.show) {
            System.out.println(this.command(pb));
        }
        if (this.dry_run) {
            return;
        }
        try {
            TimeLimitProcess p = new TimeLimitProcess(pb.start(), this.timeout * 1000, true);
            p.waitFor();
            if (p.timed_out()) {
                System.out.printf("Timed out (limit: %ss):%n", this.timeout);
                System.out.println(this.command(pb));
            }
            if (show_normal_output || p.exitValue() != 0 || this.debug_replacers) {
                String output = UtilMDE.streamString(p.getInputStream());
                if (this.debug_replacers) {
                    System.out.println("preoutput=<<<" + output + ">>>");
                }
                for (Replacer r : replacers) {
                    output = r.replaceAll(output);
                    if (!this.debug_replacers) continue;
                    System.out.println("midoutput[" + r.regexp + "]=<<<" + output + ">>>");
                }
                if (this.debug_replacers) {
                    System.out.println("postoutput=<<<" + output + ">>>");
                    for (int i = 0; i < Math.min(100, output.length()); ++i) {
                        System.out.println(i + ": " + output.charAt(i) + "\n        \"" + output.charAt(i) + "\"");
                    }
                }
                System.out.print(output);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
    }

    String command(ProcessBuilder pb) {
        return "  cd " + pb.directory() + "\n" + "  " + UtilMDE.join(pb.command(), " ");
    }

    static {
        CHECKOUT = Action.CHECKOUT;
        STATUS = Action.STATUS;
        UPDATE = Action.UPDATE;
        LIST = Action.LIST;
        idf = new IsDirectoryFilter();
    }

    static class StreamOfNewlines
    extends InputStream {
        StreamOfNewlines() {
        }

        public int read() {
            return 10;
        }
    }

    private class Replacer {
        String regexp;
        String replacement;

        public Replacer(String regexp, String replacement) {
            this.regexp = regexp;
            this.replacement = replacement;
        }

        public String replaceAll(String s) {
            return s.replaceAll(this.regexp, this.replacement);
        }
    }

    static class IsDirectoryFilter
    implements FileFilter {
        IsDirectoryFilter() {
        }

        public boolean accept(File pathname) {
            try {
                return pathname.isDirectory() && pathname.getPath().equals(pathname.getCanonicalPath());
            }
            catch (IOException e) {
                System.err.printf("Exception in IsDirectoryFilter.accept(%s): %s%n", pathname, e);
                throw new Error(e);
            }
        }
    }

    static class Checkout {
        RepoType repoType;
        File directory;
        @Nullable
        String repository;
        @Nullable
        String module;

        Checkout(RepoType repoType, File directory) {
            this(repoType, directory, null, null);
        }

        Checkout(RepoType repoType, File directory, @Nullable String repository, @Nullable String module) {
            assert (!directory.exists() || directory.isDirectory()) : "Not a directory: " + directory;
            this.repoType = repoType;
            this.directory = directory;
            this.repository = repository;
            this.module = module;
            switch (repoType) {
                case BZR: {
                    this.assertSubdirExists(directory, ".bzr");
                    assert (module == null);
                    break;
                }
                case CVS: {
                    this.assertSubdirExists(directory, "CVS");
                    assert (module != null) : "No module for CVS checkout at: " + directory;
                    break;
                }
                case GIT: {
                    this.assertSubdirExists(directory, ".git");
                    assert (module == null);
                    break;
                }
                case HG: {
                    this.assertSubdirExists(directory, ".hg");
                    assert (module == null);
                    break;
                }
                case SVN: {
                    this.assertSubdirExists(directory, ".svn");
                    assert (module == null);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void assertSubdirExists(File directory, String subdirName) {
            if (directory.exists() && !new File(directory, subdirName).isDirectory()) {
                System.err.printf("Directory %s exists but %s subdirectory does not exist%n", directory, subdirName);
                System.exit(2);
            }
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof Checkout)) {
                return false;
            }
            Checkout c2 = (Checkout)other;
            return this.repoType == c2.repoType && this.directory.equals(c2.directory) && (this.repository == null ? this.repository == c2.repository : this.repository.equals(c2.repository)) && (this.module == null ? this.module == c2.module : this.module.equals(c2.module));
        }

        public int hashCode() {
            return this.repoType.hashCode() + this.directory.hashCode() + (this.repository == null ? 0 : this.repository.hashCode()) + (this.module == null ? 0 : this.module.hashCode());
        }

        public String toString() {
            return (Object)((Object)this.repoType) + " " + this.directory + " " + this.repository + " " + this.module;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RepoType {
        BZR,
        CVS,
        GIT,
        HG,
        SVN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        CHECKOUT,
        STATUS,
        UPDATE,
        LIST;

    }
}

