/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import plume.ArraysMDE;
import plume.UtilMDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MathMDE {
    private MathMDE() {
        throw new Error("do not instantiate");
    }

    public static int negate(int a) {
        return -a;
    }

    public static long negate(long a) {
        return -a;
    }

    public static double negate(double a) {
        return -a;
    }

    public static int bitwiseComplement(int a) {
        return ~a;
    }

    public static long bitwiseComplement(long a) {
        return a ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static int mul(int x, int y) {
        return x * y;
    }

    public static long mul(long x, long y) {
        return x * y;
    }

    public static double mul(double x, double y) {
        return x * y;
    }

    public static int div(int x, int y) {
        return x / y;
    }

    public static long div(long x, long y) {
        return x / y;
    }

    public static double div(double x, double y) {
        return x / y;
    }

    public static int mod(int x, int y) {
        return x % y;
    }

    public static long mod(long x, long y) {
        return x % y;
    }

    public static int lshift(int x, int y) {
        return x << y;
    }

    public static long lshift(long x, long y) {
        return x << (int)y;
    }

    public static int rshiftSigned(int x, int y) {
        return x >> y;
    }

    public static long rshiftSigned(long x, long y) {
        return x >> (int)y;
    }

    public static int rshiftUnsigned(int x, int y) {
        return x >>> y;
    }

    public static long rshiftUnsigned(long x, long y) {
        return x >>> (int)y;
    }

    public static int bitwiseAnd(int x, int y) {
        return x & y;
    }

    public static long bitwiseAnd(long x, long y) {
        return x & y;
    }

    public static int logicalAnd(int x, int y) {
        return x != 0 && y != 0 ? 1 : 0;
    }

    public static long logicalAnd(long x, long y) {
        return x != 0L && y != 0L ? 1L : 0L;
    }

    public static int bitwiseXor(int x, int y) {
        return x ^ y;
    }

    public static long bitwiseXor(long x, long y) {
        return x ^ y;
    }

    public static int logicalXor(int x, int y) {
        return x != 0 ^ y != 0 ? 1 : 0;
    }

    public static long logicalXor(long x, long y) {
        return x != 0L ^ y != 0L ? 1L : 0L;
    }

    public static int bitwiseOr(int x, int y) {
        return x | y;
    }

    public static long bitwiseOr(long x, long y) {
        return x | y;
    }

    public static int logicalOr(int x, int y) {
        return x != 0 || y != 0 ? 1 : 0;
    }

    public static long logicalOr(long x, long y) {
        return x != 0L || y != 0L ? 1L : 0L;
    }

    public static int sign(int a) {
        if (a == 0) {
            return 0;
        }
        if (a > 0) {
            return 1;
        }
        return -1;
    }

    public static int pow(int base, int expt) throws ArithmeticException {
        return MathMDE.pow_fast(base, expt);
    }

    public static long pow(long base, long expt) throws ArithmeticException {
        return MathMDE.pow_fast(base, expt);
    }

    private static int pow_fast(int base, int expt) throws ArithmeticException {
        if (expt < 0) {
            throw new ArithmeticException("Negative exponent passed to pow");
        }
        int this_square_pow = base;
        int result = 1;
        while (expt > 0) {
            if ((expt & 1) != 0) {
                result *= this_square_pow;
            }
            expt >>= 1;
            this_square_pow *= this_square_pow;
        }
        return result;
    }

    private static long pow_fast(long base, long expt) throws ArithmeticException {
        if (expt < 0L) {
            throw new ArithmeticException("Negative exponent passed to pow");
        }
        long this_square_pow = base;
        long result = 1L;
        while (expt > 0L) {
            if ((expt & 1L) != 0L) {
                result *= this_square_pow;
            }
            expt >>= 1;
            this_square_pow *= this_square_pow;
        }
        return result;
    }

    private static int pow_slow(int base, int expt) throws ArithmeticException {
        if (expt < 0) {
            throw new ArithmeticException("Negative exponent passed to pow");
        }
        int result = 1;
        for (int i = 0; i < expt; ++i) {
            result *= base;
        }
        return result;
    }

    public static int gcd(int a, int b) {
        if (b == 0) {
            return Math.abs(a);
        }
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0) {
            int tmp = b;
            b = a % b;
            a = tmp;
        }
        return a;
    }

    public static int gcd(int[] a) {
        if (a.length == 0) {
            return 0;
        }
        int result = a[0];
        for (int i = 1; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i], result)) != 1 && result != 0) continue;
            return result;
        }
        return result;
    }

    public static int gcd_differences(int[] a) {
        if (a.length < 2) {
            return 0;
        }
        int result = a[1] - a[0];
        for (int i = 2; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i] - a[i - 1], result)) != 1 && result != 0) continue;
            return result;
        }
        return result;
    }

    public static long gcd(long a, long b) {
        if (b == 0L) {
            return Math.abs(a);
        }
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0L) {
            long tmp = b;
            b = a % b;
            a = tmp;
        }
        return a;
    }

    public static long gcd(long[] a) {
        if (a.length == 0) {
            return 0L;
        }
        long result = a[0];
        for (int i = 1; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i], result)) != 1L && result != 0L) continue;
            return result;
        }
        return result;
    }

    public static long gcd_differences(long[] a) {
        if (a.length < 2) {
            return 0L;
        }
        long result = a[1] - a[0];
        for (int i = 2; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i] - a[i - 1], result)) != 1L && result != 0L) continue;
            return result;
        }
        return result;
    }

    public static double gcd(double a, double b) {
        if (a == Double.POSITIVE_INFINITY || a == Double.NEGATIVE_INFINITY || Double.isNaN(a) || b == Double.POSITIVE_INFINITY || b == Double.NEGATIVE_INFINITY || Double.isNaN(b)) {
            return Double.NaN;
        }
        if (b == 0.0) {
            return Math.abs(a);
        }
        a = Math.abs(a);
        b = Math.abs(b);
        while (b != 0.0) {
            double tmp = b;
            b = a % b;
            a = tmp;
        }
        return a;
    }

    public static double gcd(double[] a) {
        if (a.length == 0) {
            return 0.0;
        }
        double result = a[0];
        for (int i = 1; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i], result)) != 1.0 && result != 0.0) continue;
            return result;
        }
        return result;
    }

    public static double gcd_differences(double[] a) {
        if (a.length < 2) {
            return 0.0;
        }
        double result = a[1] - a[0];
        for (int i = 2; i < a.length; ++i) {
            if ((result = MathMDE.gcd(a[i] - a[i - 1], result)) != 1.0 && result != 0.0) continue;
            return result;
        }
        return result;
    }

    public static final int mod_positive(int x, int y) {
        int result = x % y;
        if (result < 0) {
            result += Math.abs(y);
        }
        return result;
    }

    public static int[] modulus(int[] nums) {
        if (nums.length < 3) {
            return null;
        }
        int modulus = Math.abs(MathMDE.gcd_differences(nums));
        if (modulus == 1) {
            return null;
        }
        int remainder = nums[0] % modulus;
        if (remainder < 0) {
            remainder += modulus;
        }
        return new int[]{remainder, modulus};
    }

    public static int[] modulus_int(Iterator<Integer> itor) {
        if (!itor.hasNext()) {
            return null;
        }
        int avalue = itor.next();
        if (!itor.hasNext()) {
            return null;
        }
        int modulus = Math.abs(avalue - itor.next());
        if (modulus == 1) {
            return null;
        }
        int count = 2;
        while (itor.hasNext()) {
            int i = itor.next();
            if (i == avalue) continue;
            modulus = MathMDE.gcd(modulus, Math.abs(avalue - i));
            ++count;
            if (modulus != 1) continue;
            return null;
        }
        if (count < 3) {
            return null;
        }
        return new int[]{MathMDE.mod_positive(avalue, modulus), modulus};
    }

    public static int[] modulus_strict(int[] nums, boolean nonstrict_ends) {
        int first_index = 0;
        int last_index = nums.length - 1;
        int first_nonstrict = 0;
        int last_nonstrict = 0;
        if (nonstrict_ends) {
            first_nonstrict = nums[first_index];
            ++first_index;
            last_nonstrict = nums[last_index];
            --last_index;
        }
        if (last_index - first_index < 2) {
            return null;
        }
        int modulus = nums[first_index + 1] - nums[first_index];
        if (modulus == 1) {
            return null;
        }
        for (int i = first_index + 2; i <= last_index; ++i) {
            if (nums[i] - nums[i - 1] == modulus) continue;
            return null;
        }
        int r = MathMDE.mod_positive(nums[first_index], modulus);
        if (nonstrict_ends && (r != MathMDE.mod_positive(first_nonstrict, modulus) || r != MathMDE.mod_positive(last_nonstrict, modulus))) {
            return null;
        }
        return new int[]{r, modulus};
    }

    public static int[] modulus_strict_int(Iterator<Integer> itor, boolean nonstrict_ends) {
        if (!itor.hasNext()) {
            return null;
        }
        int first_nonstrict = 0;
        int last_nonstrict = 0;
        if (nonstrict_ends) {
            first_nonstrict = itor.next();
        }
        int prev = itor.next();
        if (!itor.hasNext()) {
            return null;
        }
        int next = itor.next();
        int modulus = next - prev;
        if (modulus == 1) {
            return null;
        }
        int count = 2;
        while (itor.hasNext()) {
            prev = next;
            next = itor.next();
            if (nonstrict_ends && !itor.hasNext()) {
                last_nonstrict = next;
                break;
            }
            if (next - prev != modulus) {
                return null;
            }
            ++count;
        }
        if (count < 3) {
            return null;
        }
        int r = MathMDE.mod_positive(next, modulus);
        if (nonstrict_ends && (r != MathMDE.mod_positive(first_nonstrict, modulus) || r != MathMDE.mod_positive(last_nonstrict, modulus))) {
            return null;
        }
        return new int[]{r, modulus};
    }

    public static final long mod_positive(long x, long y) {
        long result = x % y;
        if (result < 0L) {
            result += Math.abs(y);
        }
        return result;
    }

    public static long[] modulus(long[] nums) {
        if (nums.length < 3) {
            return null;
        }
        long modulus = Math.abs(MathMDE.gcd_differences(nums));
        if (modulus == 1L) {
            return null;
        }
        long remainder = nums[0] % modulus;
        if (remainder < 0L) {
            remainder += modulus;
        }
        return new long[]{remainder, modulus};
    }

    public static long[] modulus_long(Iterator<Long> itor) {
        if (!itor.hasNext()) {
            return null;
        }
        long avalue = itor.next();
        if (!itor.hasNext()) {
            return null;
        }
        long modulus = Math.abs(avalue - itor.next());
        if (modulus == 1L) {
            return null;
        }
        int count = 2;
        while (itor.hasNext()) {
            long i = itor.next();
            if (i == avalue) continue;
            modulus = MathMDE.gcd(modulus, Math.abs(avalue - i));
            ++count;
            if (modulus != 1L) continue;
            return null;
        }
        if (count < 3) {
            return null;
        }
        return new long[]{MathMDE.mod_positive(avalue, modulus), modulus};
    }

    public static long[] modulus_strict(long[] nums, boolean nonstrict_ends) {
        int first_index = 0;
        int last_index = nums.length - 1;
        long first_nonstrict = 0L;
        long last_nonstrict = 0L;
        if (nonstrict_ends) {
            first_nonstrict = nums[first_index];
            ++first_index;
            last_nonstrict = nums[last_index];
            --last_index;
        }
        if (last_index - first_index < 2) {
            return null;
        }
        long modulus = nums[first_index + 1] - nums[first_index];
        if (modulus == 1L) {
            return null;
        }
        for (int i = first_index + 2; i <= last_index; ++i) {
            if (nums[i] - nums[i - 1] == modulus) continue;
            return null;
        }
        long r = MathMDE.mod_positive(nums[first_index], modulus);
        if (nonstrict_ends && (r != MathMDE.mod_positive(first_nonstrict, modulus) || r != MathMDE.mod_positive(last_nonstrict, modulus))) {
            return null;
        }
        return new long[]{r, modulus};
    }

    public static long[] modulus_strict_long(Iterator<Long> itor, boolean nonstrict_ends) {
        if (!itor.hasNext()) {
            return null;
        }
        long first_nonstrict = 0L;
        long last_nonstrict = 0L;
        if (nonstrict_ends) {
            first_nonstrict = itor.next();
        }
        long prev = itor.next();
        if (!itor.hasNext()) {
            return null;
        }
        long next = itor.next();
        long modulus = next - prev;
        if (modulus == 1L) {
            return null;
        }
        int count = 2;
        while (itor.hasNext()) {
            prev = next;
            next = itor.next();
            if (nonstrict_ends && !itor.hasNext()) {
                last_nonstrict = next;
                break;
            }
            if (next - prev != modulus) {
                return null;
            }
            ++count;
        }
        if (count < 3) {
            return null;
        }
        long r = MathMDE.mod_positive(next, modulus);
        if (nonstrict_ends && (r != MathMDE.mod_positive(first_nonstrict, modulus) || r != MathMDE.mod_positive(last_nonstrict, modulus))) {
            return null;
        }
        return new long[]{r, modulus};
    }

    public static int[] missing_numbers(int[] nums) {
        int[] nums_copy = new int[nums.length];
        System.arraycopy(nums, 0, nums_copy, 0, nums.length);
        nums = nums_copy;
        Arrays.sort(nums);
        int min = nums[0];
        int max = nums[nums.length - 1];
        int[] result = new int[max - min + 1 - nums.length];
        int result_index = 0;
        int val = min;
        for (int i = 0; i < nums.length; ++i) {
            while (val < nums[i]) {
                result[result_index] = val++;
                ++result_index;
            }
            if (val != nums[i]) continue;
            ++val;
        }
        if (result_index == result.length) {
            return result;
        }
        int[] new_result = new int[result_index];
        System.arraycopy(result, 0, new_result, 0, result_index);
        return new_result;
    }

    public static int[] nonmodulus_strict(int[] nums) {
        if (nums.length == 0) {
            return null;
        }
        int range = ArraysMDE.element_range(nums);
        if (range > 65536) {
            return null;
        }
        return MathMDE.nonmodulus_strict_int_internal(new MissingNumbersIteratorInt(nums, true));
    }

    private static int[] nonmodulus_strict_int_internal(Iterator<Integer> missing) {
        UtilMDE.RemoveFirstAndLastIterator<Integer> missing_nums = new UtilMDE.RemoveFirstAndLastIterator<Integer>(missing);
        int[] result = MathMDE.modulus_strict_int(missing_nums, false);
        if (result == null) {
            return result;
        }
        if (!MathMDE.check_first_and_last_nonmodulus(result, missing_nums)) {
            return null;
        }
        return result;
    }

    private static boolean check_first_and_last_nonmodulus(int[] rm, UtilMDE.RemoveFirstAndLastIterator<Integer> rfali) {
        int r = rm[0];
        int m = rm[1];
        int first = rfali.getFirst();
        int last = rfali.getLast();
        return r != MathMDE.mod_positive(first, m) && r != MathMDE.mod_positive(last, m);
    }

    public static int[] nonmodulus_strict_int(Iterator<Integer> nums) {
        return MathMDE.nonmodulus_strict_int_internal(new MissingNumbersIteratorInt(nums, true));
    }

    public static int[] nonmodulus_nonstrict(int[] nums) {
        if (nums.length < 4) {
            return null;
        }
        int max_modulus = Math.min(nums.length / 2, ArraysMDE.element_range(nums) / 2);
        for (int m = 2; m <= max_modulus; ++m) {
            boolean[] has_modulus = new boolean[m];
            int num_nonmodulus = m;
            for (int i = 0; i < nums.length; ++i) {
                int rem = MathMDE.mod_positive(nums[i], m);
                if (has_modulus[rem]) continue;
                has_modulus[rem] = true;
                if (--num_nonmodulus == 0) break;
            }
            if (num_nonmodulus != 1) continue;
            return new int[]{ArraysMDE.indexOf(has_modulus, false), m};
        }
        return null;
    }

    public static long[] missing_numbers(long[] nums) {
        long[] nums_copy = new long[nums.length];
        System.arraycopy(nums, 0, nums_copy, 0, nums.length);
        nums = nums_copy;
        Arrays.sort(nums);
        long min = nums[0];
        long max = nums[nums.length - 1];
        long[] result = new long[(int)(max - min + 1L - (long)nums.length)];
        int result_index = 0;
        long val = min;
        for (int i = 0; i < nums.length; ++i) {
            while (val < nums[i]) {
                result[result_index] = val++;
                ++result_index;
            }
            if (val != nums[i]) continue;
            ++val;
        }
        if (result_index == result.length) {
            return result;
        }
        long[] new_result = new long[result_index];
        System.arraycopy(result, 0, new_result, 0, result_index);
        return new_result;
    }

    public static long[] nonmodulus_strict(long[] nums) {
        if (nums.length == 0) {
            return null;
        }
        long range = ArraysMDE.element_range(nums);
        if (range > 65536L) {
            return null;
        }
        return MathMDE.nonmodulus_strict_long_internal(new MissingNumbersIteratorLong(nums, true));
    }

    private static long[] nonmodulus_strict_long_internal(Iterator<Long> missing) {
        UtilMDE.RemoveFirstAndLastIterator<Long> missing_nums = new UtilMDE.RemoveFirstAndLastIterator<Long>(missing);
        long[] result = MathMDE.modulus_strict_long(missing_nums, false);
        if (result == null) {
            return result;
        }
        if (!MathMDE.check_first_and_last_nonmodulus(result, missing_nums)) {
            return null;
        }
        return result;
    }

    private static boolean check_first_and_last_nonmodulus(long[] rm, UtilMDE.RemoveFirstAndLastIterator<Long> rfali) {
        long r = rm[0];
        long m = rm[1];
        long first = rfali.getFirst();
        long last = rfali.getLast();
        return r != MathMDE.mod_positive(first, m) && r != MathMDE.mod_positive(last, m);
    }

    public static long[] nonmodulus_strict_long(Iterator<Long> nums) {
        return MathMDE.nonmodulus_strict_long_internal(new MissingNumbersIteratorLong(nums, true));
    }

    public static long[] nonmodulus_nonstrict(long[] nums) {
        if (nums.length < 4) {
            return null;
        }
        int max_modulus = (int)Math.min((long)(nums.length / 2), ArraysMDE.element_range(nums) / 2L);
        for (int m = 2; m <= max_modulus; ++m) {
            boolean[] has_modulus = new boolean[m];
            int num_nonmodulus = m;
            for (int i = 0; i < nums.length; ++i) {
                int rem = (int)MathMDE.mod_positive(nums[i], (long)m);
                if (has_modulus[rem]) continue;
                has_modulus[rem] = true;
                if (--num_nonmodulus == 0) break;
            }
            if (num_nonmodulus != 1) continue;
            return new long[]{ArraysMDE.indexOf(has_modulus, false), m};
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MissingNumbersIteratorLong
    implements Iterator<Long> {
        long[] nums;
        Iterator<Long> nums_itor;
        long current_nonmissing;
        long current_missing;
        int current_index;
        boolean add_ends;

        MissingNumbersIteratorLong(long[] nums, boolean add_ends) {
            this.add_ends = add_ends;
            long[] nums_copy = new long[nums.length];
            System.arraycopy(nums, 0, nums_copy, 0, nums.length);
            nums = nums_copy;
            Arrays.sort(nums);
            this.current_index = 0;
            this.current_nonmissing = nums[this.current_index];
            this.current_missing = add_ends ? this.current_nonmissing - 1L : this.current_nonmissing;
            this.nums = nums;
        }

        MissingNumbersIteratorLong(Iterator<Long> nums_itor, boolean add_ends) {
            this.add_ends = add_ends;
            if (!nums_itor.hasNext()) {
                throw new Error("No elements in nums_itor");
            }
            this.current_nonmissing = nums_itor.next();
            this.current_missing = add_ends ? this.current_nonmissing - 1L : this.current_nonmissing;
            this.nums_itor = nums_itor;
        }

        @Override
        public boolean hasNext() {
            if (this.current_missing < this.current_nonmissing) {
                return true;
            }
            if (this.current_missing == this.current_nonmissing) {
                if (this.nums != null) {
                    ++this.current_index;
                    if (this.current_index >= this.nums.length) {
                        if (this.add_ends) {
                            ++this.current_missing;
                            return true;
                        }
                        return false;
                    }
                    this.current_nonmissing = this.nums[this.current_index];
                } else if (this.nums_itor != null) {
                    if (!this.nums_itor.hasNext()) {
                        if (this.add_ends) {
                            ++this.current_missing;
                            return true;
                        }
                        return false;
                    }
                    long prev_nonmissing = this.current_nonmissing;
                    this.current_nonmissing = this.nums_itor.next();
                    if (prev_nonmissing >= this.current_nonmissing) {
                        throw new Error("Non-sorted Iterator supplied to MissingNumbersIteratorLong: prev_nonmissing = " + prev_nonmissing + ", current_nonmissing = " + this.current_nonmissing);
                    }
                } else {
                    throw new Error("Can't happen");
                }
                ++this.current_missing;
                return this.hasNext();
            }
            if (this.add_ends) {
                return this.current_missing == this.current_nonmissing + 1L;
            }
            throw new Error("Can't happen: " + this.current_missing + " " + this.current_nonmissing);
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Long result = new Long(this.current_missing);
            ++this.current_missing;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MissingNumbersIteratorInt
    implements Iterator<Integer> {
        int[] nums;
        Iterator<Integer> nums_itor;
        int current_nonmissing;
        int current_missing;
        int current_index;
        boolean add_ends;

        MissingNumbersIteratorInt(int[] nums, boolean add_ends) {
            this.add_ends = add_ends;
            int[] nums_copy = new int[nums.length];
            System.arraycopy(nums, 0, nums_copy, 0, nums.length);
            nums = nums_copy;
            Arrays.sort(nums);
            this.current_index = 0;
            this.current_nonmissing = nums[this.current_index];
            this.current_missing = add_ends ? this.current_nonmissing - 1 : this.current_nonmissing;
            this.nums = nums;
        }

        MissingNumbersIteratorInt(Iterator<Integer> nums_itor, boolean add_ends) {
            this.add_ends = add_ends;
            if (!nums_itor.hasNext()) {
                throw new Error("No elements in nums_itor");
            }
            this.current_nonmissing = nums_itor.next();
            this.current_missing = add_ends ? this.current_nonmissing - 1 : this.current_nonmissing;
            this.nums_itor = nums_itor;
        }

        @Override
        public boolean hasNext() {
            if (this.current_missing < this.current_nonmissing) {
                return true;
            }
            if (this.current_missing == this.current_nonmissing) {
                if (this.nums != null) {
                    ++this.current_index;
                    if (this.current_index >= this.nums.length) {
                        if (this.add_ends) {
                            ++this.current_missing;
                            return true;
                        }
                        return false;
                    }
                    this.current_nonmissing = this.nums[this.current_index];
                } else if (this.nums_itor != null) {
                    if (!this.nums_itor.hasNext()) {
                        if (this.add_ends) {
                            ++this.current_missing;
                            return true;
                        }
                        return false;
                    }
                    int prev_nonmissing = this.current_nonmissing;
                    this.current_nonmissing = this.nums_itor.next();
                    if (prev_nonmissing >= this.current_nonmissing) {
                        throw new Error("Non-sorted Iterator supplied to MissingNumbersIteratorInt: prev_nonmissing = " + prev_nonmissing + ", current_nonmissing = " + this.current_nonmissing);
                    }
                } else {
                    throw new Error("Can't happen");
                }
                ++this.current_missing;
                return this.hasNext();
            }
            if (this.add_ends) {
                return this.current_missing == this.current_nonmissing + 1;
            }
            throw new Error("Can't happen: " + this.current_missing + " " + this.current_nonmissing);
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Integer result = new Integer(this.current_missing);
            ++this.current_missing;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

