/*
 * Decompiled with CFR 0.152.
 */
package plume;

import checkers.nullness.quals.Nullable;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import plume.EntryReader;
import plume.Option;
import plume.OptionGroup;
import plume.Options;
import plume.UtilMDE;

public class Lookup {
    @OptionGroup(value="Getting help")
    @Option(value="-h Show detailed help information")
    public static boolean help = false;
    @Option(value="-v Print progress information")
    public static boolean verbose = false;
    @OptionGroup(value="Where to search")
    @Option(value="-f Specify the search list of files of information; may only be supplied once")
    public static String entry_file = "~/lookup/root";
    @Option(value="-b Search body of long entries for matches")
    public static boolean search_body = false;
    @OptionGroup(value="What to search for")
    @Option(value="-e Keywords are regular expressions")
    public static boolean regular_expressions = false;
    @Option(value="-c Keywords are case sensistive")
    public static boolean case_sensitive = false;
    @Option(value="-w Only match text keywords against complete words")
    public static boolean word_match = false;
    @OptionGroup(value="How to print matches")
    @Option(value="-a Print the entire entry for each match")
    public static boolean print_all = false;
    @Option(value="-i Choose a specific item when there are multiple matches")
    @Nullable
    public static Integer item_num;
    @Option(value="-l Show the location of each matching entry")
    public static boolean show_location;
    @OptionGroup(value="Customizing format of files to be searched")
    @Option(value="Regex that denotes the start of a long entry")
    public static Pattern entry_start_re;
    @Option(value="Regex that denotes the end of a long entry")
    public static Pattern entry_stop_re;
    @Option(value="Regex that finds an entry's description (for long entries)")
    @Nullable
    public static Pattern description_re;
    @Option(value="Regex that matches an entire comment (not just a comment start)")
    @Nullable
    public static String comment_re;
    @Option(value="Regex that matches an include directive; group 1 is the file name")
    public static String include_re;
    private static final String lineSep;
    private static String usage_string;

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        Options options = new Options(usage_string, Lookup.class);
        String[] keywords = options.parse_or_usage(args);
        if (help) {
            InputStream is = Lookup.class.getResourceAsStream("lookup.txt");
            if (is == null) {
                System.out.println("Unable to find resource 'lookup.txt' with help text.");
                System.exit(1);
            }
            BufferedReader help_stream = new BufferedReader(new InputStreamReader(is));
            String line = help_stream.readLine();
            while (line != null) {
                System.out.println(line);
                line = help_stream.readLine();
            }
            System.exit(0);
        }
        if (verbose) {
            System.out.printf("Options settings: %n%s%n", options.settings());
        }
        if (keywords.length == 0) {
            options.print_usage("Error: No keywords specified");
            System.exit(254);
        }
        assert (comment_re != null) : "@SuppressWarnings(nullness): application invariant";
        if (comment_re.equals("")) {
            comment_re = null;
        }
        EntryReader reader = null;
        String[] entry_files = entry_file.split(":");
        ArrayList<FileNotFoundException> file_errors = new ArrayList<FileNotFoundException>();
        for (String ef : entry_files) {
            ef = UtilMDE.expandFilename(ef);
            try {
                reader = new EntryReader(ef, comment_re, include_re);
            }
            catch (FileNotFoundException e) {
                file_errors.add(e);
            }
            if (reader != null) break;
        }
        if (reader == null) {
            System.out.println("Error: Can't read any entry files");
            for (Exception exception : file_errors) {
                System.out.printf("  entry file %s%n", exception.getMessage());
            }
            System.exit(254);
        }
        reader.set_entry_start_stop(entry_start_re, entry_stop_re);
        ArrayList<EntryReader.Entry> matching_entries = new ArrayList<EntryReader.Entry>();
        try {
            boolean bl = false;
            EntryReader.Entry entry = reader.get_entry();
            while (entry != null) {
                void var7_10;
                if (verbose && ++var7_10 % 1000 == false) {
                    System.out.printf("%d matches in %d entries\r", matching_entries.size(), (int)var7_10);
                }
                int matchcount = 0;
                for (String keyword : keywords) {
                    String search = entry.get_description(description_re);
                    if (search_body || entry.short_entry) {
                        search = entry.body;
                    }
                    if (!case_sensitive) {
                        search = search.toLowerCase();
                    }
                    if (regular_expressions) {
                        int flags = 2;
                        if (case_sensitive) {
                            flags = 0;
                        }
                        if (!Pattern.compile(keyword, flags).matcher(search).find()) continue;
                        ++matchcount;
                        continue;
                    }
                    if (!case_sensitive) {
                        keyword = keyword.toLowerCase();
                    }
                    if (word_match) {
                        keyword = "\\b" + keyword + "\\b";
                        if (!Pattern.compile(keyword).matcher(search).find()) continue;
                        ++matchcount;
                        continue;
                    }
                    if (!search.contains(keyword)) continue;
                    ++matchcount;
                }
                if (matchcount == keywords.length) {
                    matching_entries.add(entry);
                }
                entry = reader.get_entry();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.printf("Error: Can't read %s at line %d in file %s%n", fileNotFoundException.getMessage(), reader.getLineNumber(), reader.getFileName());
            System.exit(254);
        }
        if (matching_entries.size() == 0) {
            System.out.println("Nothing found.");
        } else if (matching_entries.size() == 1) {
            EntryReader.Entry entry = (EntryReader.Entry)matching_entries.get(0);
            if (show_location) {
                System.out.printf("%s:%d:%n", entry.filename, entry.line_number);
            }
            System.out.print(entry.body);
        } else if (item_num != null) {
            EntryReader.Entry entry = (EntryReader.Entry)matching_entries.get(item_num - 1);
            if (show_location) {
                System.out.printf("%s:%d:%n", entry.filename, entry.line_number);
            }
            System.out.print(entry.body);
        } else {
            boolean bl = false;
            if (print_all) {
                System.out.printf("%d matches found (separated by dashes below)%n", matching_entries.size());
            } else {
                System.out.printf("%d matches found. Use -i to print a specific match or -a to see them all%n", matching_entries.size());
            }
            for (EntryReader.Entry e : matching_entries) {
                void var7_15;
                ++var7_15;
                if (print_all) {
                    if (show_location) {
                        System.out.printf("%n-------------------------%n%s:%d:%n", e.filename, e.line_number);
                    } else {
                        System.out.printf("%n-------------------------%n", new Object[0]);
                    }
                    System.out.print(e.body);
                    continue;
                }
                if (show_location) {
                    System.out.printf("  -i=%d %s:%d: %s%n", (int)var7_15, e.filename, e.line_number, e.first_line);
                    continue;
                }
                System.out.printf("  -i=%d %s%n", (int)var7_15, e.get_description(description_re));
            }
        }
    }

    @Nullable
    public static EntryReader.Entry old_get_entry(EntryReader reader) throws IOException {
        try {
            String line = reader.readLine();
            while (line != null && line.trim().length() == 0) {
                line = reader.readLine();
            }
            if (line == null) {
                return null;
            }
            String body = "";
            EntryReader.Entry entry = null;
            String filename = reader.getFileName();
            long line_number = reader.getLineNumber();
            if (line.startsWith(">entry")) {
                String current_filename = reader.getFileName();
                String first_line = line = line.replaceFirst("^>entry *", "");
                while (line != null && !line.startsWith(">entry") && !line.equals("<entry") && current_filename.equals(reader.getFileName())) {
                    body = body + line + lineSep;
                    line = reader.readLine();
                }
                if (line != null && (line.startsWith(">entry") || !current_filename.equals(reader.getFileName()))) {
                    reader.putback(line);
                }
                entry = new EntryReader.Entry(first_line, body, filename, line_number, false);
            } else {
                String first_line = line;
                while (line != null && line.trim().length() != 0) {
                    body = body + String.format("%s%n", line);
                    line = reader.readLine();
                }
                entry = new EntryReader.Entry(first_line, body, filename, line_number, true);
            }
            return entry;
        }
        catch (FileNotFoundException e) {
            System.out.printf("Error: Can't read %s at line %d in file %s%n", e.getMessage(), reader.getLineNumber(), reader.getFileName());
            System.exit(254);
            return null;
        }
    }

    public static String first_line(String entry) {
        int ii = entry.indexOf(lineSep);
        if (ii == -1) {
            return entry;
        }
        return entry.substring(0, ii);
    }

    static {
        show_location = false;
        entry_start_re = Pattern.compile("^>entry *()");
        entry_stop_re = Pattern.compile("^<entry");
        description_re = null;
        comment_re = "^%.*";
        include_re = "\\\\include\\{(.*)\\}";
        lineSep = System.getProperty("line.separator");
        usage_string = "lookup [options] <keyword> ...";
    }
}

