/*
 * Decompiled with CFR 0.152.
 */
package plume;

import checkers.nullness.quals.AssertNonNullIfFalse;
import checkers.nullness.quals.Pure;
import java.io.Serializable;
import java.util.List;
import plume.ArraysMDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitedSizeIntSet
implements Serializable,
Cloneable {
    static final long serialVersionUID = 20031021L;
    protected int[] values;
    int num_values;

    public LimitedSizeIntSet(int max_values) {
        assert (max_values > 0);
        this.values = new int[max_values];
        this.num_values = 0;
    }

    public void add(int elt) {
        if (this.values == null) {
            return;
        }
        for (int i = 0; i < this.num_values; ++i) {
            if (this.values[i] != elt) continue;
            return;
        }
        if (this.num_values == this.values.length) {
            this.values = null;
            ++this.num_values;
            return;
        }
        this.values[this.num_values] = elt;
        ++this.num_values;
    }

    public void addAll(LimitedSizeIntSet s) {
        if (this.repNulled()) {
            return;
        }
        if (s.repNulled()) {
            int values_length = this.values.length;
            if (s.size() > values_length) {
                this.num_values = values_length + 1;
                this.values = null;
                return;
            }
            throw new Error("Arg is rep-nulled, so we don't know its values and can't add them to this.");
        }
        for (int i = 0; i < s.size(); ++i) {
            assert (s.values != null) : "@SuppressWarnings(nullness): no relevant side effect:  add's side effects do not affect s.values, whether or not this == s";
            this.add(s.values[i]);
            if (!this.repNulled()) continue;
            return;
        }
    }

    public boolean contains(int elt) {
        if (this.values == null) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < this.num_values; ++i) {
            if (this.values[i] != elt) continue;
            return true;
        }
        return false;
    }

    @Pure
    public int size() {
        return this.num_values;
    }

    public int max_size() {
        if (this.values == null) {
            return this.num_values;
        }
        return this.values.length + 1;
    }

    @AssertNonNullIfFalse(value={"values"})
    @Pure
    public boolean repNulled() {
        return this.values == null;
    }

    public LimitedSizeIntSet clone() {
        LimitedSizeIntSet result;
        try {
            result = (LimitedSizeIntSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
        if (this.values != null) {
            result.values = (int[])this.values.clone();
        }
        return result;
    }

    public static LimitedSizeIntSet merge(int max_values, List<LimitedSizeIntSet> slist) {
        LimitedSizeIntSet result = new LimitedSizeIntSet(max_values);
        for (LimitedSizeIntSet s : slist) {
            result.addAll(s);
        }
        return result;
    }

    public String toString() {
        return "[size=" + this.size() + "; " + (this.values == null ? "null" : ArraysMDE.toString(this.values)) + "]";
    }
}

