/*
 * Decompiled with CFR 0.152.
 */
package plume;

import checkers.interning.quals.Interned;
import checkers.nullness.quals.Nullable;
import checkers.nullness.quals.PolyNull;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import plume.ArraysMDE;
import plume.Hasher;
import plume.WeakHasherMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Intern {
    private static final int FACTOR = 23;
    private static final double DOUBLE_FACTOR = 263.0;
    private static WeakHasherMap<Integer, WeakReference<Integer>> internedIntegers = new WeakHasherMap(new IntegerHasher());
    private static WeakHasherMap<Long, WeakReference<Long>> internedLongs = new WeakHasherMap(new LongHasher());
    private static WeakHasherMap<int[], WeakReference<int[]>> internedIntArrays = new WeakHasherMap(new IntArrayHasher());
    private static WeakHasherMap<long[], WeakReference<long[]>> internedLongArrays = new WeakHasherMap(new LongArrayHasher());
    private static WeakHasherMap<Double, WeakReference<Double>> internedDoubles = new WeakHasherMap(new DoubleHasher());
    @Interned
    private static Double internedDoubleNaN = new Double(Double.NaN);
    @Interned
    private static Double internedDoubleZero = new Double(0.0);
    private static WeakHasherMap<double[], WeakReference<double[]>> internedDoubleArrays = new WeakHasherMap(new DoubleArrayHasher());
    private static WeakHasherMap<String[], WeakReference<String[]>> internedStringArrays = new WeakHasherMap(new StringArrayHasher());
    private static WeakHasherMap<Object[], WeakReference<Object[]>> internedObjectArrays = new WeakHasherMap(new ObjectArrayHasher());
    private static WeakHasherMap<SequenceAndIndices<int[]>, WeakReference<int[]>> internedIntSequenceAndIndices = new WeakHasherMap(new SequenceAndIndicesHasher());
    private static WeakHasherMap<SequenceAndIndices<long[]>, WeakReference<long[]>> internedLongSequenceAndIndices = new WeakHasherMap(new SequenceAndIndicesHasher());
    private static WeakHasherMap<SequenceAndIndices<double[]>, WeakReference<double[]>> internedDoubleSequenceAndIndices = new WeakHasherMap(new SequenceAndIndicesHasher());
    private static WeakHasherMap<SequenceAndIndices<Object[]>, WeakReference<Object[]>> internedObjectSequenceAndIndices = new WeakHasherMap(new SequenceAndIndicesHasher());
    private static WeakHasherMap<SequenceAndIndices<String[]>, WeakReference<String[]>> internedStringSequenceAndIndices = new WeakHasherMap(new SequenceAndIndicesHasher());

    private Intern() {
        throw new Error("do not instantiate");
    }

    @Interned
    public static String[] internStrings(String[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            a[i] = a[i].intern();
        }
        return a;
    }

    public static boolean isInterned(@Nullable Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return value == ((String)value).intern();
        }
        if (value instanceof String[]) {
            return value == Intern.intern((String[])value);
        }
        if (value instanceof Integer) {
            return value == Intern.intern((Integer)value);
        }
        if (value instanceof Long) {
            return value == Intern.intern((Long)value);
        }
        if (value instanceof int[]) {
            return value == Intern.intern((int[])value);
        }
        if (value instanceof long[]) {
            return value == Intern.intern((long[])value);
        }
        if (value instanceof Double) {
            return value == Intern.intern((Double)value);
        }
        if (value instanceof double[]) {
            return value == Intern.intern((double[])value);
        }
        if (value instanceof Object[]) {
            return value == Intern.intern((Object[])value);
        }
        return true;
    }

    public static int numIntegers() {
        return internedIntegers.size();
    }

    public static int numLongs() {
        return internedLongs.size();
    }

    public static int numIntArrays() {
        return internedIntArrays.size();
    }

    public static int numLongArrays() {
        return internedLongArrays.size();
    }

    public static int numDoubles() {
        return internedDoubles.size();
    }

    public static int numDoubleArrays() {
        return internedDoubleArrays.size();
    }

    public static int numStringArrays() {
        return internedStringArrays.size();
    }

    public static int numObjectArrays() {
        return internedObjectArrays.size();
    }

    public static Iterator<Integer> integers() {
        return internedIntegers.keySet().iterator();
    }

    public static Iterator<Long> longs() {
        return internedLongs.keySet().iterator();
    }

    public static Iterator<int[]> intArrays() {
        return internedIntArrays.keySet().iterator();
    }

    public static Iterator<long[]> longArrays() {
        return internedLongArrays.keySet().iterator();
    }

    public static Iterator<Double> doubles() {
        return internedDoubles.keySet().iterator();
    }

    public static Iterator<double[]> doubleArrays() {
        return internedDoubleArrays.keySet().iterator();
    }

    public static Iterator<String[]> stringArrays() {
        return internedStringArrays.keySet().iterator();
    }

    public static Iterator<Object[]> objectArrays() {
        return internedObjectArrays.keySet().iterator();
    }

    @Interned
    @PolyNull
    public static String intern(@PolyNull String a) {
        return a == null ? null : a.intern();
    }

    public static long intern(long l) {
        return l;
    }

    public static double intern(double l) {
        return l;
    }

    @Interned
    public static Integer intern(Integer a) {
        WeakReference<Integer> lookup = internedIntegers.get(a);
        if (lookup != null) {
            return (Integer)lookup.get();
        }
        Integer result = a;
        internedIntegers.put(result, new WeakReference<Integer>(result));
        return result;
    }

    @Interned
    public static Integer internedInteger(int i) {
        return Intern.intern((Integer)i);
    }

    @Interned
    public static Integer internedInteger(String s) {
        return Intern.intern(Integer.decode(s));
    }

    @Interned
    public static Long intern(Long a) {
        WeakReference<Long> lookup = internedLongs.get(a);
        if (lookup != null) {
            return (Long)lookup.get();
        }
        Long result = a;
        internedLongs.put(result, new WeakReference<Long>(result));
        return result;
    }

    @Interned
    public static Long internedLong(long i) {
        return Intern.intern((Long)i);
    }

    @Interned
    public static Long internedLong(String s) {
        return Intern.intern(Long.decode(s));
    }

    public static int[] intern(int[] a) {
        WeakReference<int[]> lookup = internedIntArrays.get(a);
        if (lookup != null) {
            return (int[])lookup.get();
        }
        int[] result = a;
        internedIntArrays.put(result, new WeakReference<int[]>(result));
        return result;
    }

    public static long[] intern(long[] a) {
        WeakReference<long[]> lookup = internedLongArrays.get(a);
        if (lookup != null) {
            return (long[])lookup.get();
        }
        long[] result = a;
        internedLongArrays.put(result, new WeakReference<long[]>(result));
        return result;
    }

    @Interned
    public static Double intern(Double a) {
        if (a.isNaN()) {
            return internedDoubleNaN;
        }
        if (a == 0.0) {
            return internedDoubleZero;
        }
        WeakReference<Double> lookup = internedDoubles.get(a);
        if (lookup != null) {
            return (Double)lookup.get();
        }
        Double result = a;
        internedDoubles.put(result, new WeakReference<Double>(result));
        return result;
    }

    @Interned
    public static Double internedDouble(double d) {
        return Intern.intern((Double)d);
    }

    @Interned
    public static Double internedDouble(String s) {
        return Intern.internedDouble(Double.parseDouble(s));
    }

    public static double[] intern(double[] a) {
        WeakReference<double[]> lookup = internedDoubleArrays.get(a);
        if (lookup != null) {
            return (double[])lookup.get();
        }
        double[] result = a;
        internedDoubleArrays.put(result, new WeakReference<double[]>(result));
        return result;
    }

    @PolyNull
    @Interned
    public static String[] intern(@PolyNull @Interned String[] a) {
        for (int k = 0; k < a.length; ++k) {
            assert (a[k] == Intern.intern(a[k]));
        }
        WeakReference<String[]> lookup = internedStringArrays.get(a);
        if (lookup != null) {
            return (String[])lookup.get();
        }
        String[] result = a;
        internedStringArrays.put(result, new WeakReference<String[]>(result));
        return result;
    }

    @PolyNull
    @Interned
    public static Object[] intern(@PolyNull @Interned Object[] a) {
        WeakReference<Object[]> lookup = internedObjectArrays.get(a);
        if (lookup != null) {
            return (Object[])lookup.get();
        }
        Object[] result = a;
        internedObjectArrays.put(result, new WeakReference<Object[]>(result));
        return result;
    }

    @Interned
    @PolyNull
    public static Object intern(@PolyNull Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof String) {
            return Intern.intern((String)a);
        }
        if (a instanceof String[]) {
            String[] asArray = (String[])a;
            return Intern.intern(asArray);
        }
        if (a instanceof Integer) {
            return Intern.intern((Integer)a);
        }
        if (a instanceof Long) {
            return Intern.intern((Long)a);
        }
        if (a instanceof int[]) {
            return Intern.intern((int[])a);
        }
        if (a instanceof long[]) {
            return Intern.intern((long[])a);
        }
        if (a instanceof Double) {
            return Intern.intern((Double)a);
        }
        if (a instanceof double[]) {
            return Intern.intern((double[])a);
        }
        if (a instanceof Object[]) {
            Object[] asArray = (Object[])a;
            return Intern.intern(asArray);
        }
        throw new IllegalArgumentException("Arguments of type " + a.getClass() + " cannot be interned");
    }

    public static int[] internSubsequence(int[] seq, int start, int end) {
        assert (Intern.isInterned(seq));
        SequenceAndIndices<int[]> sai = new SequenceAndIndices<int[]>(seq, start, end);
        WeakReference<int[]> lookup = internedIntSequenceAndIndices.get(sai);
        if (lookup != null) {
            return (int[])lookup.get();
        }
        int[] subseqUninterned = ArraysMDE.subarray(seq, start, end - start);
        int[] subseq = Intern.intern(subseqUninterned);
        internedIntSequenceAndIndices.put(sai, new WeakReference<int[]>(subseq));
        return subseq;
    }

    public static long[] internSubsequence(long[] seq, int start, int end) {
        assert (Intern.isInterned(seq));
        SequenceAndIndices<long[]> sai = new SequenceAndIndices<long[]>(seq, start, end);
        WeakReference<long[]> lookup = internedLongSequenceAndIndices.get(sai);
        if (lookup != null) {
            return (long[])lookup.get();
        }
        long[] subseq_uninterned = ArraysMDE.subarray(seq, start, end - start);
        long[] subseq = Intern.intern(subseq_uninterned);
        internedLongSequenceAndIndices.put(sai, new WeakReference<long[]>(subseq));
        return subseq;
    }

    public static double[] internSubsequence(double[] seq, int start, int end) {
        assert (Intern.isInterned(seq));
        SequenceAndIndices<double[]> sai = new SequenceAndIndices<double[]>(seq, start, end);
        WeakReference<double[]> lookup = internedDoubleSequenceAndIndices.get(sai);
        if (lookup != null) {
            return (double[])lookup.get();
        }
        double[] subseq_uninterned = ArraysMDE.subarray(seq, start, end - start);
        double[] subseq = Intern.intern(subseq_uninterned);
        internedDoubleSequenceAndIndices.put(sai, new WeakReference<double[]>(subseq));
        return subseq;
    }

    @PolyNull
    @Interned
    public static Object[] internSubsequence(@PolyNull @Interned Object[] seq, int start, int end) {
        assert (Intern.isInterned(seq));
        SequenceAndIndices<Object[]> sai = new SequenceAndIndices<Object[]>(seq, start, end);
        WeakReference<Object[]> lookup = internedObjectSequenceAndIndices.get(sai);
        if (lookup != null) {
            return (Object[])lookup.get();
        }
        Object[] subseq_uninterned = ArraysMDE.subarray(seq, start, end - start);
        Object[] subseq = Intern.intern(subseq_uninterned);
        WeakReference<Object[]> ignore = internedObjectSequenceAndIndices.put(sai, new WeakReference<Object[]>(subseq));
        return subseq;
    }

    @PolyNull
    @Interned
    public static String[] internSubsequence(@PolyNull @Interned String[] seq, int start, int end) {
        assert (Intern.isInterned(seq));
        SequenceAndIndices<String[]> sai = new SequenceAndIndices<String[]>(seq, start, end);
        WeakReference<String[]> lookup = internedStringSequenceAndIndices.get(sai);
        if (lookup != null) {
            return (String[])lookup.get();
        }
        String[] subseq_uninterned = ArraysMDE.subarray(seq, start, end - start);
        String[] subseq = Intern.intern(subseq_uninterned);
        WeakReference<String[]> ignore = internedStringSequenceAndIndices.put(sai, new WeakReference<String[]>(subseq));
        return subseq;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SequenceAndIndicesHasher<T>
    implements Hasher {
        private SequenceAndIndicesHasher() {
        }

        @Override
        public boolean equals(Object a1, Object a2) {
            SequenceAndIndices sai1 = (SequenceAndIndices)a1;
            SequenceAndIndices sai2 = (SequenceAndIndices)a2;
            return sai1.equals(sai2);
        }

        @Override
        public int hashCode(Object o) {
            return o.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SequenceAndIndices<T> {
        public T seq;
        public int start;
        public int end;

        public SequenceAndIndices(T seq, int start, int end) {
            this.seq = seq;
            this.start = start;
            this.end = end;
            assert (Intern.isInterned(seq));
        }

        public boolean equals(@Nullable Object other) {
            if (other instanceof SequenceAndIndices) {
                SequenceAndIndices other_sai = (SequenceAndIndices)other;
                return this.equals(other_sai);
            }
            return false;
        }

        public boolean equals(SequenceAndIndices<T> other) {
            return this.seq == other.seq && this.start == other.start && this.end == other.end;
        }

        public int hashCode() {
            return this.seq.hashCode() + this.start * 30 - this.end * 2;
        }

        public String toString() {
            return "SAI(" + this.start + "," + this.end + ") from: " + ArraysMDE.toString(this.seq);
        }
    }

    private static final class ObjectArrayHasher
    implements Hasher {
        private ObjectArrayHasher() {
        }

        public boolean equals(Object a1, Object a2) {
            return Arrays.equals((Object[])a1, (Object[])a2);
        }

        public int hashCode(Object o) {
            Object[] a = (Object[])o;
            int result = 0;
            for (int i = 0; i < a.length; ++i) {
                Object elt = a[i];
                int elt_hashcode = elt == null ? 0 : elt.hashCode();
                result = result * 23 + elt_hashcode;
            }
            return result;
        }
    }

    private static final class StringArrayHasher
    implements Hasher {
        private StringArrayHasher() {
        }

        public boolean equals(Object a1, Object a2) {
            return Arrays.equals((String[])a1, (String[])a2);
        }

        public int hashCode(Object o) {
            String[] a = (String[])o;
            int result = 0;
            for (int i = 0; i < a.length; ++i) {
                int a_hashcode = a[i] == null ? 0 : a[i].hashCode();
                result = result * 23 + a_hashcode;
            }
            return result;
        }
    }

    private static final class DoubleArrayHasher
    implements Hasher {
        private DoubleArrayHasher() {
        }

        public boolean equals(Object a1, Object a2) {
            double[] da1 = (double[])a1;
            double[] da2 = (double[])a2;
            if (da1.length != da2.length) {
                return false;
            }
            for (int i = 0; i < da1.length; ++i) {
                if (da1[i] == da2[i] || Double.isNaN(da1[i]) && Double.isNaN(da2[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode(Object o) {
            double[] a = (double[])o;
            double running = 0.0;
            for (int i = 0; i < a.length; ++i) {
                double elt = Double.isNaN(a[i]) ? 0.0 : a[i];
                running = running * 23.0 + elt * 263.0;
            }
            long result = Math.round(running);
            return (int)(result % Integer.MAX_VALUE);
        }
    }

    private static final class DoubleHasher
    implements Hasher {
        private DoubleHasher() {
        }

        public boolean equals(Object a1, Object a2) {
            return a1.equals(a2);
        }

        public int hashCode(Object o) {
            Double d = (Double)o;
            long result = Math.round(d * 263.0);
            return (int)(result % Integer.MAX_VALUE);
        }
    }

    private static final class LongArrayHasher
    implements Hasher {
        private LongArrayHasher() {
        }

        public boolean equals(Object a1, Object a2) {
            return Arrays.equals((long[])a1, (long[])a2);
        }

        public int hashCode(Object o) {
            long[] a = (long[])o;
            long result = 0L;
            for (int i = 0; i < a.length; ++i) {
                result = result * 23L + a[i];
            }
            return (int)(result % Integer.MAX_VALUE);
        }
    }

    private static final class IntArrayHasher
    implements Hasher {
        private IntArrayHasher() {
        }

        public boolean equals(Object a1, Object a2) {
            return Arrays.equals((int[])a1, (int[])a2);
        }

        public int hashCode(Object o) {
            int[] a = (int[])o;
            int result = 0;
            for (int i = 0; i < a.length; ++i) {
                result = result * 23 + a[i];
            }
            return result;
        }
    }

    private static final class LongHasher
    implements Hasher {
        private LongHasher() {
        }

        public boolean equals(Object a1, Object a2) {
            return a1.equals(a2);
        }

        public int hashCode(Object o) {
            Long i = (Long)o;
            return i.intValue();
        }
    }

    private static final class IntegerHasher
    implements Hasher {
        private IntegerHasher() {
        }

        public boolean equals(Object a1, Object a2) {
            return a1.equals(a2);
        }

        public int hashCode(Object o) {
            Integer i = (Integer)o;
            return i;
        }
    }
}

