/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphMDE {
    public static <T> Map<T, List<T>> dominators(Map<T, List<T>> preds) {
        ArrayList<T> nodes = new ArrayList<T>(preds.keySet());
        ArrayList<T> roots = new ArrayList<T>();
        ArrayList<T> non_roots = new ArrayList<T>();
        HashMap dom = new HashMap();
        for (T node : preds.keySet()) {
            if (preds.get(node).isEmpty()) {
                roots.add(node);
                dom.put(node, new ArrayList<T>(Collections.singleton(node)));
                continue;
            }
            non_roots.add(node);
            dom.put(node, new ArrayList<T>(nodes));
        }
        assert (roots.size() + non_roots.size() == nodes.size());
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Object node : non_roots) {
                ArrayList<Object> new_doms = null;
                assert (preds.containsKey(node));
                for (T pred : preds.get(node)) {
                    assert (dom.containsKey(pred));
                    List dom_of_pred = (List)dom.get(pred);
                    if (new_doms == null) {
                        new_doms = new ArrayList<Object>(dom_of_pred);
                        continue;
                    }
                    new_doms.retainAll(dom_of_pred);
                }
                new_doms.add(node);
                assert (dom.containsKey(node));
                if (((List)dom.get(node)).equals(new_doms)) continue;
                dom.put(node, new_doms);
                changed = true;
            }
        }
        for (Object node : preds.keySet()) {
            assert (dom.containsKey(node));
            assert (((List)dom.get(node)).contains(node));
        }
        return dom;
    }

    public static <T> void print(Map<T, List<T>> graph, PrintStream ps, int indent) {
        String indentString = "";
        for (int i = 0; i < indent; ++i) {
            indentString = indentString + " ";
        }
        for (T node : graph.keySet()) {
            ps.printf("%s%s%n", indentString, node);
            for (T child : graph.get(node)) {
                ps.printf("  %s%s%n", indentString, child);
            }
        }
    }
}

