/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.util.Arrays;
import java.util.Comparator;

public class FuzzyFloat {
    double min_ratio = 0.9999;
    double max_ratio = 1.0001;
    boolean off = false;

    public FuzzyFloat() {
    }

    public FuzzyFloat(double rel_diff) {
        this.set_rel_diff(rel_diff);
    }

    public void set_rel_diff(double rel_diff) {
        this.min_ratio = 1.0 - rel_diff;
        this.max_ratio = 1.0 + rel_diff;
        this.off = rel_diff == 0.0;
    }

    public boolean eq(double d1, double d2) {
        if (Double.isNaN(d1) && Double.isNaN(d2)) {
            return false;
        }
        if (this.off) {
            return d1 == d2;
        }
        if (d1 == d2) {
            return true;
        }
        if (d1 == 0.0 || d2 == 0.0) {
            double zero_tolerance = Math.pow(this.max_ratio - 1.0, 2.0);
            if (d1 == 0.0) {
                return Math.abs(d2) < zero_tolerance;
            }
            return Math.abs(d1) < zero_tolerance;
        }
        double ratio = d1 / d2;
        return ratio >= this.min_ratio && ratio <= this.max_ratio;
    }

    public boolean ne(double d1, double d2) {
        return !this.eq(d1, d2);
    }

    public boolean lt(double d1, double d2) {
        return d1 < d2 && this.ne(d1, d2);
    }

    public boolean lte(double d1, double d2) {
        return d1 <= d2 || this.eq(d1, d2);
    }

    public boolean gt(double d1, double d2) {
        return d1 > d2 && this.ne(d1, d2);
    }

    public boolean gte(double d1, double d2) {
        return d1 >= d2 || this.eq(d1, d2);
    }

    public int indexOf(double[] a, double elt) {
        for (int i = 0; i < a.length; ++i) {
            if (!this.eq(elt, a[i])) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(double[] a, double[] sub) {
        int a_index_max = a.length - sub.length;
        block0: for (int i = 0; i <= a_index_max; ++i) {
            for (int j = 0; j < sub.length; ++j) {
                if (this.ne(a[i + j], sub[j])) continue block0;
            }
            return i;
        }
        return -1;
    }

    public boolean isElemMatch(double[] a1, double[] a2) {
        int j;
        double val;
        int i;
        a1 = (double[])a1.clone();
        a2 = (double[])a2.clone();
        Arrays.sort(a1);
        Arrays.sort(a2);
        int start = 0;
        for (i = 0; i < a2.length; ++i) {
            block6: {
                val = a2[i];
                for (j = start; j < a1.length; ++j) {
                    if (!this.eq(val, a1[j])) {
                        if (!(val < a1[j])) continue;
                        return false;
                    }
                    break block6;
                }
                return false;
            }
            start = j;
        }
        start = 0;
        for (i = 0; i < a1.length; ++i) {
            block7: {
                val = a1[i];
                for (j = start; j < a2.length; ++j) {
                    if (!this.eq(val, a2[j])) {
                        if (!(val < a2[j])) continue;
                        return false;
                    }
                    break block7;
                }
                return false;
            }
            start = j;
        }
        return true;
    }

    public boolean isSubset(double[] smaller, double[] bigger) {
        smaller = (double[])smaller.clone();
        bigger = (double[])bigger.clone();
        Arrays.sort(smaller);
        Arrays.sort(bigger);
        int start = 0;
        for (int i = 0; i < smaller.length; ++i) {
            int j;
            block3: {
                double val = smaller[i];
                for (j = start; j < bigger.length; ++j) {
                    if (!this.eq(val, bigger[j])) {
                        if (!(val < bigger[j])) continue;
                        return false;
                    }
                    break block3;
                }
                return false;
            }
            start = j;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DoubleArrayComparatorLexical
    implements Comparator<double[]> {
        @Override
        public int compare(double[] a1, double[] a2) {
            if (a1 == a2) {
                return 0;
            }
            int len = Math.min(a1.length, a2.length);
            for (int i = 0; i < len; ++i) {
                if (!FuzzyFloat.this.ne(a1[i], a2[i])) continue;
                return a1[i] > a2[i] ? 1 : -1;
            }
            return a1.length - a2.length;
        }
    }
}

