/*
 * Decompiled with CFR 0.152.
 */
package plume;

import checkers.nullness.quals.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;

public class FileIOException
extends IOException {
    static final long serialVersionUID = 20050923L;
    @Nullable
    public final String fileName;
    public final int lineNumber;

    public FileIOException() {
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(@Nullable Throwable cause) {
        this.initCause(cause);
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(@Nullable String s) {
        super(s);
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(@Nullable String s, @Nullable Throwable cause) {
        super(s);
        this.initCause(cause);
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(@Nullable String s, @Nullable String fileName, int lineNumber) {
        super(s);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public FileIOException(@Nullable String s, @Nullable Throwable cause, @Nullable String fileName, int lineNumber) {
        super(s);
        this.initCause(cause);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public FileIOException(@Nullable LineNumberReader reader, @Nullable Throwable cause) {
        this(reader, (String)null, cause);
    }

    public FileIOException(@Nullable String s, @Nullable LineNumberReader reader) {
        this(s, reader, (String)null);
    }

    public FileIOException(@Nullable String s, @Nullable LineNumberReader reader, @Nullable Throwable cause) {
        this(s, reader, (String)null, cause);
    }

    public FileIOException(@Nullable String s, @Nullable LineNumberReader reader, @Nullable String fileName) {
        super(s);
        this.fileName = fileName;
        this.lineNumber = this.getLineNumber(reader);
    }

    public FileIOException(@Nullable LineNumberReader reader, @Nullable String fileName, @Nullable Throwable cause) {
        this.initCause(cause);
        this.fileName = fileName;
        this.lineNumber = this.getLineNumber(reader);
    }

    public FileIOException(@Nullable String s, @Nullable LineNumberReader reader, @Nullable String fileName, @Nullable Throwable cause) {
        super(s);
        this.initCause(cause);
        this.fileName = fileName;
        this.lineNumber = this.getLineNumber(reader);
    }

    public FileIOException(@Nullable String s, @Nullable LineNumberReader reader, File file) {
        this(s, reader, file.getName());
    }

    public FileIOException(@Nullable String s, @Nullable LineNumberReader reader, File file, @Nullable Throwable cause) {
        this(s, reader, file.getName(), cause);
    }

    public FileIOException(@Nullable LineNumberReader reader, File file, @Nullable Throwable cause) {
        this.initCause(cause);
        this.fileName = file.getName();
        this.lineNumber = this.getLineNumber(reader);
    }

    public String toString() {
        String result = super.toString();
        if (this.fileName != null) {
            result = result + " in file " + this.fileName;
        }
        if (this.lineNumber != -1) {
            result = result + " at line " + this.lineNumber;
        }
        return result;
    }

    private int getLineNumber(@Nullable LineNumberReader reader) {
        if (reader != null) {
            return reader.getLineNumber();
        }
        return -1;
    }
}

