/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import plume.TimeLimitProcess;
import plume.UtilMDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileCompiler {
    public static Runtime runtime = Runtime.getRuntime();
    static Pattern java_filename_pattern;
    private String compiler;
    private long timeLimit;

    public FileCompiler() {
        this("javac", 6000L);
    }

    public FileCompiler(String compiler, long timeLimit) {
        this.compiler = compiler;
        this.timeLimit = timeLimit;
    }

    public void compileFiles(List<String> fileNames) throws IOException {
        TimeLimitProcess p = this.compile_source(fileNames);
        String compile_errors = "";
        String compile_output = "";
        try {
            compile_errors = UtilMDE.streamString(p.getErrorStream());
            compile_output = UtilMDE.streamString(p.getInputStream());
            int result = p.waitFor();
        }
        catch (Throwable e) {
            System.out.println("Unexpected exception while compiling " + e);
            if (p.timed_out()) {
                System.out.println("Compile timed out after " + p.timeout_msecs() + " msecs");
            }
            System.out.println("Compile errors: " + compile_errors);
            System.out.println("Compile output: " + compile_output);
            e.printStackTrace();
            runtime.exit(1);
        }
        if (this.compiler.equals("javac")) {
            this.recompile_without_errors(fileNames, compile_errors);
        }
    }

    private TimeLimitProcess compile_source(String filename) throws IOException {
        String command = this.compiler + " " + filename;
        return new TimeLimitProcess(runtime.exec(command), this.timeLimit, true);
    }

    private TimeLimitProcess compile_source(List<String> filenames) throws IOException {
        int num_files = filenames.size();
        if (num_files == 0) {
            throw new Error("no files to compile were provided");
        }
        String to_compile = filenames.get(0);
        for (int i = 1; i < num_files; ++i) {
            to_compile = to_compile + " " + filenames.get(i);
        }
        String command = this.compiler + " " + to_compile;
        return new TimeLimitProcess(runtime.exec(command), this.timeLimit, true);
    }

    private void recompile_without_errors(List<String> fileNames, String errorString) throws IOException {
        if (errorString != null) {
            HashSet<String> errorClasses = new HashSet<String>();
            Matcher m = java_filename_pattern.matcher(errorString);
            while (m.find()) {
                String sansExtension = m.group(1);
                errorClasses.add(sansExtension);
            }
            ArrayList<String> retry = new ArrayList<String>();
            String filenames = "";
            for (String sourceFileName : fileNames) {
                String classFilePath = FileCompiler.getClassFilePath(sourceFileName = sourceFileName.trim());
                if (FileCompiler.fileExists(classFilePath) || errorClasses.contains(FileCompiler.getClassName(sourceFileName))) continue;
                retry.add(sourceFileName);
                filenames = filenames + " " + sourceFileName;
            }
            if (retry.size() > 0) {
                TimeLimitProcess tp = this.compile_source(retry);
                try {
                    tp.waitFor();
                }
                catch (InterruptedException e) {
                    System.out.println("Compile of " + filenames + " interrupted: " + e);
                }
            }
        }
    }

    private static String getClassFilePath(String sourceFilePath) {
        int index = sourceFilePath.lastIndexOf(46);
        if (index == -1) {
            throw new IllegalArgumentException("sourceFilePath: " + sourceFilePath + " must end with an extention.");
        }
        String classFilePath = sourceFilePath.substring(0, index);
        classFilePath = classFilePath + ".class";
        return classFilePath;
    }

    private static String getClassName(String sourceFilePath) {
        int dotIndex = sourceFilePath.lastIndexOf(46);
        int slashIndex = sourceFilePath.lastIndexOf(File.separator);
        if (dotIndex == -1) {
            throw new IllegalArgumentException("sourceFilePath: " + sourceFilePath + " must end with an extention.");
        }
        if (slashIndex == -1) {
            slashIndex = 0;
        }
        if (dotIndex < slashIndex) {
            throw new IllegalArgumentException("sourceFilePath: " + sourceFilePath + " must end with an extention.");
        }
        return sourceFilePath.substring(slashIndex + 1, dotIndex);
    }

    private static boolean fileExists(String pathName) {
        return new File(pathName).exists();
    }

    static {
        try {
            java_filename_pattern = Pattern.compile("([^" + UtilMDE.escapeNonJava(File.separator) + "]+)\\.java");
        }
        catch (PatternSyntaxException me) {
            me.printStackTrace();
            throw new Error("Error in regexp", me);
        }
    }
}

