/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public class Digest {
    public static byte[] buffer = new byte[4096];
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] getFileDigest(String filename, MessageDigest md) throws IOException {
        md.reset();
        DigestInputStream in = new DigestInputStream(new FileInputStream(filename), md);
        while (in.read(buffer) != -1) {
        }
        byte[] result = md.digest();
        in.close();
        return result;
    }

    public static String hexEncode(byte[] bytes) {
        StringBuffer s = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            s.append(digits[(b & 0xF0) >> 4]);
            s.append(digits[b & 0xF]);
        }
        return s.toString();
    }

    public static byte[] hexDecode(String s) throws IllegalArgumentException {
        try {
            int len = s.length();
            byte[] r = new byte[len / 2];
            for (int i = 0; i < r.length; ++i) {
                int digit1 = s.charAt(i * 2);
                int digit2 = s.charAt(i * 2 + 1);
                if (digit1 >= 48 && digit1 <= 57) {
                    digit1 -= 48;
                } else if (digit1 >= 97 && digit1 <= 102) {
                    digit1 -= 87;
                }
                if (digit2 >= 48 && digit2 <= 57) {
                    digit2 -= 48;
                } else if (digit2 >= 97 && digit2 <= 102) {
                    digit2 -= 87;
                }
                r[i] = (byte)((digit1 << 4) + digit2);
            }
            return r;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("hexDecode(): invalid input");
        }
    }
}

