/*
 * Decompiled with CFR 0.152.
 */
package plume;

import checkers.nullness.quals.Nullable;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class CountingPrintWriter
extends PrintWriter {
    private int writtenBytes;
    private int printedBytes = 0;
    private int writtenChars = 0;
    private int printedChars;
    private static final String lineSep = System.getProperty("line.separator");

    public CountingPrintWriter(OutputStream out) {
        super(out);
    }

    public CountingPrintWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public CountingPrintWriter(Writer out) {
        super(out);
    }

    public CountingPrintWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public int countBytes(String s) {
        if (s == null) {
            return -1;
        }
        int numchars = s.length();
        int numbytes = 0;
        for (int i = 0; i < numchars; ++i) {
            char c = s.charAt(i);
            numbytes += this.countBytes(c);
        }
        return numbytes;
    }

    public int countBytes(char c) {
        if (c >= '\u0001' && c <= '\u007f') {
            return 1;
        }
        if (c > '\u07ff') {
            return 3;
        }
        return 2;
    }

    public int getNumberOfPrintedBytes() {
        return this.printedBytes;
    }

    public int getNumberOfWrittenBytes() {
        return this.writtenBytes;
    }

    public int getNumberOfPrintedChars() {
        return this.printedChars;
    }

    public void print(@Nullable String s) {
        if (s == null) {
            this.printedBytes += this.countBytes("null");
            this.printedChars += 4;
        } else {
            this.printedBytes += this.countBytes(s);
            this.printedChars += s.length();
        }
        super.print(s);
    }

    public void print(boolean b) {
        String s = String.valueOf(b);
        this.printedBytes += this.countBytes(s);
        this.printedChars += s.length();
        super.print(b);
    }

    public void print(char c) {
        this.printedBytes += this.countBytes(c);
        ++this.printedChars;
    }

    public void print(char[] s) {
        for (int i = 0; i < s.length; ++i) {
            this.printedBytes += this.countBytes(s[i]);
        }
        this.printedChars += s.length;
        super.print(s);
    }

    public void print(double d) {
        String s = String.valueOf(d);
        this.printedBytes += this.countBytes(s);
        this.printedChars += s.length();
        super.print(d);
    }

    public void print(float f) {
        String s = String.valueOf(f);
        this.printedBytes += this.countBytes(s);
        this.printedChars += s.length();
        super.print(f);
    }

    public void print(int i) {
        String s = String.valueOf(i);
        this.printedBytes += this.countBytes(s);
        this.printedChars += s.length();
        super.print(i);
    }

    public void resetAll() {
        this.resetPrintedByteCounter();
        this.resetPrintedCharCounter();
        this.resetWrittenByteCounter();
        this.resetWrittenCharCounter();
    }

    public void resetPrintedByteCounter() {
        this.printedBytes = 0;
    }

    public void resetPrintedCharCounter() {
        this.printedChars = 0;
    }

    public void resetWrittenByteCounter() {
        this.writtenBytes = 0;
    }

    public void resetWrittenCharCounter() {
        this.writtenChars = 0;
    }

    public void print(long l) {
        String s = String.valueOf(l);
        this.printedBytes += this.countBytes(s);
        this.printedChars += s.length();
        super.print(l);
    }

    public void print(@Nullable Object obj) {
        String s = String.valueOf(obj);
        this.printedBytes += this.countBytes(s);
        this.printedChars += s.length();
        super.print(obj);
    }

    public void println() {
        this.printedBytes += this.countBytes(lineSep);
        this.printedChars += lineSep.length();
        super.println();
    }

    public void println(@Nullable String x) {
        this.print(x);
        this.println();
    }

    public void write(char[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            this.writtenBytes += this.countBytes(buf[i]);
        }
        this.writtenChars += buf.length;
        super.write(buf);
    }

    public void write(char[] buf, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            this.writtenBytes += this.countBytes(buf[i]);
        }
        this.writtenChars += len;
        super.write(buf, off, len);
    }

    public void write(String s) {
        this.writtenBytes += this.countBytes(s);
        this.writtenChars += s.length();
        super.write(s);
    }

    public void write(String s, int off, int len) {
        this.writtenBytes += this.countBytes(s.substring(off, len));
        this.writtenChars += len;
        super.write(s, off, len);
    }
}

