/*
 * Decompiled with CFR 0.152.
 */
package plume;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import plume.EntryReader;
import plume.UtilMDE;

public class BibtexClean {
    private static Pattern entry_end = Pattern.compile("^[ \t]*(?i)(year[ \t]*=[ \t]*[12][0-9][0-9][0-9][ \t]*)?[)}]");
    private static Pattern stringDef = Pattern.compile("^@(?i)string(\\{.*\\}|\\(.*\\))$");

    public static void main(String[] args) {
        for (String filename : args) {
            EntryReader er;
            PrintWriter out;
            File in = new File(filename);
            try {
                out = new PrintWriter(UtilMDE.bufferedFileWriter(in.getName()));
            }
            catch (IOException e) {
                System.err.println("Unable to write " + in.getName());
                System.exit(2);
                throw new Error("This can't happen");
            }
            try {
                er = new EntryReader(filename);
            }
            catch (IOException e) {
                System.err.println("Unable to read " + in);
                System.exit(2);
                throw new Error("This can't happen");
            }
            block5: for (String line : er) {
                if (line.equals("") || line.startsWith("%")) {
                    out.println(line);
                    continue;
                }
                if (!line.startsWith("@")) continue;
                if (stringDef.matcher(line).matches()) {
                    out.println(line);
                    continue;
                }
                out.println(line);
                while (er.hasNext() && (line = er.next()) != null) {
                    out.println(line);
                    if (entry_end.matcher(line).lookingAt()) continue block5;
                    if (!line.equals("")) continue;
                    System.err.printf("%s:%d: unterminated entry%n", er.getFileName(), er.getLineNumber());
                    continue block5;
                }
            }
            out.close();
        }
    }
}

