/*
 * Decompiled with CFR 0.152.
 */
package plume;

import checkers.interning.quals.PolyInterned;
import checkers.nullness.quals.Nullable;
import checkers.nullness.quals.PolyNull;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import plume.UtilMDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArraysMDE {
    public Vector<?> javadocLossage;

    private ArraysMDE() {
        throw new Error("do not instantiate");
    }

    public static int min(int[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to min(int[])");
        }
        int result = a[0];
        for (int i = 1; i < a.length; ++i) {
            result = Math.min(result, a[i]);
        }
        return result;
    }

    public static long min(long[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to min(long[])");
        }
        long result = a[0];
        for (int i = 1; i < a.length; ++i) {
            result = Math.min(result, a[i]);
        }
        return result;
    }

    public static double min(double[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to min(double[])");
        }
        double result = a[0];
        for (int i = 1; i < a.length; ++i) {
            result = Math.min(result, a[i]);
        }
        return result;
    }

    public static Integer min(Integer[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to min(Integer[])");
        }
        Integer result = a[0];
        int result_int = result;
        for (int i = 1; i < a.length; ++i) {
            if (a[i] >= result_int) continue;
            result = a[i];
            result_int = result;
        }
        return result;
    }

    public static Long min(Long[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to min(Long[])");
        }
        Long result = a[0];
        long result_long = result;
        for (int i = 1; i < a.length; ++i) {
            if (a[i] >= result_long) continue;
            result = a[i];
            result_long = result;
        }
        return result;
    }

    public static Double min(Double[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to min(Double[])");
        }
        Double result = a[0];
        int result_int = result.intValue();
        for (int i = 1; i < a.length; ++i) {
            if (a[i].intValue() >= result_int) continue;
            result = a[i];
            result_int = result.intValue();
        }
        return result;
    }

    public static int max(int[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to max(int[])");
        }
        int result = a[0];
        for (int i = 1; i < a.length; ++i) {
            result = Math.max(result, a[i]);
        }
        return result;
    }

    public static long max(long[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to max(long[])");
        }
        long result = a[0];
        for (int i = 1; i < a.length; ++i) {
            result = Math.max(result, a[i]);
        }
        return result;
    }

    public static double max(double[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to max(double[])");
        }
        double result = a[0];
        for (int i = 1; i < a.length; ++i) {
            result = Math.max(result, a[i]);
        }
        return result;
    }

    public static Integer max(Integer[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to max(Integer[])");
        }
        Integer result = a[0];
        int result_int = result;
        for (int i = 1; i < a.length; ++i) {
            if (a[i] <= result_int) continue;
            result = a[i];
            result_int = result;
        }
        return result;
    }

    public static Long max(Long[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to max(Long[])");
        }
        Long result = a[0];
        long result_long = result;
        for (int i = 1; i < a.length; ++i) {
            if (a[i] <= result_long) continue;
            result = a[i];
            result_long = result;
        }
        return result;
    }

    public static Double max(Double[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to max(Double[])");
        }
        Double result = a[0];
        int result_int = result.intValue();
        for (int i = 1; i < a.length; ++i) {
            if (a[i].intValue() <= result_int) continue;
            result = a[i];
            result_int = result.intValue();
        }
        return result;
    }

    public static int[] min_max(int[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to min_max(int[])");
        }
        int result_min = a[0];
        int result_max = a[0];
        for (int i = 1; i < a.length; ++i) {
            result_min = Math.min(result_min, a[i]);
            result_max = Math.max(result_max, a[i]);
        }
        return new int[]{result_min, result_max};
    }

    public static long[] min_max(long[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to min_max(long[])");
        }
        long result_min = a[0];
        long result_max = a[0];
        for (int i = 1; i < a.length; ++i) {
            result_min = Math.min(result_min, a[i]);
            result_max = Math.max(result_max, a[i]);
        }
        return new long[]{result_min, result_max};
    }

    public static int element_range(int[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to element_range(int[])");
        }
        int[] min_max = ArraysMDE.min_max(a);
        return min_max[1] - min_max[0];
    }

    public static long element_range(long[] a) {
        if (a.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Empty array passed to element_range(long[])");
        }
        long[] min_max = ArraysMDE.min_max(a);
        return min_max[1] - min_max[0];
    }

    public static int sum(int[] a) {
        int sum = 0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static int sum(int[][] a) {
        int sum = 0;
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                sum += a[i][j];
            }
        }
        return sum;
    }

    public static double sum(double[] a) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i];
        }
        return sum;
    }

    public static double sum(double[][] a) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                sum += a[i][j];
            }
        }
        return sum;
    }

    public static <T> int indexOf(T[] a, @Nullable Object elt) {
        if (elt == null) {
            return ArraysMDE.indexOfEq((Object[])a, elt);
        }
        for (int i = 0; i < a.length; ++i) {
            if (!elt.equals(a[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] a, @Nullable Object elt, int minindex, int indexlimit) {
        if (elt == null) {
            return ArraysMDE.indexOfEq(a, elt, minindex, indexlimit);
        }
        for (int i = minindex; i < indexlimit; ++i) {
            if (!elt.equals(a[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(List<? extends Object> a, @Nullable Object elt) {
        return a.indexOf(elt);
    }

    public static int indexOf(List<? extends Object> a, @Nullable Object elt, int minindex, int indexlimit) {
        if (elt == null) {
            return ArraysMDE.indexOfEq(a, elt, minindex, indexlimit);
        }
        for (int i = minindex; i < indexlimit; ++i) {
            if (!elt.equals(a.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfEq(@PolyNull Object[] a, @Nullable Object elt) {
        for (int i = 0; i < a.length; ++i) {
            if (elt != a[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfEq(@PolyNull Object[] a, @Nullable Object elt, int minindex, int indexlimit) {
        for (int i = minindex; i < indexlimit; ++i) {
            if (elt != a[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfEq(List<? extends Object> a, @Nullable Object elt) {
        for (int i = 0; i < a.size(); ++i) {
            if (elt != a.get(i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfEq(List<? extends Object> a, @Nullable Object elt, int minindex, int indexlimit) {
        for (int i = minindex; i < indexlimit; ++i) {
            if (elt != a.get(i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] a, int elt) {
        for (int i = 0; i < a.length; ++i) {
            if (elt != a[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] a, long elt) {
        for (int i = 0; i < a.length; ++i) {
            if (elt != a[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] a, int elt, int minindex, int indexlimit) {
        for (int i = minindex; i < indexlimit; ++i) {
            if (elt != a[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] a, long elt, int minindex, int indexlimit) {
        for (int i = minindex; i < indexlimit; ++i) {
            if (elt != a[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(boolean[] a, boolean elt) {
        for (int i = 0; i < a.length; ++i) {
            if (elt != a[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] a, double elt) {
        for (int i = 0; i < a.length; ++i) {
            if (elt != a[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(boolean[] a, boolean elt, int minindex, int indexlimit) {
        for (int i = minindex; i < indexlimit; ++i) {
            if (elt != a[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] a, Object[] sub) {
        int a_index_max = a.length - sub.length + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarray(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfEq(Object[] a, Object[] sub) {
        int a_index_max = a.length - sub.length + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarrayEq(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(List<?> a, Object[] sub) {
        int a_index_max = a.size() - sub.length + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarray(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfEq(List<?> a, Object[] sub) {
        int a_index_max = a.size() - sub.length + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarrayEq(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] a, List<?> sub) {
        int a_index_max = a.length - sub.size() + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarray(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfEq(Object[] a, List<?> sub) {
        int a_index_max = a.length - sub.size() + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarrayEq(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(List<?> a, List<?> sub) {
        int a_index_max = a.size() - sub.size() + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarray(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfEq(List<?> a, List<?> sub) {
        int a_index_max = a.size() - sub.size() + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarrayEq(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] a, int[] sub) {
        int a_index_max = a.length - sub.length + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarray(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] a, double[] sub) {
        int a_index_max = a.length - sub.length + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarray(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] a, long[] sub) {
        int a_index_max = a.length - sub.length + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarray(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(boolean[] a, boolean[] sub) {
        int a_index_max = a.length - sub.length + 1;
        for (int i = 0; i <= a_index_max; ++i) {
            if (!ArraysMDE.isSubarray(a, sub, i)) continue;
            return i;
        }
        return -1;
    }

    @PolyNull
    @PolyInterned
    public static Object[] subarray(@PolyNull @PolyInterned Object[] a, int startindex, int length) {
        Object[] result = new Object[length];
        System.arraycopy(a, startindex, result, 0, length);
        return result;
    }

    public static <T> List<T> subarray(List<T> a, int startindex, int length) {
        return a.subList(startindex, startindex + length);
    }

    @PolyNull
    @PolyInterned
    public static String[] subarray(@PolyNull @PolyInterned String[] a, int startindex, int length) {
        String[] result = new String[length];
        System.arraycopy(a, startindex, result, 0, length);
        return result;
    }

    public static byte[] subarray(byte[] a, int startindex, int length) {
        byte[] result = new byte[length];
        System.arraycopy(a, startindex, result, 0, length);
        return result;
    }

    public static boolean[] subarray(boolean[] a, int startindex, int length) {
        boolean[] result = new boolean[length];
        System.arraycopy(a, startindex, result, 0, length);
        return result;
    }

    public static char[] subarray(char[] a, int startindex, int length) {
        char[] result = new char[length];
        System.arraycopy(a, startindex, result, 0, length);
        return result;
    }

    public static double[] subarray(double[] a, int startindex, int length) {
        double[] result = new double[length];
        System.arraycopy(a, startindex, result, 0, length);
        return result;
    }

    public static float[] subarray(float[] a, int startindex, int length) {
        float[] result = new float[length];
        System.arraycopy(a, startindex, result, 0, length);
        return result;
    }

    public static int[] subarray(int[] a, int startindex, int length) {
        int[] result = new int[length];
        System.arraycopy(a, startindex, result, 0, length);
        return result;
    }

    public static long[] subarray(long[] a, int startindex, int length) {
        long[] result = new long[length];
        System.arraycopy(a, startindex, result, 0, length);
        return result;
    }

    public static short[] subarray(short[] a, int startindex, int length) {
        short[] result = new short[length];
        System.arraycopy(a, startindex, result, 0, length);
        return result;
    }

    public static boolean isSubarray(Object[] a, Object[] sub, int a_offset) {
        int a_len = a.length - a_offset;
        int sub_len = sub.length;
        if (a_len < sub_len) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub[i].equals(a[a_offset + i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarrayEq(Object[] a, Object[] sub, int a_offset) {
        int a_len = a.length - a_offset;
        int sub_len = sub.length;
        if (a_len < sub_len) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub[i] == a[a_offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(Object[] a, List<?> sub, int a_offset) {
        int a_len = a.length - a_offset;
        int sub_len = sub.size();
        if (a_len < sub_len) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub.get(i).equals(a[a_offset + i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarrayEq(Object[] a, List<?> sub, int a_offset) {
        int a_len = a.length - a_offset;
        int sub_len = sub.size();
        if (a_len < sub_len) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub.get(i) == a[a_offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(List<?> a, Object[] sub, int a_offset) {
        int sub_len;
        int a_len = a.size() - a_offset;
        if (a_len < (sub_len = sub.length)) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub[i].equals(a.get(a_offset + i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarrayEq(List<?> a, Object[] sub, int a_offset) {
        int sub_len;
        int a_len = a.size() - a_offset;
        if (a_len < (sub_len = sub.length)) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub[i] == a.get(a_offset + i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(List<?> a, List<?> sub, int a_offset) {
        int sub_len;
        int a_len = a.size() - a_offset;
        if (a_len < (sub_len = sub.size())) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub.get(i).equals(a.get(a_offset + i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarrayEq(List<?> a, List<?> sub, int a_offset) {
        int sub_len;
        int a_len = a.size() - a_offset;
        if (a_len < (sub_len = sub.size())) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub.get(i) == a.get(a_offset + i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(int[] a, int[] sub, int a_offset) {
        int a_len = a.length - a_offset;
        int sub_len = sub.length;
        if (a_len < sub_len) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub[i] == a[a_offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(long[] a, long[] sub, int a_offset) {
        int a_len = a.length - a_offset;
        int sub_len = sub.length;
        if (a_len < sub_len) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub[i] == a[a_offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(double[] a, double[] sub, int a_offset) {
        int a_len = a.length - a_offset;
        int sub_len = sub.length;
        if (a_len < sub_len) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub[i] == a[a_offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(boolean[] a, boolean[] sub, int a_offset) {
        int a_len = a.length - a_offset;
        int sub_len = sub.length;
        if (a_len < sub_len) {
            return false;
        }
        for (int i = 0; i < sub_len; ++i) {
            if (sub[i] == a[a_offset + i]) continue;
            return false;
        }
        return true;
    }

    private static <T> T[] toTArray(List<T> lst) {
        Object[] asArray = lst.toArray();
        return asArray;
    }

    public static <T> T[] concat(T[] a, T[] b) {
        if (a == null) {
            if (b != null) {
                return b;
            }
            Object[] result = new Object[]{};
            return result;
        }
        if (b == null) {
            return a;
        }
        Object[] result = new Object[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static <T> T[] concat(T[] a, @Nullable List<T> b) {
        if (a == null) {
            if (b != null) {
                return ArraysMDE.toTArray(b);
            }
            Object[] result = new Object[]{};
            return result;
        }
        if (b == null) {
            return a;
        }
        Object[] result = new Object[a.length + b.size()];
        System.arraycopy(a, 0, result, 0, a.length);
        for (int i = 0; i < b.size(); ++i) {
            result[i + a.length] = b.get(i);
        }
        return result;
    }

    public static <T> T[] concat(@Nullable List<T> a, T[] b) {
        if (a == null) {
            if (b != null) {
                return b;
            }
            Object[] result = new Object[]{};
            return result;
        }
        if (b == null) {
            return ArraysMDE.toTArray(a);
        }
        Object[] result = new Object[a.size() + b.length];
        for (int i = 0; i < a.size(); ++i) {
            result[i] = a.get(i);
        }
        System.arraycopy(b, 0, result, a.size(), b.length);
        return result;
    }

    public static <T> T[] concat(@Nullable List<T> a, @Nullable List<T> b) {
        int i;
        if (a == null) {
            if (b != null) {
                return ArraysMDE.toTArray(b);
            }
            Object[] result = new Object[]{};
            return result;
        }
        if (b == null) {
            return ArraysMDE.toTArray(a);
        }
        Object[] result = new Object[a.size() + b.size()];
        for (i = 0; i < a.size(); ++i) {
            result[i] = a.get(i);
        }
        for (i = 0; i < b.size(); ++i) {
            result[i + a.size()] = b.get(i);
        }
        return result;
    }

    public static String[] concat(String[] a, String[] b) {
        if (a == null) {
            if (b == null) {
                return new String[0];
            }
            return b;
        }
        if (b == null) {
            return a;
        }
        String[] result = new String[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static byte[] concat(byte[] a, byte[] b) {
        if (a == null) {
            if (b == null) {
                return new byte[0];
            }
            return b;
        }
        if (b == null) {
            return a;
        }
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static boolean[] concat(boolean[] a, boolean[] b) {
        if (a == null) {
            if (b == null) {
                return new boolean[0];
            }
            return b;
        }
        if (b == null) {
            return a;
        }
        boolean[] result = new boolean[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static char[] concat(char[] a, char[] b) {
        if (a == null) {
            if (b == null) {
                return new char[0];
            }
            return b;
        }
        if (b == null) {
            return a;
        }
        char[] result = new char[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static double[] concat(double[] a, double[] b) {
        if (a == null) {
            if (b == null) {
                return new double[0];
            }
            return b;
        }
        if (b == null) {
            return a;
        }
        double[] result = new double[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static float[] concat(float[] a, float[] b) {
        if (a == null) {
            if (b == null) {
                return new float[0];
            }
            return b;
        }
        if (b == null) {
            return a;
        }
        float[] result = new float[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static int[] concat(int[] a, int[] b) {
        if (a == null) {
            if (b == null) {
                return new int[0];
            }
            return b;
        }
        if (b == null) {
            return a;
        }
        int[] result = new int[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static long[] concat(long[] a, long[] b) {
        if (a == null) {
            if (b == null) {
                return new long[0];
            }
            return b;
        }
        if (b == null) {
            return a;
        }
        long[] result = new long[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static short[] concat(short[] a, short[] b) {
        if (a == null) {
            if (b == null) {
                return new short[0];
            }
            return b;
        }
        if (b == null) {
            return a;
        }
        short[] result = new short[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public static String toString(Object[] a) {
        return ArraysMDE.toString(a, false);
    }

    public static String toStringQuoted(Object[] a) {
        return ArraysMDE.toString(a, true);
    }

    public static String toString(Object[] a, boolean quoted) {
        if (a == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (a.length > 0) {
            sb.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sb.append(", ");
                if (quoted) {
                    sb.append('\"');
                    sb.append(UtilMDE.escapeNonJava((String)a[i]));
                    sb.append('\"');
                    continue;
                }
                sb.append(a[i]);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(@Nullable List<?> a) {
        return ArraysMDE.toString(a, false);
    }

    public static String toStringQuoted(@Nullable List<?> a) {
        return ArraysMDE.toString(a, true);
    }

    public static String toString(@Nullable List<?> a, boolean quoted) {
        if (a == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (a.size() > 0) {
            sb.append(a.get(0));
            for (int i = 1; i < a.size(); ++i) {
                sb.append(", ");
                if (quoted) {
                    sb.append('\"');
                    sb.append(UtilMDE.escapeNonJava((String)a.get(i)));
                    sb.append('\"');
                    continue;
                }
                sb.append(a.get(i));
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(int[] a) {
        if (a == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (a.length > 0) {
            sb.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sb.append(", ");
                sb.append(a[i]);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(long[] a) {
        if (a == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (a.length > 0) {
            sb.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sb.append(", ");
                sb.append(a[i]);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(double[] a) {
        if (a == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (a.length > 0) {
            sb.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sb.append(", ");
                sb.append(a[i]);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(float[] a) {
        if (a == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (a.length > 0) {
            sb.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sb.append(", ");
                sb.append(a[i]);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(boolean[] a) {
        if (a == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        if (a.length > 0) {
            sb.append(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sb.append(", ");
                sb.append(a[i]);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(Object obj) throws IllegalArgumentException {
        if (obj instanceof boolean[]) {
            return ArraysMDE.toString((boolean[])obj);
        }
        if (obj instanceof double[]) {
            return ArraysMDE.toString((double[])obj);
        }
        if (obj instanceof float[]) {
            return ArraysMDE.toString((float[])obj);
        }
        if (obj instanceof int[]) {
            return ArraysMDE.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return ArraysMDE.toString((long[])obj);
        }
        if (obj instanceof Object[]) {
            return ArraysMDE.toString((Object[])obj);
        }
        if (obj instanceof List) {
            return ArraysMDE.toString((List)obj);
        }
        throw new IllegalArgumentException("Argument is " + (obj == null ? "null" : "of class " + obj.getClass().getName()));
    }

    public static int length(Object obj) throws IllegalArgumentException {
        if (obj instanceof boolean[]) {
            return ((boolean[])obj).length;
        }
        if (obj instanceof double[]) {
            return ((double[])obj).length;
        }
        if (obj instanceof int[]) {
            return ((int[])obj).length;
        }
        if (obj instanceof long[]) {
            return ((long[])obj).length;
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj).length;
        }
        if (obj instanceof List) {
            return ((List)obj).size();
        }
        throw new IllegalArgumentException("Argument is " + (obj == null ? "null" : "of class " + obj.getClass().getName()));
    }

    public static boolean sorted(int[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (a[i + 1] >= a[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean sorted(long[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (a[i + 1] >= a[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean sorted_descending(int[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (a[i + 1] <= a[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean sorted_descending(long[] a) {
        for (int i = 0; i < a.length - 1; ++i) {
            if (a[i + 1] <= a[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean noDuplicates(boolean[] a) {
        HashSet<Boolean> hs = new HashSet<Boolean>();
        for (int i = 0; i < a.length; ++i) {
            Boolean n = a[i];
            if (hs.contains(n)) {
                return false;
            }
            hs.add(n);
        }
        return true;
    }

    public static boolean noDuplicates(byte[] a) {
        HashSet<Byte> hs = new HashSet<Byte>();
        for (int i = 0; i < a.length; ++i) {
            Byte n = new Byte(a[i]);
            if (hs.contains(n)) {
                return false;
            }
            hs.add(n);
        }
        return true;
    }

    public static boolean noDuplicates(char[] a) {
        HashSet<Character> hs = new HashSet<Character>();
        for (int i = 0; i < a.length; ++i) {
            Character n = new Character(a[i]);
            if (hs.contains(n)) {
                return false;
            }
            hs.add(n);
        }
        return true;
    }

    public static boolean noDuplicates(float[] a) {
        HashSet<Float> hs = new HashSet<Float>();
        for (int i = 0; i < a.length; ++i) {
            Float n = new Float(a[i]);
            if (hs.contains(n)) {
                return false;
            }
            hs.add(n);
        }
        return true;
    }

    public static boolean noDuplicates(short[] a) {
        HashSet<Short> hs = new HashSet<Short>();
        for (int i = 0; i < a.length; ++i) {
            Short n = new Short(a[i]);
            if (hs.contains(n)) {
                return false;
            }
            hs.add(n);
        }
        return true;
    }

    public static boolean noDuplicates(int[] a) {
        HashSet<Integer> hs = new HashSet<Integer>();
        for (int i = 0; i < a.length; ++i) {
            Integer n = new Integer(a[i]);
            if (hs.contains(n)) {
                return false;
            }
            hs.add(n);
        }
        return true;
    }

    public static boolean noDuplicates(double[] a) {
        HashSet<Double> hs = new HashSet<Double>();
        for (int i = 0; i < a.length; ++i) {
            Double n = new Double(a[i]);
            if (hs.contains(n)) {
                return false;
            }
            hs.add(n);
        }
        return true;
    }

    public static boolean noDuplicates(long[] a) {
        HashSet<Long> hs = new HashSet<Long>();
        for (int i = 0; i < a.length; ++i) {
            Long n = new Long(a[i]);
            if (hs.contains(n)) {
                return false;
            }
            hs.add(n);
        }
        return true;
    }

    public static boolean noDuplicates(String[] a) {
        HashSet<String> hs = new HashSet<String>();
        for (int i = 0; i < a.length; ++i) {
            if (hs.contains(a[i])) {
                return false;
            }
            hs.add(a[i]);
        }
        return true;
    }

    public static boolean noDuplicates(Object[] a) {
        HashSet<Object> hs = new HashSet<Object>();
        for (int i = 0; i < a.length; ++i) {
            if (hs.contains(a[i])) {
                return false;
            }
            hs.add(a[i]);
        }
        return true;
    }

    public static <T> boolean noDuplicates(List<T> a) {
        HashSet<T> hs = new HashSet<T>();
        for (int i = 0; i < a.size(); ++i) {
            if (hs.contains(a.get(i))) {
                return false;
            }
            hs.add(a.get(i));
        }
        return true;
    }

    public static boolean fn_is_permutation(int[] a) {
        boolean[] see = new boolean[a.length];
        for (int i = 0; i < a.length; ++i) {
            int n = a[i];
            if (n < 0 || n >= a.length || see[n]) {
                return false;
            }
            see[n] = true;
        }
        return true;
    }

    public static boolean fn_is_total(int[] a) {
        return ArraysMDE.indexOf(a, -1) == -1;
    }

    public static int[] fn_identity(int length) {
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public static int[] fn_inverse_permutation(int[] a) {
        return ArraysMDE.fn_inverse(a, a.length);
    }

    public static int[] fn_inverse(int[] a, int arange) {
        int[] result = new int[arange];
        Arrays.fill(result, -1);
        for (int i = 0; i < a.length; ++i) {
            int ai = a[i];
            if (ai == -1) continue;
            if (result[ai] != -1) {
                throw new UnsupportedOperationException("Not invertible");
            }
            result[ai] = i;
        }
        return result;
    }

    public static int[] fn_compose(int[] a, int[] b) {
        int[] result = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            int inner = a[i];
            result[i] = inner == -1 ? -1 : b[inner];
        }
        return result;
    }

    public static boolean isSubset(long[] smaller, long[] bigger) {
        int i;
        HashSet<Long> setBigger = new HashSet<Long>();
        for (i = 0; i < bigger.length; ++i) {
            setBigger.add(new Long(bigger[i]));
        }
        for (i = 0; i < smaller.length; ++i) {
            Long elt = new Long(smaller[i]);
            if (setBigger.contains(elt)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubset(double[] smaller, double[] bigger) {
        int i;
        HashSet<Double> setBigger = new HashSet<Double>();
        for (i = 0; i < bigger.length; ++i) {
            setBigger.add(new Double(bigger[i]));
        }
        for (i = 0; i < smaller.length; ++i) {
            Double elt = new Double(smaller[i]);
            if (setBigger.contains(elt)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubset(String[] smaller, String[] bigger) {
        int i;
        HashSet<String> setBigger = new HashSet<String>();
        for (i = 0; i < bigger.length; ++i) {
            setBigger.add(bigger[i]);
        }
        for (i = 0; i < smaller.length; ++i) {
            if (setBigger.contains(smaller[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean any_null(Object[] a) {
        if (a.length == 0) {
            return false;
        }
        return ArraysMDE.indexOfEq(a, (Object)null) >= 0;
    }

    public static boolean all_null(Object[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean any_null(List<?> a) {
        if (a.size() == 0) {
            return false;
        }
        return ArraysMDE.indexOfEq(a, (Object)null) >= 0;
    }

    public static boolean all_null(List<?> a) {
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i) == null) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ObjectArrayComparatorLengthFirst
    implements Comparator<Object[]> {
        @Override
        public int compare(Object[] a1, Object[] a2) {
            if (a1 == a2) {
                return 0;
            }
            int tmp = a1.length - a2.length;
            if (tmp != 0) {
                return tmp;
            }
            for (int i = 0; i < a1.length; ++i) {
                Object elt1 = a1[i];
                Object elt2 = a2[i];
                if (elt1 == null && elt2 == null) continue;
                if (elt1 == null) {
                    return -1;
                }
                if (elt2 == null) {
                    return 1;
                }
                tmp = elt1.hashCode() - elt2.hashCode();
                if (tmp != 0) {
                    return tmp;
                }
                assert (elt1.equals(elt2));
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ComparableArrayComparatorLengthFirst<T extends Comparable<T>>
    implements Comparator<T[]> {
        @Override
        public int compare(T[] a1, T[] a2) {
            if (a1 == a2) {
                return 0;
            }
            int tmp = a1.length - a2.length;
            if (tmp != 0) {
                return tmp;
            }
            for (int i = 0; i < a1.length; ++i) {
                T elt1 = a1[i];
                T elt2 = a2[i];
                if (elt1 == null && elt2 == null) continue;
                if (elt1 == null) {
                    return -1;
                }
                if (elt2 == null) {
                    return 1;
                }
                tmp = elt1.compareTo(elt2);
                if (tmp != 0) {
                    return tmp;
                }
                assert (elt1.equals(elt2));
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LongArrayComparatorLengthFirst
    implements Comparator<long[]> {
        @Override
        public int compare(long[] a1, long[] a2) {
            if (a1 == a2) {
                return 0;
            }
            int lendiff = a1.length - a2.length;
            if (lendiff != 0) {
                return lendiff;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return a1[i] > a2[i] ? 1 : -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IntArrayComparatorLengthFirst
    implements Comparator<int[]> {
        @Override
        public int compare(int[] a1, int[] a2) {
            if (a1 == a2) {
                return 0;
            }
            int tmp = a1.length - a2.length;
            if (tmp != 0) {
                return tmp;
            }
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return a1[i] > a2[i] ? 1 : -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ObjectArrayComparatorLexical
    implements Comparator<Object[]> {
        @Override
        public int compare(Object[] a1, Object[] a2) {
            if (a1 == a2) {
                return 0;
            }
            int len = Math.min(a1.length, a2.length);
            for (int i = 0; i < len; ++i) {
                Object elt1 = a1[i];
                Object elt2 = a2[i];
                if (elt1 == null && elt2 == null) continue;
                if (elt1 == null) {
                    return -1;
                }
                if (elt2 == null) {
                    return 1;
                }
                int tmp = elt1.hashCode() - elt2.hashCode();
                if (tmp != 0) {
                    return tmp;
                }
                assert (elt1.equals(elt2));
            }
            return a1.length - a2.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ComparableArrayComparatorLexical<T extends Comparable<T>>
    implements Comparator<T[]> {
        @Override
        public int compare(T[] a1, T[] a2) {
            if (a1 == a2) {
                return 0;
            }
            int len = Math.min(a1.length, a2.length);
            for (int i = 0; i < len; ++i) {
                T elt1 = a1[i];
                T elt2 = a2[i];
                if (elt1 == null && elt2 == null) continue;
                if (elt1 == null) {
                    return -1;
                }
                if (elt2 == null) {
                    return 1;
                }
                int tmp = elt1.compareTo(elt2);
                if (tmp != 0) {
                    return tmp;
                }
                assert (elt1.equals(elt2));
            }
            return a1.length - a2.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StringArrayComparatorLexical
    implements Comparator<String[]> {
        @Override
        public int compare(String[] a1, String[] a2) {
            if (a1 == a2) {
                return 0;
            }
            int len = Math.min(a1.length, a2.length);
            for (int i = 0; i < len; ++i) {
                int tmp = 0;
                tmp = a1[i] == null && a2[i] == null ? 0 : (a1[i] == null ? -1 : (a2[i] == null ? 1 : a1[i].compareTo(a2[i])));
                if (tmp == 0) continue;
                return tmp;
            }
            return a1.length - a2.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoubleArrayComparatorLexical
    implements Comparator<double[]> {
        @Override
        public int compare(double[] a1, double[] a2) {
            if (a1 == a2) {
                return 0;
            }
            int len = Math.min(a1.length, a2.length);
            for (int i = 0; i < len; ++i) {
                int result = Double.compare(a1[i], a2[i]);
                if (result == 0) continue;
                return result;
            }
            return a1.length - a2.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LongArrayComparatorLexical
    implements Comparator<long[]> {
        @Override
        public int compare(long[] a1, long[] a2) {
            if (a1 == a2) {
                return 0;
            }
            int len = Math.min(a1.length, a2.length);
            for (int i = 0; i < len; ++i) {
                if (a1[i] == a2[i]) continue;
                return a1[i] > a2[i] ? 1 : -1;
            }
            return a1.length - a2.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IntArrayComparatorLexical
    implements Comparator<int[]> {
        @Override
        public int compare(int[] a1, int[] a2) {
            if (a1 == a2) {
                return 0;
            }
            int len = Math.min(a1.length, a2.length);
            for (int i = 0; i < len; ++i) {
                if (a1[i] == a2[i]) continue;
                return a1[i] > a2[i] ? 1 : -1;
            }
            return a1.length - a2.length;
        }
    }
}

