/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.ISVNExtendedMergeCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExtendedMergeDriver;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteDiffEditor;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNCopyTask;
import org.tmatesoft.svn.core.wc.SVNEditorAction;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNExtendedMergeEditor
extends SVNRemoteDiffEditor {
    private ISVNExtendedMergeCallback myMergeCallback;
    private SVNExtendedMergeDriver myMergeDriver;
    private SVNWCAccess myWCAccess;
    private SVNDepth myDepth;
    private SVNURL mySourceURL;
    private SVNURL myTargetURL;
    private Stack myDirectories;

    public SVNExtendedMergeEditor(SVNExtendedMergeDriver mergeDriver, ISVNExtendedMergeCallback mergeCallback, SVNAdminArea adminArea, File target, AbstractDiffCallback callback, SVNURL sourceURL, SVNRepository repos, long revision1, long revision2, boolean dryRun, SVNDepth depth, ISVNEventHandler handler, ISVNEventHandler cancelHandler) throws SVNException {
        super(adminArea, target, callback, repos, revision1, revision2, dryRun, handler, cancelHandler);
        SVNEntry rootEntry = adminArea.getEntry(adminArea.getThisDirName(), false);
        String url = rootEntry.getURL();
        this.myWCAccess = adminArea.getWCAccess();
        this.myDepth = depth;
        this.myTargetURL = SVNURL.parseURIEncoded(url);
        this.myMergeCallback = mergeCallback;
        this.myMergeDriver = mergeDriver;
        this.mySourceURL = sourceURL;
        this.myDirectories = new Stack();
    }

    public ISVNExtendedMergeCallback getMergeCallback() {
        return this.myMergeCallback;
    }

    public SVNExtendedMergeDriver getMergeDriver() {
        return this.myMergeDriver;
    }

    protected File getTempDirectory() throws SVNException {
        return this.getMergeDriver().getTempDirectory();
    }

    protected Stack getDirectories() {
        return this.myDirectories;
    }

    protected boolean checkDepth(File path, SVNEntry entry, SVNNodeKind kind) throws SVNException {
        if (path.equals(this.myTarget)) {
            return true;
        }
        boolean reportDepthAllows = this.checkReportDepth(path, kind);
        if (!reportDepthAllows) {
            return false;
        }
        return this.checkSparseWC(path, entry, kind);
    }

    private boolean checkReportDepth(File path, SVNNodeKind kind) {
        if (this.myDepth == SVNDepth.EMPTY) {
            return false;
        }
        if (!(this.myDepth != SVNDepth.IMMEDIATES && this.myDepth != SVNDepth.FILES || this.myTarget.equals(path.getParentFile()))) {
            return false;
        }
        return this.myDepth != SVNDepth.FILES || kind != SVNNodeKind.DIR;
    }

    private boolean checkSparseWC(File path, SVNEntry entry, SVNNodeKind kind) throws SVNException {
        if (entry != null) {
            return true;
        }
        entry = this.myWCAccess.getEntry(path, true);
        if (entry != null) {
            return true;
        }
        File parentPath = path.getParentFile();
        SVNEntry parentEntry = this.myWCAccess.getEntry(parentPath, true);
        if (parentEntry != null) {
            SVNDepth parentDepth = parentEntry.getDepth();
            return SVNExtendedMergeEditor.checkEntryDepth(parentDepth, kind);
        }
        return this.walkToTarget(parentPath);
    }

    private boolean walkToTarget(File path) throws SVNException {
        if (this.myTarget.equals(path)) {
            return true;
        }
        File parentPath = path.getParentFile();
        SVNEntry parentEntry = this.myWCAccess.getEntry(parentPath, true);
        if (parentEntry != null) {
            SVNDepth parentDepth = parentEntry.getDepth();
            return SVNExtendedMergeEditor.checkEntryDepth(parentDepth, SVNNodeKind.DIR);
        }
        return this.walkToTarget(parentPath);
    }

    private static boolean checkEntryDepth(SVNDepth parentDepth, SVNNodeKind kind) {
        if (parentDepth == SVNDepth.EMPTY) {
            return false;
        }
        return parentDepth != SVNDepth.FILES || kind == SVNNodeKind.FILE;
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        SVNNodeKind nodeKind = this.myRepos.checkPath(path, this.myRevision1);
        SVNAdminArea dir = this.retrieve(this.myCurrentDirectory.myWCFile, true);
        if (nodeKind != SVNNodeKind.FILE) {
            this.deleteEntry(path, nodeKind, dir);
            return;
        }
        long targetRevision = this.getTargetRevision(path);
        SVNURL[] targets = this.getMergeCallback().getTrueMergeTargets(this.getSourceURL(path), this.myRevision1, this.myRevision1, this.myRevision2, this.getTargetURL(path), targetRevision, SVNEditorAction.DELETE);
        if (targets == null) {
            this.deleteEntry(path, nodeKind, dir);
            return;
        }
        SVNFileInfoExt fileInfo = null;
        File expectedTarget = this.getFile(path);
        for (int i = 0; i < targets.length; ++i) {
            boolean depthAllows;
            SVNURL targetURL = targets[i];
            String targetPath = this.getPath(targetURL);
            File target = this.getFile(targetPath);
            if (!expectedTarget.equals(target) && !(depthAllows = this.checkDepth(target, null, nodeKind))) continue;
            fileInfo = this.getFileInfo(path, revision, SVNEditorAction.DELETE, nodeKind);
            fileInfo.addTarget(targetPath, null);
        }
        if (fileInfo != null) {
            fileInfo.delete();
        }
        this.myCurrentFile = null;
    }

    private File getCopySourcePath(SVNCopySource source) {
        if (source == null) {
            return null;
        }
        if (!source.isURL()) {
            return source.getFile();
        }
        File target = null;
        String sPath = SVNPathUtil.getPathAsChild(this.mySourceURL.getPath(), source.getURL().getPath());
        String tPath = SVNPathUtil.getPathAsChild(this.myTargetURL.getPath(), source.getURL().getPath());
        if (sPath != null) {
            target = this.getFile(sPath);
        } else if (tPath != null) {
            target = this.getFile(tPath);
        } else {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "merge ext: Neither merge source URL nor merge target URL are not ancestors of copy source URL");
        }
        return target;
    }

    private SVNURL getCopySourceURL(SVNCopySource source) throws SVNException {
        if (source == null) {
            return null;
        }
        if (source.isURL()) {
            return source.getURL();
        }
        String relativePath = SVNPathUtil.getPathAsChild(this.myTarget.getAbsolutePath(), source.getFile().getAbsolutePath());
        if (relativePath == null) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "merge ext: illegal file path passed as copy source");
            return null;
        }
        return this.myTargetURL.appendPath(relativePath, false);
    }

    private void deletePath(File file) throws SVNException {
        if (file == null) {
            return;
        }
        String path = this.getPath(file);
        SVNStatusType type = SVNStatusType.INAPPLICABLE;
        SVNEventAction action = SVNEventAction.SKIP;
        SVNEventAction expectedAction = SVNEventAction.UPDATE_DELETE;
        SVNEntry entry = this.myWCAccess.getEntry(file, false);
        if (entry == null) {
            return;
        }
        SVNNodeKind nodeKind = entry.getKind();
        SVNAdminArea dir = this.retrieve(this.myCurrentDirectory.myWCFile, true);
        if (dir != null) {
            if (nodeKind == SVNNodeKind.FILE) {
                SVNVersionedProperties baseProperties = dir.getBaseProperties(file.getName());
                String baseType = baseProperties.getStringPropertyValue("svn:mime-type");
                File baseFile = dir.getBaseFile(file.getName(), false);
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "merge ext: del " + path);
                type = this.getDiffCallback().fileDeleted(path, baseFile, null, baseType, null, baseProperties.asMap(), null);
            } else if (nodeKind == SVNNodeKind.DIR) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "merge ext: attempt to delete directory " + path + " skipped");
            }
            if (type != SVNStatusType.MISSING && type != SVNStatusType.OBSTRUCTED) {
                action = SVNEventAction.UPDATE_DELETE;
                if (this.myIsDryRun) {
                    this.getDiffCallback().addDeletedPath(path);
                }
            }
        }
        this.addDeletedPath(path, nodeKind, type, action, expectedAction);
    }

    protected void addDeletedPath(String path, SVNNodeKind nodeKind, SVNStatusType type, SVNEventAction action, SVNEventAction expectedAction) {
        File deletedFile;
        SVNRemoteDiffEditor.KindActionState kas;
        if (this.myEventHandler != null && (kas = (SVNRemoteDiffEditor.KindActionState)this.myDeletedPaths.get(deletedFile = this.getFile(path))) != null && action == SVNEventAction.SKIP && (kas.myAction == SVNEventAction.UPDATE_DELETE || kas.myAction == SVNEventAction.SKIP)) {
            return;
        }
        super.addDeletedPath(path, nodeKind, type, action, expectedAction, false);
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNURL url = this.getSourceURL(path);
        SVNURL expectedTargetURL = this.getTargetURL(path);
        long targetRevision = this.getTargetRevision(path);
        SVNURL[] mergeURLs = this.getMergeCallback().getTrueMergeTargets(url, Math.max(this.myRevision1, this.myRevision2), this.myRevision1, this.myRevision2, expectedTargetURL, targetRevision, SVNEditorAction.ADD);
        if (mergeURLs == null) {
            super.addFile(path, copyFromPath, copyFromRevision);
            return;
        }
        for (int i = 0; i < mergeURLs.length; ++i) {
            boolean applyDelta;
            SVNEntry targetEntry;
            boolean targetExists;
            File deleteTarget;
            boolean depthAllows;
            boolean deleteSource;
            boolean depthAllows2;
            SVNURL targetURL = mergeURLs[i];
            String targetPath = this.getPath(targetURL);
            File target = this.getFile(targetPath);
            if (!expectedTargetURL.equals(targetURL) && !(depthAllows2 = this.checkDepth(target, null, SVNNodeKind.FILE))) continue;
            SVNURL[] mergeSources = new SVNURL[2];
            SVNMergeRangeList remainingRanges = this.getMergeDriver().calculateRemainingRanges(target, url, mergeSources);
            boolean mergeInfoConflicts = this.getMergeDriver().mergeInfoConflicts(remainingRanges, target);
            SVNCopyTask copyTask = this.getMergeCallback().getTargetCopySource(url, Math.max(this.myRevision1, this.myRevision2), this.myRevision1, this.myRevision2, targetURL, targetRevision);
            SVNCopySource copySource = copyTask == null ? null : copyTask.getCopySource();
            copySource = this.processCopySource(copySource, targetRevision);
            boolean bl = deleteSource = copyTask != null && copyTask.isMove();
            if (deleteSource && (depthAllows = this.checkDepth(deleteTarget = this.getCopySourcePath(copySource), null, SVNNodeKind.FILE))) {
                this.deletePath(deleteTarget);
            }
            boolean bl2 = targetExists = (targetEntry = this.myWCAccess.getEntry(target, true)) != null && !targetEntry.isScheduledForDeletion();
            if (targetExists) {
                this.getMergeDriver().addMergeSource(path, mergeSources, target, remainingRanges, mergeInfoConflicts, copySource);
                applyDelta = false;
            } else {
                applyDelta = true;
            }
            if (!applyDelta) continue;
            SVNFileInfoExt fileInfo = this.getFileInfo(path, -1L, SVNEditorAction.ADD, null);
            fileInfo.addTarget(targetPath, copySource);
        }
    }

    public void openFile(String path, long revision) throws SVNException {
        SVNURL url = this.getSourceURL(path);
        SVNURL expectedTargetURL = this.getTargetURL(path);
        long targetRevision = this.getTargetRevision(path);
        SVNURL[] mergeURLs = this.getMergeCallback().getTrueMergeTargets(url, Math.max(this.myRevision1, this.myRevision2), this.myRevision1, this.myRevision2, this.getTargetURL(path), targetRevision, SVNEditorAction.MODIFY);
        if (mergeURLs == null) {
            super.openFile(path, revision);
            return;
        }
        for (int i = 0; i < mergeURLs.length; ++i) {
            boolean applyDelta;
            SVNEntry targetEntry;
            boolean targetExists;
            File deleteTarget;
            boolean depthAllows;
            boolean deleteSource;
            boolean depthAllows2;
            SVNURL targetURL = mergeURLs[i];
            String targetPath = this.getPath(targetURL);
            File target = this.getFile(targetPath);
            if (!expectedTargetURL.equals(targetURL) && !(depthAllows2 = this.checkDepth(target, null, SVNNodeKind.FILE))) continue;
            SVNURL[] mergeSources = new SVNURL[2];
            SVNMergeRangeList remainingRanges = this.getMergeDriver().calculateRemainingRanges(target, url, mergeSources);
            boolean mergeInfoConflicts = this.getMergeDriver().mergeInfoConflicts(remainingRanges, target);
            SVNCopyTask copyTask = this.getMergeCallback().getTargetCopySource(url, Math.max(this.myRevision1, this.myRevision2), this.myRevision1, this.myRevision2, targetURL, targetRevision);
            SVNCopySource copySource = copyTask == null ? null : copyTask.getCopySource();
            copySource = this.processCopySource(copySource, targetRevision);
            boolean bl = deleteSource = copyTask != null && copyTask.isMove();
            if (deleteSource && (depthAllows = this.checkDepth(deleteTarget = this.getCopySourcePath(copySource), null, SVNNodeKind.FILE))) {
                this.deletePath(deleteTarget);
            }
            boolean bl2 = targetExists = (targetEntry = this.myWCAccess.getEntry(target, true)) != null && !targetEntry.isScheduledForDeletion();
            if (targetExists) {
                if (mergeInfoConflicts) {
                    this.getMergeDriver().addMergeSource(path, mergeSources, target, remainingRanges, true, copySource);
                    applyDelta = false;
                } else {
                    applyDelta = true;
                }
            } else {
                if (copySource != null) {
                    this.getMergeDriver().copy(copySource, target, false);
                }
                applyDelta = true;
            }
            if (!applyDelta) continue;
            SVNFileInfoExt fileInfo = this.getFileInfo(path, revision, SVNEditorAction.MODIFY, null);
            fileInfo.addTarget(targetPath, copySource);
        }
    }

    private SVNCopySource processCopySource(SVNCopySource copySource, long targetRevision) throws SVNException {
        SVNRevision revision;
        SVNRevision pegRevision;
        if (copySource == null) {
            return null;
        }
        if (copySource.isURL() && copySource.getRevision() != null && copySource.getRevision().getID() == 10) {
            return copySource;
        }
        try {
            pegRevision = this.processCopySourceRevision(copySource.getPegRevision(), copySource, targetRevision);
            revision = this.processCopySourceRevision(copySource.getRevision(), copySource, targetRevision);
        }
        catch (SVNException e) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "merge ext: Error while fetching copy source revision");
            return null;
        }
        SVNURL url = copySource.getURL();
        if (url == null && (url = this.getCopySourceURL(copySource)) == null) {
            return null;
        }
        return new SVNCopySource(pegRevision, revision, url);
    }

    private SVNRevision processCopySourceRevision(SVNRevision revision, SVNCopySource copySource, long targetRevision) throws SVNException {
        if (revision.getID() == 10) {
            return revision;
        }
        if (revision == SVNRevision.WORKING || revision == SVNRevision.BASE) {
            return SVNRevision.create(targetRevision);
        }
        return SVNRevision.create(this.getMergeDriver().getRevision(copySource));
    }

    private long getTargetRevision(String path) throws SVNException {
        File file = this.getFile(path);
        SVNEntry entry = this.myWCAccess.getEntry(file, true);
        return this.calculateTargetRevision(this.myWCAccess, entry, file);
    }

    public void openDir(String path, long revision) throws SVNException {
        super.openDir(path, revision);
        this.processDir(path, false);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        super.addDir(path, copyFromPath, copyFromRevision);
        this.processDir(path, true);
    }

    private void processDir(String path, boolean remoteAdd) throws SVNException {
        boolean added;
        File dir = this.getFile(path);
        SVNEntry dirEntry = this.myWCAccess.getEntry(dir, true);
        long dirRevision = this.calculateTargetRevision(this.myWCAccess, dirEntry, dir);
        boolean skipped = dirEntry == null;
        boolean bl = added = dirEntry != null && (dirEntry.isScheduledForAddition() || dirEntry.isScheduledForReplacement());
        if (skipped || added) {
            SVNDirectoryInfoExt dirInfo = new SVNDirectoryInfoExt(dirRevision);
            dirInfo.myAdded = added;
            dirInfo.myRemotelyAdded = remoteAdd;
            dirInfo.mySkipped = skipped;
            this.getDirectories().push(dirInfo);
        }
    }

    private long calculateTargetRevision(SVNWCAccess access, SVNEntry entry, File path) throws SVNException {
        long targetRevision;
        if (entry == null) {
            if (this.getDirectories().empty()) {
                SVNEntry parentEntry = access.getEntry(path.getParentFile(), true);
                SVNExtendedMergeEditor.checkParentEntry(path, parentEntry);
                targetRevision = parentEntry.getRevision();
            } else {
                SVNDirectoryInfoExt parentDirInfo = (SVNDirectoryInfoExt)this.getDirectories().peek();
                targetRevision = parentDirInfo.myRevision;
            }
        } else {
            targetRevision = entry.getRevision();
            if (entry.isScheduledForAddition() || entry.isScheduledForReplacement()) {
                if (this.getDirectories().empty()) {
                    SVNEntry parentEntry = access.getEntry(path.getParentFile(), true);
                    SVNExtendedMergeEditor.checkParentEntry(path, parentEntry);
                    targetRevision = parentEntry.getRevision();
                } else {
                    SVNDirectoryInfoExt parentDirInfo = (SVNDirectoryInfoExt)this.getDirectories().peek();
                    targetRevision = parentDirInfo.myRevision;
                }
            }
        }
        return targetRevision;
    }

    private static void checkParentEntry(File path, SVNEntry parentEntry) throws SVNException {
        SVNErrorMessage error;
        if (parentEntry == null) {
            error = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Parent directory of ''{0}'' is unexpectedly unversioned", path);
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        if (parentEntry.isScheduledForAddition() || parentEntry.isScheduledForReplacement()) {
            error = SVNErrorMessage.create(SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, "Parent directory of ''{0}'' unexpectedly scheduled for ''{1}''", new Object[]{path, parentEntry.getSchedule()});
            SVNErrorManager.error(error, SVNLogType.WC);
        }
    }

    public void closeDir() throws SVNException {
        super.closeDir();
        if (!this.getDirectories().empty()) {
            this.getDirectories().pop();
        }
    }

    private SVNFileInfoExt getFileInfo(String path, long revision, SVNEditorAction action, SVNNodeKind kind) throws SVNException {
        if (this.myCurrentFile == null) {
            this.myCurrentFile = this.createFileInfo(path, action, kind);
            if (action == SVNEditorAction.ADD) {
                this.myCurrentFile.myBaseProperties = new SVNProperties();
                this.myCurrentFile.myBaseFile = SVNFileUtil.createUniqueFile(this.getTempDirectory(), ".diff", ".tmp", false);
            } else if (action == SVNEditorAction.MODIFY) {
                this.myCurrentFile.loadFromRepository(revision);
            }
        }
        return (SVNFileInfoExt)this.myCurrentFile;
    }

    public void changeFileProperty(String commitPath, String name, SVNPropertyValue value) throws SVNException {
        if (this.myCurrentFile == null) {
            return;
        }
        this.myCurrentFile.myPropertyDiff.put(name, value);
    }

    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        if (this.myCurrentFile == null) {
            return;
        }
        if (this.myCurrentFile instanceof SVNFileInfoExt) {
            SVNFileInfoExt fileInfo = (SVNFileInfoExt)this.myCurrentFile;
            fileInfo.applyTextDelta(commitPath, baseChecksum);
        } else {
            super.applyTextDelta(commitPath, baseChecksum);
        }
    }

    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        if (this.myCurrentFile == null) {
            return SVNFileUtil.DUMMY_OUT;
        }
        if (this.myCurrentFile instanceof SVNFileInfoExt) {
            SVNFileInfoExt fileInfo = (SVNFileInfoExt)this.myCurrentFile;
            return fileInfo.textDeltaChunk(commitPath, diffWindow);
        }
        return super.textDeltaChunk(commitPath, diffWindow);
    }

    public void textDeltaEnd(String commitPath) throws SVNException {
        if (this.myCurrentFile == null) {
            return;
        }
        if (this.myCurrentFile instanceof SVNFileInfoExt) {
            SVNFileInfoExt fileInfo = (SVNFileInfoExt)this.myCurrentFile;
            fileInfo.textDeltaEnd(commitPath);
        } else {
            super.textDeltaEnd(commitPath);
        }
    }

    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        if (this.myCurrentFile == null) {
            return;
        }
        if (this.myCurrentFile instanceof SVNFileInfoExt) {
            SVNFileInfoExt fileInfo = (SVNFileInfoExt)this.myCurrentFile;
            fileInfo.close();
        } else {
            super.closeFile(commitPath, textChecksum);
        }
        this.myCurrentFile = null;
    }

    private SVNURL getSourceURL(String path) throws SVNException {
        return this.mySourceURL.appendPath(path, false);
    }

    private SVNURL getTargetURL(String path) throws SVNException {
        return this.myTargetURL.appendPath(path, false);
    }

    private File getFile(String path) {
        return new File(this.myTarget, path);
    }

    private String getPath(SVNURL target) {
        return SVNPathUtil.getRelativePath(this.myTargetURL.getPath(), target.getPath());
    }

    private String getPath(File path) {
        return SVNPathUtil.getRelativePath(this.myTarget.getAbsolutePath(), path.getAbsolutePath());
    }

    protected SVNFileInfoExt createFileInfo(String path, SVNEditorAction action, SVNNodeKind kind) {
        return new SVNFileInfoExt(path, action == SVNEditorAction.ADD, action, kind);
    }

    protected class MergeTarget
    implements ISVNDeltaConsumer {
        private SVNDeltaProcessor myTargetProcessor;
        private String myPath;
        private File myWCFile;
        private File myFile;
        private SVNCopySource myCopySource;

        public MergeTarget(String path, SVNDeltaProcessor targetProcessor, SVNCopySource copySource) {
            this.myPath = path;
            this.myWCFile = SVNExtendedMergeEditor.this.myTarget == null ? null : new File(SVNExtendedMergeEditor.this.myTarget, path);
            this.myTargetProcessor = targetProcessor;
            this.myCopySource = copySource;
        }

        private SVNDeltaProcessor getDeltaProcessor() {
            return this.myTargetProcessor;
        }

        public void applyTextDelta(String path, String baseChecksum) throws SVNException {
            SVNAdminArea dir;
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "ext merge: apply delta " + this.myPath);
            try {
                dir = SVNExtendedMergeEditor.this.retrieveParent(this.myWCFile, true);
            }
            catch (SVNException e) {
                dir = null;
            }
            this.myFile = SVNExtendedMergeEditor.this.createTempFile(dir, SVNPathUtil.tail(this.myPath));
            this.getDeltaProcessor().applyTextDelta(SVNExtendedMergeEditor.this.myCurrentFile.myBaseFile, this.myFile, false);
        }

        public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "ext merge: delta chunk " + this.myPath);
            return this.getDeltaProcessor().textDeltaChunk(diffWindow);
        }

        public void textDeltaEnd(String path) throws SVNException {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "ext merge: delta end " + this.myPath);
            this.getDeltaProcessor().textDeltaEnd();
        }

        protected void close() throws SVNException {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "ext merge: close " + this.myPath);
            SVNExtendedMergeEditor.this.closeFile(this.myPath, SVNExtendedMergeEditor.this.myCurrentFile.myIsAdded, this.myWCFile, this.myFile, SVNExtendedMergeEditor.this.myCurrentFile.myPropertyDiff, SVNExtendedMergeEditor.this.myCurrentFile.myBaseProperties, SVNExtendedMergeEditor.this.myCurrentFile.myBaseFile, null);
            if (this.myCopySource == null) {
                return;
            }
            SVNEntry targetEntry = SVNExtendedMergeEditor.this.myWCAccess.getEntry(this.myWCFile, false);
            if (targetEntry != null) {
                SVNURL copyFromLocation = targetEntry.getCopyFromSVNURL();
                long copyFromRevision = targetEntry.getCopyFromRevision();
                SVNURL sourceURL = this.myCopySource.getURL();
                long sourceRevision = this.myCopySource.getRevision().getNumber();
                if (copyFromLocation == null || !copyFromLocation.equals(sourceURL) || copyFromRevision != sourceRevision) {
                    SVNExtendedMergeEditor.this.getMergeDriver().copy(this.myCopySource, this.myWCFile, true);
                }
            }
        }

        protected void delete() throws SVNException {
            SVNStatusType type = SVNStatusType.INAPPLICABLE;
            SVNEventAction action = SVNEventAction.SKIP;
            SVNEventAction expectedAction = SVNEventAction.UPDATE_DELETE;
            SVNFileInfoExt fileInfo = (SVNFileInfoExt)SVNExtendedMergeEditor.this.myCurrentFile;
            SVNNodeKind nodeKind = fileInfo.getNodeKind();
            SVNAdminArea dir = SVNExtendedMergeEditor.this.retrieveParent(this.myWCFile, true);
            if (SVNExtendedMergeEditor.this.myAdminArea == null || dir != null) {
                if (nodeKind == SVNNodeKind.FILE) {
                    fileInfo.loadFromRepository(SVNExtendedMergeEditor.this.myRevision1);
                    String baseType = fileInfo.myBaseProperties.getStringValue("svn:mime-type");
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "merge ext: del " + this.myPath);
                    type = SVNExtendedMergeEditor.this.getDiffCallback().fileDeleted(this.myPath, fileInfo.myBaseFile, null, baseType, null, fileInfo.myBaseProperties, null);
                } else if (nodeKind == SVNNodeKind.DIR) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "merge ext: attempt to delete directory skipped");
                }
                if (type != SVNStatusType.MISSING && type != SVNStatusType.OBSTRUCTED) {
                    action = SVNEventAction.UPDATE_DELETE;
                    if (SVNExtendedMergeEditor.this.myIsDryRun) {
                        SVNExtendedMergeEditor.this.getDiffCallback().addDeletedPath(this.myPath);
                    }
                }
            }
            SVNExtendedMergeEditor.this.addDeletedPath(this.myPath, nodeKind, type, action, expectedAction);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[merge target: path = ");
            buffer.append(this.myPath);
            buffer.append("; wc file = ");
            buffer.append(this.myWCFile);
            buffer.append("; file = ");
            buffer.append(this.myFile);
            buffer.append("; base file = ");
            buffer.append(SVNExtendedMergeEditor.this.myCurrentFile.myBaseFile);
            buffer.append("; copyFromURL = ");
            buffer.append(this.myCopySource == null ? null : this.myCopySource.getURL());
            buffer.append("; copyFromRevision = ");
            buffer.append(this.myCopySource == null ? "unknown" : String.valueOf(this.myCopySource.getRevision()));
            buffer.append("]");
            return buffer.toString();
        }
    }

    protected class SVNFileInfoExt
    extends SVNRemoteDiffEditor.SVNFileInfo
    implements ISVNDeltaConsumer {
        protected SVNEditorAction myAction;
        protected Collection myTargets;
        protected SVNNodeKind myKind;
        protected boolean myIsLoaded;

        protected SVNFileInfoExt(String path, boolean added, SVNEditorAction action, SVNNodeKind nodeKind) {
            super(path, added);
            this.myAction = action;
            this.myKind = nodeKind;
        }

        public void loadFromRepository(long revision) throws SVNException {
            if (!this.myIsLoaded) {
                super.loadFromRepository(revision);
                this.myIsLoaded = true;
            }
        }

        protected SVNNodeKind getNodeKind() throws SVNException {
            if (this.myKind == null) {
                this.myKind = SVNExtendedMergeEditor.this.myRepos.checkPath(this.myRepositoryPath, SVNExtendedMergeEditor.this.myRevision1);
            }
            return this.myKind;
        }

        protected Collection getTargets() {
            if (this.myTargets == null) {
                this.myTargets = new ArrayList();
            }
            return this.myTargets;
        }

        protected void addTarget(String targetPath, SVNCopySource copySource) {
            SVNDeltaProcessor processor = this.myAction == SVNEditorAction.DELETE ? null : (this.getTargets().size() == 0 ? SVNExtendedMergeEditor.this.myDeltaProcessor : new SVNDeltaProcessor());
            MergeTarget target = new MergeTarget(targetPath, processor, copySource);
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.WC, "ext merge: " + target.toString());
            this.getTargets().add(target);
        }

        public void applyTextDelta(String path, String baseChecksum) throws SVNException {
            if (this.myTargets == null || this.myTargets.isEmpty()) {
                return;
            }
            Iterator iterator = this.getTargets().iterator();
            while (iterator.hasNext()) {
                MergeTarget target = (MergeTarget)iterator.next();
                target.applyTextDelta(path, baseChecksum);
            }
        }

        public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
            if (this.myTargets == null || this.myTargets.isEmpty()) {
                return SVNFileUtil.DUMMY_OUT;
            }
            Iterator iterator = this.getTargets().iterator();
            while (iterator.hasNext()) {
                MergeTarget target = (MergeTarget)iterator.next();
                target.textDeltaChunk(path, diffWindow);
            }
            return SVNFileUtil.DUMMY_OUT;
        }

        public void textDeltaEnd(String path) throws SVNException {
            if (this.myTargets == null || this.myTargets.isEmpty()) {
                return;
            }
            Iterator iterator = this.getTargets().iterator();
            while (iterator.hasNext()) {
                MergeTarget target = (MergeTarget)iterator.next();
                target.textDeltaEnd(path);
            }
        }

        protected void close() throws SVNException {
            if (this.myTargets == null || this.myTargets.isEmpty()) {
                return;
            }
            Iterator iterator = this.getTargets().iterator();
            while (iterator.hasNext()) {
                MergeTarget target = (MergeTarget)iterator.next();
                target.close();
            }
        }

        protected void delete() throws SVNException {
            if (this.myTargets == null || this.myTargets.isEmpty()) {
                return;
            }
            Iterator iterator = this.getTargets().iterator();
            while (iterator.hasNext()) {
                MergeTarget target = (MergeTarget)iterator.next();
                target.delete();
            }
        }
    }

    protected class SVNDirectoryInfoExt {
        protected long myRevision;
        protected boolean myAdded;
        protected boolean myRemotelyAdded;
        protected boolean mySkipped;

        public SVNDirectoryInfoExt(long revision) {
            this.myRevision = revision;
        }
    }
}

