/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.verifier.PassVerifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.VerifierConstraintViolatedException;
import org.apache.bcel.verifier.structurals.ControlFlowGraph;
import org.apache.bcel.verifier.structurals.ExceptionHandler;
import org.apache.bcel.verifier.structurals.ExecutionVisitor;
import org.apache.bcel.verifier.structurals.Frame;
import org.apache.bcel.verifier.structurals.InstConstraintVisitor;
import org.apache.bcel.verifier.structurals.InstructionContext;
import org.apache.bcel.verifier.structurals.LocalVariables;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.apache.bcel.verifier.structurals.UninitializedObjectType;

public final class Pass3bVerifier
extends PassVerifier {
    private static final boolean DEBUG = true;
    private Verifier myOwner;
    private int method_no;

    public Pass3bVerifier(Verifier verifier, int n) {
        this.myOwner = verifier;
        this.method_no = n;
    }

    private void circulationPump(ControlFlowGraph controlFlowGraph, InstructionContext instructionContext, Frame frame, InstConstraintVisitor instConstraintVisitor, ExecutionVisitor executionVisitor) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Random random = new Random();
        InstructionContextQueue instructionContextQueue = new InstructionContextQueue();
        instructionContext.execute(frame, new ArrayList(), instConstraintVisitor, executionVisitor);
        instructionContextQueue.add(instructionContext, new ArrayList());
        while (!instructionContextQueue.isEmpty()) {
            Object object6;
            object5 = instructionContextQueue.getIC(0);
            object4 = instructionContextQueue.getEC(0);
            instructionContextQueue.remove(0);
            object3 = (ArrayList)((ArrayList)object4).clone();
            object2 = (ArrayList)((ArrayList)object4).clone();
            ((ArrayList)object2).add(object5);
            if (object5.getInstruction().getInstruction() instanceof RET) {
                object = (RET)object5.getInstruction().getInstruction();
                ReturnaddressType returnaddressType = (ReturnaddressType)object5.getOutFrame((ArrayList)object3).getLocals().get(((RET)object).getIndex());
                object6 = controlFlowGraph.contextOf(returnaddressType.getTarget());
                InstructionContext instructionContext2 = null;
                int n2 = 0;
                for (int i = ((ArrayList)object3).size() - 1; i >= 0; --i) {
                    if (n2 < 0) {
                        throw new AssertionViolatedException("More RET than JSR in execution chain?!");
                    }
                    if (((InstructionContext)((ArrayList)object3).get(i)).getInstruction().getInstruction() instanceof JsrInstruction) {
                        if (n2 == 0) {
                            instructionContext2 = (InstructionContext)((ArrayList)object3).get(i);
                            break;
                        }
                        --n2;
                    }
                    if (!(((InstructionContext)((ArrayList)object3).get(i)).getInstruction().getInstruction() instanceof RET)) continue;
                    ++n2;
                }
                if (instructionContext2 == null) {
                    throw new AssertionViolatedException("RET without a JSR before in ExecutionChain?! EC: '" + object3 + "'.");
                }
                JsrInstruction jsrInstruction = (JsrInstruction)instructionContext2.getInstruction().getInstruction();
                if (object6 != controlFlowGraph.contextOf(jsrInstruction.physicalSuccessor())) {
                    throw new AssertionViolatedException("RET '" + object5.getInstruction() + "' info inconsistent: jump back to '" + object6 + "' or '" + controlFlowGraph.contextOf(jsrInstruction.physicalSuccessor()) + "'?");
                }
                if (object6.execute(object5.getOutFrame((ArrayList)object3), (ArrayList)object2, instConstraintVisitor, executionVisitor)) {
                    instructionContextQueue.add((InstructionContext)object6, (ArrayList)((ArrayList)object2).clone());
                }
            } else {
                object = object5.getSuccessors();
                for (n = 0; n < ((InstructionContext[])object).length; ++n) {
                    object6 = object[n];
                    if (!object6.execute(object5.getOutFrame((ArrayList)object3), (ArrayList)object2, instConstraintVisitor, executionVisitor)) continue;
                    instructionContextQueue.add((InstructionContext)object6, (ArrayList)((ArrayList)object2).clone());
                }
            }
            object = object5.getExceptionHandlers();
            for (n = 0; n < ((Object)object).length; ++n) {
                object6 = controlFlowGraph.contextOf(((ExceptionHandler)object[n]).getHandlerStart());
                if (!object6.execute(new Frame(object5.getOutFrame((ArrayList)object3).getLocals(), new OperandStack(object5.getOutFrame((ArrayList)object3).getStack().maxStack(), ((ExceptionHandler)object[n]).getExceptionType() == null ? Type.THROWABLE : ((ExceptionHandler)object[n]).getExceptionType())), new ArrayList(), instConstraintVisitor, executionVisitor)) continue;
                instructionContextQueue.add((InstructionContext)object6, new ArrayList());
            }
        }
        object5 = instructionContext.getInstruction();
        do {
            if (!(((InstructionHandle)object5).getInstruction() instanceof ReturnInstruction) || controlFlowGraph.isDead((InstructionHandle)object5)) continue;
            object4 = controlFlowGraph.contextOf((InstructionHandle)object5);
            object3 = object4.getOutFrame(new ArrayList());
            object2 = ((Frame)object3).getLocals();
            for (int i = 0; i < ((LocalVariables)object2).maxLocals(); ++i) {
                if (!(((LocalVariables)object2).get(i) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + object4 + "' may leave method with an uninitialized object in the local variables array '" + object2 + "'.");
            }
            object = ((Frame)object3).getStack();
            for (n = 0; n < ((OperandStack)object).size(); ++n) {
                if (!(((OperandStack)object).peek(n) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + object4 + "' may leave method with an uninitialized object on the operand stack '" + object + "'.");
            }
        } while ((object5 = ((InstructionHandle)object5).getNext()) != null);
    }

    public VerificationResult do_verify() {
        JavaClass javaClass;
        if (!this.myOwner.doPass3a(this.method_no).equals(VerificationResult.VR_OK)) {
            return VerificationResult.VR_NOTYET;
        }
        try {
            javaClass = Repository.lookupClass(this.myOwner.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionViolatedException("Missing class: " + classNotFoundException.toString());
        }
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(javaClass.getConstantPool());
        InstConstraintVisitor instConstraintVisitor = new InstConstraintVisitor();
        instConstraintVisitor.setConstantPoolGen(constantPoolGen);
        ExecutionVisitor executionVisitor = new ExecutionVisitor();
        executionVisitor.setConstantPoolGen(constantPoolGen);
        Method[] methodArray = javaClass.getMethods();
        try {
            MethodGen methodGen = new MethodGen(methodArray[this.method_no], this.myOwner.getClassName(), constantPoolGen);
            instConstraintVisitor.setMethodGen(methodGen);
            if (!methodGen.isAbstract() && !methodGen.isNative()) {
                ControlFlowGraph controlFlowGraph = new ControlFlowGraph(methodGen);
                Frame frame = new Frame(methodGen.getMaxLocals(), methodGen.getMaxStack());
                if (!methodGen.isStatic()) {
                    if (methodGen.getName().equals("<init>")) {
                        Frame._this = new UninitializedObjectType(new ObjectType(javaClass.getClassName()));
                        frame.getLocals().set(0, Frame._this);
                    } else {
                        Frame._this = null;
                        frame.getLocals().set(0, new ObjectType(javaClass.getClassName()));
                    }
                }
                Type[] typeArray = methodGen.getArgumentTypes();
                int n = 0;
                for (int i = 0; i < typeArray.length; ++i) {
                    if (typeArray[i] == Type.SHORT || typeArray[i] == Type.BYTE || typeArray[i] == Type.CHAR || typeArray[i] == Type.BOOLEAN) {
                        typeArray[i] = Type.INT;
                    }
                    frame.getLocals().set(n + i + (methodGen.isStatic() ? 0 : 1), typeArray[i]);
                    if (typeArray[i].getSize() != 2) continue;
                    frame.getLocals().set(++n + i + (methodGen.isStatic() ? 0 : 1), Type.UNKNOWN);
                }
                this.circulationPump(controlFlowGraph, controlFlowGraph.contextOf(methodGen.getInstructionList().getStart()), frame, instConstraintVisitor, executionVisitor);
            }
        }
        catch (VerifierConstraintViolatedException verifierConstraintViolatedException) {
            verifierConstraintViolatedException.extendMessage("Constraint violated in method '" + methodArray[this.method_no] + "':\n", "");
            return new VerificationResult(2, verifierConstraintViolatedException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            runtimeException.printStackTrace(printWriter);
            throw new AssertionViolatedException("Some RuntimeException occured while verify()ing class '" + javaClass.getClassName() + "', method '" + methodArray[this.method_no] + "'. Original RuntimeException's stack trace:\n---\n" + stringWriter + "---\n");
        }
        return VerificationResult.VR_OK;
    }

    public int getMethodNo() {
        return this.method_no;
    }

    private static final class InstructionContextQueue {
        private Vector ics = new Vector();
        private Vector ecs = new Vector();

        private InstructionContextQueue() {
        }

        public void add(InstructionContext instructionContext, ArrayList arrayList) {
            this.ics.add(instructionContext);
            this.ecs.add(arrayList);
        }

        public boolean isEmpty() {
            return this.ics.isEmpty();
        }

        public void remove() {
            this.remove(0);
        }

        public void remove(int n) {
            this.ics.remove(n);
            this.ecs.remove(n);
        }

        public InstructionContext getIC(int n) {
            return (InstructionContext)this.ics.get(n);
        }

        public ArrayList getEC(int n) {
            return (ArrayList)this.ecs.get(n);
        }

        public int size() {
            return this.ics.size();
        }
    }
}

