/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.statics;

import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.classfile.StackMap;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.verifier.exc.AssertionViolatedException;

public class StringRepresentation
extends EmptyVisitor
implements Visitor {
    private String tostring;
    private Node n;

    public StringRepresentation(Node node) {
        this.n = node;
        node.accept(this);
    }

    public String toString() {
        if (this.tostring == null) {
            throw new AssertionViolatedException("Please adapt '" + this.getClass() + "' to deal with objects of class '" + this.n.getClass() + "'.");
        }
        return this.tostring;
    }

    private String toString(Node node) {
        String string;
        try {
            string = node.toString();
        }
        catch (RuntimeException runtimeException) {
            String string2 = node.getClass().getName();
            string2 = string2.substring(string2.lastIndexOf(".") + 1);
            string = "<<" + string2 + ">>";
        }
        return string;
    }

    public void visitCode(Code code) {
        this.tostring = "<CODE>";
    }

    public void visitCodeException(CodeException codeException) {
        this.tostring = this.toString(codeException);
    }

    public void visitConstantClass(ConstantClass constantClass) {
        this.tostring = this.toString(constantClass);
    }

    public void visitConstantDouble(ConstantDouble constantDouble) {
        this.tostring = this.toString(constantDouble);
    }

    public void visitConstantFieldref(ConstantFieldref constantFieldref) {
        this.tostring = this.toString(constantFieldref);
    }

    public void visitConstantFloat(ConstantFloat constantFloat) {
        this.tostring = this.toString(constantFloat);
    }

    public void visitConstantInteger(ConstantInteger constantInteger) {
        this.tostring = this.toString(constantInteger);
    }

    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constantInterfaceMethodref) {
        this.tostring = this.toString(constantInterfaceMethodref);
    }

    public void visitConstantLong(ConstantLong constantLong) {
        this.tostring = this.toString(constantLong);
    }

    public void visitConstantMethodref(ConstantMethodref constantMethodref) {
        this.tostring = this.toString(constantMethodref);
    }

    public void visitConstantNameAndType(ConstantNameAndType constantNameAndType) {
        this.tostring = this.toString(constantNameAndType);
    }

    public void visitConstantPool(ConstantPool constantPool) {
        this.tostring = this.toString(constantPool);
    }

    public void visitConstantString(ConstantString constantString) {
        this.tostring = this.toString(constantString);
    }

    public void visitConstantUtf8(ConstantUtf8 constantUtf8) {
        this.tostring = this.toString(constantUtf8);
    }

    public void visitConstantValue(ConstantValue constantValue) {
        this.tostring = this.toString(constantValue);
    }

    public void visitDeprecated(Deprecated deprecated) {
        this.tostring = this.toString(deprecated);
    }

    public void visitExceptionTable(ExceptionTable exceptionTable) {
        this.tostring = this.toString(exceptionTable);
    }

    public void visitField(Field field) {
        this.tostring = this.toString(field);
    }

    public void visitInnerClass(InnerClass innerClass) {
        this.tostring = this.toString(innerClass);
    }

    public void visitInnerClasses(InnerClasses innerClasses) {
        this.tostring = this.toString(innerClasses);
    }

    public void visitJavaClass(JavaClass javaClass) {
        this.tostring = this.toString(javaClass);
    }

    public void visitLineNumber(LineNumber lineNumber) {
        this.tostring = this.toString(lineNumber);
    }

    public void visitLineNumberTable(LineNumberTable lineNumberTable) {
        this.tostring = "<LineNumberTable: " + this.toString(lineNumberTable) + ">";
    }

    public void visitLocalVariable(LocalVariable localVariable) {
        this.tostring = this.toString(localVariable);
    }

    public void visitLocalVariableTable(LocalVariableTable localVariableTable) {
        this.tostring = "<LocalVariableTable: " + this.toString(localVariableTable) + ">";
    }

    public void visitMethod(Method method) {
        this.tostring = this.toString(method);
    }

    public void visitSignature(Signature signature) {
        this.tostring = this.toString(signature);
    }

    public void visitSourceFile(SourceFile sourceFile) {
        this.tostring = this.toString(sourceFile);
    }

    public void visitStackMap(StackMap stackMap) {
        this.tostring = this.toString(stackMap);
    }

    public void visitSynthetic(Synthetic synthetic) {
        this.tostring = this.toString(synthetic);
    }

    public void visitUnknown(Unknown unknown) {
        this.tostring = this.toString(unknown);
    }
}

