/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.Visitor;

public final class InnerClasses
extends Attribute {
    private InnerClass[] inner_classes;
    private int number_of_classes;

    public InnerClasses(InnerClasses innerClasses) {
        this(innerClasses.getNameIndex(), innerClasses.getLength(), innerClasses.getInnerClasses(), innerClasses.getConstantPool());
    }

    public InnerClasses(int n, int n2, InnerClass[] innerClassArray, ConstantPool constantPool) {
        super((byte)6, n, n2, constantPool);
        this.setInnerClasses(innerClassArray);
    }

    InnerClasses(int n, int n2, DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this(n, n2, (InnerClass[])null, constantPool);
        this.number_of_classes = dataInputStream.readUnsignedShort();
        this.inner_classes = new InnerClass[this.number_of_classes];
        for (int i = 0; i < this.number_of_classes; ++i) {
            this.inner_classes[i] = new InnerClass(dataInputStream);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitInnerClasses(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.number_of_classes);
        for (int i = 0; i < this.number_of_classes; ++i) {
            this.inner_classes[i].dump(dataOutputStream);
        }
    }

    public final InnerClass[] getInnerClasses() {
        return this.inner_classes;
    }

    public final void setInnerClasses(InnerClass[] innerClassArray) {
        this.inner_classes = innerClassArray;
        this.number_of_classes = innerClassArray == null ? 0 : innerClassArray.length;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.number_of_classes; ++i) {
            stringBuffer.append(this.inner_classes[i].toString(this.constant_pool) + "\n");
        }
        return stringBuffer.toString();
    }

    public Attribute copy(ConstantPool constantPool) {
        InnerClasses innerClasses = (InnerClasses)this.clone();
        innerClasses.inner_classes = new InnerClass[this.number_of_classes];
        for (int i = 0; i < this.number_of_classes; ++i) {
            innerClasses.inner_classes[i] = this.inner_classes[i].copy();
        }
        innerClasses.constant_pool = constantPool;
        return innerClasses;
    }
}

