/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.tests;

import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Namespace;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

public class XOMTestCase
extends TestCase {
    public XOMTestCase(String name) {
        super(name);
    }

    public static void assertEquals(Text expected, Text actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Text expected, Text actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals(message, expected.getValue(), actual.getValue());
    }

    private static void nullCheck(String message, Node expected, Node actual) {
        if (expected == null) {
            throw new ComparisonFailure(message, null, actual.toXML());
        }
        if (actual == null) {
            throw new ComparisonFailure(message, expected.toXML(), null);
        }
    }

    public static void assertEquals(Attribute expected, Attribute actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Attribute expected, Attribute actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        String value1 = expected.getValue();
        String value2 = actual.getValue();
        if ("xml:base".equals(expected.getQualifiedName())) {
            if (value1.equals(value2)) {
                return;
            }
            if (value1.startsWith("../")) {
                XOMTestCase.assertTrue(message, value2.endsWith(value1.substring(2)));
            } else {
                XOMTestCase.assertTrue(message, value1.endsWith('/' + value2) || value2.endsWith('/' + value1));
            }
        } else {
            XOMTestCase.assertEquals(message, value1, value2);
            XOMTestCase.assertEquals(message, expected.getLocalName(), actual.getLocalName());
            XOMTestCase.assertEquals(message, expected.getQualifiedName(), actual.getQualifiedName());
            XOMTestCase.assertEquals(message, expected.getNamespaceURI(), actual.getNamespaceURI());
        }
    }

    public static void assertEquals(DocType expected, DocType actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, DocType expected, DocType actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals(message, expected.getPublicID(), actual.getPublicID());
        XOMTestCase.assertEquals(message, expected.getSystemID(), actual.getSystemID());
        XOMTestCase.assertEquals(message, expected.getRootElementName(), actual.getRootElementName());
    }

    public static void assertEquals(Element expected, Element actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Element expected, Element actual) {
        String uri1;
        String prefix1;
        int i;
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals(message, expected.getLocalName(), actual.getLocalName());
        XOMTestCase.assertEquals(message, expected.getNamespacePrefix(), actual.getNamespacePrefix());
        XOMTestCase.assertEquals(message, expected.getNamespaceURI(), actual.getNamespaceURI());
        XOMTestCase.assertEquals(message, expected.getAttributeCount(), actual.getAttributeCount());
        for (i = 0; i < expected.getAttributeCount(); ++i) {
            Attribute att1 = expected.getAttribute(i);
            Attribute att2 = actual.getAttribute(att1.getLocalName(), att1.getNamespaceURI());
            XOMTestCase.assertNotNull(message, att2);
            XOMTestCase.assertEquals(message, att1, att2);
        }
        for (i = 0; i < expected.getNamespaceDeclarationCount(); ++i) {
            prefix1 = expected.getNamespacePrefix(i);
            uri1 = expected.getNamespaceURI(prefix1);
            XOMTestCase.assertNotNull(message, actual.getNamespaceURI(prefix1));
            XOMTestCase.assertEquals(message, uri1, actual.getNamespaceURI(prefix1));
        }
        for (i = 0; i < actual.getNamespaceDeclarationCount(); ++i) {
            prefix1 = actual.getNamespacePrefix(i);
            uri1 = actual.getNamespaceURI(prefix1);
            XOMTestCase.assertNotNull(message, expected.getNamespaceURI(prefix1));
            XOMTestCase.assertEquals(message, uri1, expected.getNamespaceURI(prefix1));
        }
        XOMTestCase.compareChildren(message, expected, actual);
    }

    private static boolean hasAdjacentTextNodes(Element element) {
        boolean previousWasText = false;
        int count = element.getChildCount();
        for (int i = 0; i < count; ++i) {
            Node child = element.getChild(i);
            if (child instanceof Text) {
                if (previousWasText) {
                    return true;
                }
                if ("".equals(child.getValue())) {
                    return true;
                }
                previousWasText = true;
                continue;
            }
            previousWasText = false;
        }
        return false;
    }

    private static void compareChildren(String message, Element expected, Element actual) {
        Element expectedCopy = expected;
        Element actualCopy = actual;
        if (XOMTestCase.hasAdjacentTextNodes(expected)) {
            expectedCopy = XOMTestCase.combineTextNodes(expected);
        }
        if (XOMTestCase.hasAdjacentTextNodes(actual)) {
            actualCopy = XOMTestCase.combineTextNodes(actual);
        }
        int count = expectedCopy.getChildCount();
        XOMTestCase.assertEquals(message, count, actualCopy.getChildCount());
        int nonTextNodes = count;
        for (int i = 0; i < count; ++i) {
            Node child1 = expectedCopy.getChild(i);
            if (!(child1 instanceof Text)) continue;
            --nonTextNodes;
            Node child2 = actualCopy.getChild(i);
            XOMTestCase.assertEquals(message, child1, child2);
        }
        int a = 0;
        int e = expected.getChildCount();
        for (int i = 0; i < e; ++i) {
            Node expectedChild = expected.getChild(i);
            if (expectedChild instanceof Text) continue;
            Node actualChild = actual.getChild(a);
            ++a;
            while (actualChild instanceof Text) {
                actualChild = actual.getChild(a);
                ++a;
            }
            XOMTestCase.assertEquals(message, expectedChild, actualChild);
        }
    }

    private static Element combineTextNodes(Element element) {
        Element stub = new Element("a");
        Comment stubc = new Comment("c");
        StringBuffer sb = new StringBuffer();
        int count = element.getChildCount();
        for (int i = 0; i < count; ++i) {
            Node child = element.getChild(i);
            if (child instanceof Text) {
                if ("".equals(child.getValue())) continue;
                sb.setLength(0);
                do {
                    sb.append(child.getValue());
                } while (++i != count && (child = element.getChild(i)) instanceof Text);
                --i;
                stub.appendChild(sb.toString());
                continue;
            }
            stub.appendChild(stubc.copy());
        }
        return stub;
    }

    public static void assertEquals(Document expected, Document actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Document expected, Document actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals(message, expected.getChildCount(), actual.getChildCount());
        for (int i = 0; i < actual.getChildCount(); ++i) {
            Node child1 = expected.getChild(i);
            Node child2 = actual.getChild(i);
            XOMTestCase.assertEquals(message, child1, child2);
        }
    }

    public static void assertEquals(Comment expected, Comment actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Comment expected, Comment actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals(message, expected.getValue(), actual.getValue());
    }

    public static void assertEquals(ProcessingInstruction expected, ProcessingInstruction actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, ProcessingInstruction expected, ProcessingInstruction actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals(message, expected.getValue(), actual.getValue());
        XOMTestCase.assertEquals(message, expected.getTarget(), actual.getTarget());
    }

    public static void assertEquals(String message, Namespace expected, Namespace actual) {
        if (actual == expected) {
            return;
        }
        XOMTestCase.nullCheck(message, expected, actual);
        XOMTestCase.assertEquals(message, expected.getValue(), actual.getValue());
        XOMTestCase.assertEquals(message, expected.getPrefix(), actual.getPrefix());
    }

    public static void assertEquals(Node expected, Node actual) {
        XOMTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, Node expected, Node actual) {
        block11: {
            if (actual == expected) {
                return;
            }
            XOMTestCase.nullCheck(message, expected, actual);
            try {
                if (expected instanceof Document) {
                    XOMTestCase.assertEquals(message, (Document)expected, (Document)actual);
                    break block11;
                }
                if (expected instanceof Element) {
                    XOMTestCase.assertEquals(message, (Element)expected, (Element)actual);
                    break block11;
                }
                if (expected instanceof Text) {
                    XOMTestCase.assertEquals(message, (Text)expected, (Text)actual);
                    break block11;
                }
                if (expected instanceof DocType) {
                    XOMTestCase.assertEquals(message, (DocType)expected, (DocType)actual);
                    break block11;
                }
                if (expected instanceof Comment) {
                    XOMTestCase.assertEquals(message, (Comment)expected, (Comment)actual);
                    break block11;
                }
                if (expected instanceof ProcessingInstruction) {
                    XOMTestCase.assertEquals(message, (ProcessingInstruction)expected, (ProcessingInstruction)actual);
                    break block11;
                }
                if (expected instanceof Attribute) {
                    XOMTestCase.assertEquals(message, (Attribute)expected, (Attribute)actual);
                    break block11;
                }
                if (expected instanceof Namespace) {
                    XOMTestCase.assertEquals(message, (Namespace)expected, (Namespace)actual);
                    break block11;
                }
                throw new IllegalArgumentException("Unexpected node type " + expected.getClass().getName());
            }
            catch (ClassCastException ex) {
                throw new ComparisonFailure(message + "; Mismatched node types: " + expected.getClass().getName() + " != " + actual.getClass().getName(), expected.toXML(), actual.toXML());
            }
        }
    }
}

