/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.util.CompatibilityHints;

public class CalScale
extends Property {
    private static final long serialVersionUID = 7446184786984981423L;
    public static final CalScale GREGORIAN = new ImmutableCalScale("GREGORIAN");
    private String value;

    public CalScale() {
        super("CALSCALE");
    }

    public CalScale(String aValue) {
        super("CALSCALE");
        this.value = aValue;
    }

    public CalScale(ParameterList aList, String aValue) {
        super("CALSCALE", aList);
        this.value = aValue;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public final String getValue() {
        return this.value;
    }

    public final void validate() throws ValidationException {
        if (CompatibilityHints.isHintEnabled("ical4j.validation.relaxed") ? !GREGORIAN.getValue().equalsIgnoreCase(this.value) : !GREGORIAN.getValue().equals(this.value)) {
            throw new ValidationException("Invalid value [" + this.value + "]");
        }
    }

    private static final class ImmutableCalScale
    extends CalScale {
        private static final long serialVersionUID = 1750949550694413878L;

        private ImmutableCalScale(String value) {
            super(new ParameterList(true), value);
        }

        public void setValue(String aValue) {
            throw new UnsupportedOperationException("Cannot modify constant instances");
        }
    }
}

