/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Iterator;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.Observance;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzUrl;
import net.fortuna.ical4j.util.PropertyValidator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class VTimeZone
extends CalendarComponent {
    private static final long serialVersionUID = 5629679741050917815L;
    private ComponentList observances;

    public VTimeZone() {
        super("VTIMEZONE");
        this.observances = new ComponentList();
    }

    public VTimeZone(PropertyList properties) {
        super("VTIMEZONE", properties);
        this.observances = new ComponentList();
    }

    public VTimeZone(ComponentList observances) {
        super("VTIMEZONE");
        this.observances = observances;
    }

    public VTimeZone(PropertyList properties, ComponentList observances) {
        super("VTIMEZONE", properties);
        this.observances = observances;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append("BEGIN");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        b.append(this.getProperties());
        b.append(this.observances);
        b.append("END");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        return b.toString();
    }

    public final void validate(boolean recurse) throws ValidationException {
        PropertyValidator.getInstance().assertOne("TZID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TZURL", this.getProperties());
        if (this.getObservances().getComponent("STANDARD") == null && this.getObservances().getComponent("DAYLIGHT") == null) {
            throw new ValidationException("Sub-components [STANDARD,DAYLIGHT] must be specified at least once");
        }
        Iterator i = this.getObservances().iterator();
        while (i.hasNext()) {
            ((Component)i.next()).validate(recurse);
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    public void validatePublish() throws ValidationException {
        this.validateITIP();
    }

    public void validateAdd() throws ValidationException {
        this.validateITIP();
    }

    public void validateCancel() throws ValidationException {
        this.validateITIP();
    }

    public void validateCounter() throws ValidationException {
        this.validateITIP();
    }

    public void validateDeclineCounter() throws ValidationException {
        this.validateITIP();
    }

    public void validateRefresh() throws ValidationException {
        this.validateITIP();
    }

    public void validateReply() throws ValidationException {
        this.validateITIP();
    }

    public void validateRequest() throws ValidationException {
        this.validateITIP();
    }

    private void validateITIP() throws ValidationException {
        Iterator i = this.getObservances().iterator();
        while (i.hasNext()) {
            Observance observance = (Observance)i.next();
            PropertyValidator.getInstance().assertOne("DTSTART", observance.getProperties());
            PropertyValidator.getInstance().assertOne("TZOFFSETFROM", observance.getProperties());
            PropertyValidator.getInstance().assertOne("TZOFFSETTO", observance.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", observance.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("TZNAME", observance.getProperties());
        }
    }

    public final ComponentList getObservances() {
        return this.observances;
    }

    public final Observance getApplicableObservance(Date date) {
        Observance latestObservance = null;
        Date latestOnset = null;
        Iterator i = this.getObservances().iterator();
        while (i.hasNext()) {
            Observance observance = (Observance)i.next();
            Date onset = observance.getLatestOnset(date);
            if (latestOnset != null && (onset == null || !onset.after(latestOnset))) continue;
            latestOnset = onset;
            latestObservance = observance;
        }
        return latestObservance;
    }

    public final TzId getTimeZoneId() {
        return (TzId)this.getProperty("TZID");
    }

    public final LastModified getLastModified() {
        return (LastModified)this.getProperty("LAST-MODIFIED");
    }

    public final TzUrl getTimeZoneUrl() {
        return (TzUrl)this.getProperty("TZURL");
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof VTimeZone) {
            return super.equals(arg0) && ObjectUtils.equals(this.observances, ((VTimeZone)arg0).getObservances());
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getName()).append(this.getProperties()).append(this.getObservances()).toHashCode();
    }

    public Component copy() throws ParseException, IOException, URISyntaxException {
        VTimeZone copy = (VTimeZone)super.copy();
        copy.observances = new ComponentList(this.observances);
        return copy;
    }
}

