/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.net.URISyntaxException;
import net.fortuna.ical4j.model.Content;
import net.fortuna.ical4j.model.ParameterFactoryImpl;
import net.fortuna.ical4j.util.Strings;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class Parameter
extends Content {
    private static final long serialVersionUID = -2058497904769713528L;
    public static final String ABBREV = "ABBREV";
    public static final String ALTREP = "ALTREP";
    public static final String CN = "CN";
    public static final String CUTYPE = "CUTYPE";
    public static final String DELEGATED_FROM = "DELEGATED-FROM";
    public static final String DELEGATED_TO = "DELEGATED-TO";
    public static final String DIR = "DIR";
    public static final String ENCODING = "ENCODING";
    public static final String FMTTYPE = "FMTTYPE";
    public static final String FBTYPE = "FBTYPE";
    public static final String LANGUAGE = "LANGUAGE";
    public static final String MEMBER = "MEMBER";
    public static final String PARTSTAT = "PARTSTAT";
    public static final String RANGE = "RANGE";
    public static final String RELATED = "RELATED";
    public static final String RELTYPE = "RELTYPE";
    public static final String ROLE = "ROLE";
    public static final String RSVP = "RSVP";
    public static final String SENT_BY = "SENT-BY";
    public static final String TYPE = "TYPE";
    public static final String TZID = "TZID";
    public static final String VALUE = "VALUE";
    public static final String VVENUE = "VVENUE";
    public static final String EXPERIMENTAL_PREFIX = "X-";
    private String name;

    public Parameter(String aName) {
        this.name = aName;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getName());
        b.append('=');
        if (this.isQuotable()) {
            b.append(Strings.quote(Strings.valueOf(this.getValue())));
        } else {
            b.append(Strings.valueOf(this.getValue()));
        }
        return b.toString();
    }

    private boolean isQuotable() {
        return Strings.PARAM_QUOTE_PATTERN.matcher(Strings.valueOf(this.getValue())).find();
    }

    public final String getName() {
        return this.name;
    }

    public abstract String getValue();

    public final boolean equals(Object arg0) {
        if (arg0 instanceof Parameter) {
            Parameter p = (Parameter)arg0;
            return new EqualsBuilder().append(this.getName(), p.getName()).append(this.getValue(), p.getValue()).isEquals();
        }
        return super.equals(arg0);
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.getName().toUpperCase()).append(this.getValue()).toHashCode();
    }

    public final Parameter copy() throws URISyntaxException {
        return ParameterFactoryImpl.getInstance().createParameter(this.getName(), this.getValue());
    }
}

