/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Iterator;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.ComponentValidator;
import net.fortuna.ical4j.util.PropertyValidator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Calendar
implements Serializable {
    private static final long serialVersionUID = -1654118204678581940L;
    public static final String BEGIN = "BEGIN";
    public static final String VCALENDAR = "VCALENDAR";
    public static final String END = "END";
    private PropertyList properties;
    private ComponentList components;

    public Calendar() {
        this(new PropertyList(), new ComponentList());
    }

    public Calendar(ComponentList components) {
        this(new PropertyList(), components);
    }

    public Calendar(PropertyList p, ComponentList c) {
        this.properties = p;
        this.components = c;
    }

    public Calendar(Calendar c) throws ParseException, IOException, URISyntaxException {
        this(new PropertyList(c.getProperties()), new ComponentList(c.getComponents()));
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(BEGIN);
        buffer.append(':');
        buffer.append(VCALENDAR);
        buffer.append("\r\n");
        buffer.append(this.getProperties());
        buffer.append(this.getComponents());
        buffer.append(END);
        buffer.append(':');
        buffer.append(VCALENDAR);
        buffer.append("\r\n");
        return buffer.toString();
    }

    public final ComponentList getComponents() {
        return this.components;
    }

    public final ComponentList getComponents(String name) {
        return this.getComponents().getComponents(name);
    }

    public final Component getComponent(String name) {
        return this.getComponents().getComponent(name);
    }

    public final PropertyList getProperties() {
        return this.properties;
    }

    public final PropertyList getProperties(String name) {
        return this.getProperties().getProperties(name);
    }

    public final Property getProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    public final void validate() throws ValidationException {
        this.validate(true);
    }

    public void validate(boolean recurse) throws ValidationException {
        Component component;
        PropertyValidator.getInstance().assertOne("PRODID", this.properties);
        PropertyValidator.getInstance().assertOne("VERSION", this.properties);
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed") && !Version.VERSION_2_0.equals(this.getProperty("VERSION"))) {
            throw new ValidationException("Unsupported Version: " + this.getProperty("VERSION").getValue());
        }
        PropertyValidator.getInstance().assertOneOrLess("CALSCALE", this.properties);
        PropertyValidator.getInstance().assertOneOrLess("METHOD", this.properties);
        if (this.getComponents().isEmpty()) {
            throw new ValidationException("Calendar must contain at least one component");
        }
        Iterator i = this.getProperties().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            if (property instanceof XProperty || property.isCalendarProperty()) continue;
            throw new ValidationException("Invalid property: " + property.getName());
        }
        i = this.getComponents().iterator();
        while (i.hasNext()) {
            component = (Component)i.next();
            if (component instanceof CalendarComponent) continue;
            throw new ValidationException("Not a valid calendar component: " + component.getName());
        }
        if (Method.PUBLISH.equals(this.getProperty("METHOD"))) {
            if (this.getComponent("VEVENT") != null) {
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
                    ComponentValidator.assertNone("VTODO", this.getComponents());
                }
            } else if (this.getComponent("VFREEBUSY") != null) {
                ComponentValidator.assertNone("VTODO", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                ComponentValidator.assertNone("VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone("VALARM", this.getComponents());
            } else if (this.getComponent("VTODO") != null) {
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
            } else if (this.getComponent("VJOURNAL") != null) {
                // empty if block
            }
            i = this.getComponents().iterator();
            while (i.hasNext()) {
                component = (CalendarComponent)i.next();
                ((CalendarComponent)component).validatePublish();
            }
        } else if (Method.REQUEST.equals(this.getProperty("METHOD"))) {
            if (this.getComponent("VEVENT") != null) {
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                ComponentValidator.assertNone("VTODO", this.getComponents());
            } else if (this.getComponent("VFREEBUSY") != null) {
                ComponentValidator.assertNone("VTODO", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                ComponentValidator.assertNone("VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone("VALARM", this.getComponents());
            } else if (this.getComponent("VTODO") != null) {
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
            }
            i = this.getComponents().iterator();
            while (i.hasNext()) {
                component = (CalendarComponent)i.next();
                ((CalendarComponent)component).validateRequest();
            }
        } else if (Method.REPLY.equals(this.getProperty("METHOD"))) {
            if (this.getComponent("VEVENT") != null) {
                ComponentValidator.assertOneOrLess("VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone("VALARM", this.getComponents());
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                ComponentValidator.assertNone("VTODO", this.getComponents());
            } else if (this.getComponent("VFREEBUSY") != null) {
                ComponentValidator.assertNone("VTODO", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                ComponentValidator.assertNone("VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone("VALARM", this.getComponents());
            } else if (this.getComponent("VTODO") != null) {
                ComponentValidator.assertOneOrLess("VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone("VALARM", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
            }
            i = this.getComponents().iterator();
            while (i.hasNext()) {
                component = (CalendarComponent)i.next();
                ((CalendarComponent)component).validateReply();
            }
        } else if (Method.ADD.equals(this.getProperty("METHOD"))) {
            if (this.getComponent("VEVENT") != null) {
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                ComponentValidator.assertNone("VTODO", this.getComponents());
            } else if (this.getComponent("VTODO") != null) {
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
            } else if (this.getComponent("VJOURNAL") != null) {
                ComponentValidator.assertOneOrLess("VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
            }
            i = this.getComponents().iterator();
            while (i.hasNext()) {
                component = (CalendarComponent)i.next();
                ((CalendarComponent)component).validateAdd();
            }
        } else if (Method.CANCEL.equals(this.getProperty("METHOD"))) {
            if (this.getComponent("VEVENT") != null) {
                ComponentValidator.assertNone("VALARM", this.getComponents());
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                ComponentValidator.assertNone("VTODO", this.getComponents());
            } else if (this.getComponent("VTODO") != null) {
                ComponentValidator.assertOneOrLess("VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone("VALARM", this.getComponents());
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
            } else if (this.getComponent("VJOURNAL") != null) {
                ComponentValidator.assertNone("VALARM", this.getComponents());
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
            }
            i = this.getComponents().iterator();
            while (i.hasNext()) {
                component = (CalendarComponent)i.next();
                ((CalendarComponent)component).validateCancel();
            }
        } else if (Method.REFRESH.equals(this.getProperty("METHOD"))) {
            if (this.getComponent("VEVENT") != null) {
                ComponentValidator.assertNone("VALARM", this.getComponents());
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                ComponentValidator.assertNone("VTODO", this.getComponents());
            } else if (this.getComponent("VTODO") != null) {
                ComponentValidator.assertNone("VALARM", this.getComponents());
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                ComponentValidator.assertNone("VTIMEZONE", this.getComponents());
            }
            i = this.getComponents().iterator();
            while (i.hasNext()) {
                component = (CalendarComponent)i.next();
                ((CalendarComponent)component).validateRefresh();
            }
        } else if (Method.COUNTER.equals(this.getProperty("METHOD"))) {
            if (this.getComponent("VEVENT") != null) {
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                ComponentValidator.assertNone("VTODO", this.getComponents());
            } else if (this.getComponent("VTODO") != null) {
                ComponentValidator.assertOneOrLess("VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
            }
            i = this.getComponents().iterator();
            while (i.hasNext()) {
                component = (CalendarComponent)i.next();
                ((CalendarComponent)component).validateCounter();
            }
        } else if (Method.DECLINE_COUNTER.equals(this.getProperty("METHOD"))) {
            if (this.getComponent("VEVENT") != null) {
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
                ComponentValidator.assertNone("VTODO", this.getComponents());
                ComponentValidator.assertNone("VTIMEZONE", this.getComponents());
                ComponentValidator.assertNone("VALARM", this.getComponents());
            } else if (this.getComponent("VTODO") != null) {
                ComponentValidator.assertNone("VALARM", this.getComponents());
                ComponentValidator.assertNone("VFREEBUSY", this.getComponents());
                ComponentValidator.assertNone("VJOURNAL", this.getComponents());
            }
            i = this.getComponents().iterator();
            while (i.hasNext()) {
                component = (CalendarComponent)i.next();
                ((CalendarComponent)component).validateDeclineCounter();
            }
        }
        if (recurse) {
            this.validateProperties();
            this.validateComponents();
        }
    }

    private void validateProperties() throws ValidationException {
        Iterator i = this.getProperties().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            property.validate();
        }
    }

    private void validateComponents() throws ValidationException {
        Iterator i = this.getComponents().iterator();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            component.validate();
        }
    }

    public final ProdId getProductId() {
        return (ProdId)this.getProperty("PRODID");
    }

    public final Version getVersion() {
        return (Version)this.getProperty("VERSION");
    }

    public final CalScale getCalendarScale() {
        return (CalScale)this.getProperty("CALSCALE");
    }

    public final Method getMethod() {
        return (Method)this.getProperty("METHOD");
    }

    public final boolean equals(Object arg0) {
        if (arg0 instanceof Calendar) {
            Calendar calendar = (Calendar)arg0;
            return new EqualsBuilder().append(this.getProperties(), calendar.getProperties()).append(this.getComponents(), calendar.getComponents()).isEquals();
        }
        return super.equals(arg0);
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.getProperties()).append(this.getComponents()).toHashCode();
    }
}

