/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URISyntaxException;
import java.text.ParseException;
import net.fortuna.ical4j.data.CalendarParser;
import net.fortuna.ical4j.data.ContentHandler;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.data.UnfoldingReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalendarParserImpl
implements CalendarParser {
    private static final int WORD_CHAR_START = 32;
    private static final int WORD_CHAR_END = 255;
    private static final int WHITESPACE_CHAR_START = 0;
    private static final int WHITESPACE_CHAR_END = 20;
    private Log log = LogFactory.getLog(CalendarParserImpl.class);

    public final void parse(InputStream in, ContentHandler handler) throws IOException, ParserException {
        this.parse(new InputStreamReader(in), handler);
    }

    public final void parse(Reader in, ContentHandler handler) throws IOException, ParserException {
        StreamTokenizer tokeniser = new StreamTokenizer(in);
        try {
            tokeniser.resetSyntax();
            tokeniser.wordChars(32, 255);
            tokeniser.whitespaceChars(0, 20);
            tokeniser.ordinaryChar(58);
            tokeniser.ordinaryChar(59);
            tokeniser.ordinaryChar(61);
            tokeniser.ordinaryChar(9);
            tokeniser.eolIsSignificant(true);
            tokeniser.whitespaceChars(0, 0);
            tokeniser.quoteChar(34);
            this.assertToken(tokeniser, in, "BEGIN");
            this.assertToken(tokeniser, in, 58);
            this.assertToken(tokeniser, in, "VCALENDAR", true);
            this.assertToken(tokeniser, in, 10);
            handler.startCalendar();
            this.parsePropertyList(tokeniser, in, handler);
            this.parseComponentList(tokeniser, in, handler);
            this.assertToken(tokeniser, in, 58);
            this.assertToken(tokeniser, in, "VCALENDAR", true);
            handler.endCalendar();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ParserException) {
                throw (ParserException)e;
            }
            throw new ParserException(e.getMessage(), this.getLineNumber(tokeniser, in), e);
        }
    }

    private void parsePropertyList(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
        this.assertToken(tokeniser, in, -3);
        while (!"END".equals(tokeniser.sval)) {
            if ("BEGIN".equals(tokeniser.sval)) {
                this.parseComponent(tokeniser, in, handler);
            } else {
                this.parseProperty(tokeniser, in, handler);
            }
            this.absorbWhitespace(tokeniser);
        }
    }

    private void parseProperty(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParserException, URISyntaxException, ParseException {
        String name = tokeniser.sval;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Property [" + name + "]");
        }
        handler.startProperty(name);
        this.parseParameterList(tokeniser, in, handler);
        StringBuffer value = new StringBuffer();
        tokeniser.ordinaryChar(34);
        int nextToken = tokeniser.nextToken();
        while (nextToken != 10 && nextToken != -1) {
            if (tokeniser.ttype == -3) {
                value.append(tokeniser.sval);
            } else {
                value.append((char)tokeniser.ttype);
            }
            nextToken = tokeniser.nextToken();
        }
        tokeniser.quoteChar(34);
        if (nextToken == -1) {
            throw new ParserException("Unexpected end of file", this.getLineNumber(tokeniser, in));
        }
        try {
            handler.propertyValue(value.toString());
        }
        catch (ParseException e) {
            ParseException eNew = new ParseException("[" + name + "] " + e.getMessage(), e.getErrorOffset());
            eNew.initCause(e);
            throw eNew;
        }
        handler.endProperty(name);
    }

    private void parseParameterList(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParserException, URISyntaxException {
        while (tokeniser.nextToken() == 59) {
            this.parseParameter(tokeniser, in, handler);
        }
    }

    private void parseParameter(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParserException, URISyntaxException {
        this.assertToken(tokeniser, in, -3);
        String paramName = tokeniser.sval;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Parameter [" + paramName + "]");
        }
        this.assertToken(tokeniser, in, 61);
        StringBuffer paramValue = new StringBuffer();
        if (tokeniser.nextToken() == 34) {
            paramValue.append('\"');
            paramValue.append(tokeniser.sval);
            paramValue.append('\"');
        } else {
            paramValue.append(tokeniser.sval);
        }
        try {
            handler.parameter(paramName, paramValue.toString());
        }
        catch (ClassCastException cce) {
            throw new ParserException("Error parsing parameter", this.getLineNumber(tokeniser, in), cce);
        }
    }

    private void parseComponentList(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
        while ("BEGIN".equals(tokeniser.sval)) {
            this.parseComponent(tokeniser, in, handler);
            this.absorbWhitespace(tokeniser);
        }
    }

    private void parseComponent(StreamTokenizer tokeniser, Reader in, ContentHandler handler) throws IOException, ParseException, URISyntaxException, ParserException {
        this.assertToken(tokeniser, in, 58);
        this.assertToken(tokeniser, in, -3);
        String name = tokeniser.sval;
        handler.startComponent(name);
        this.assertToken(tokeniser, in, 10);
        this.parsePropertyList(tokeniser, in, handler);
        this.assertToken(tokeniser, in, 58);
        this.assertToken(tokeniser, in, name);
        this.assertToken(tokeniser, in, 10);
        handler.endComponent(name);
    }

    private void assertToken(StreamTokenizer tokeniser, Reader in, int token) throws IOException, ParserException {
        if (tokeniser.nextToken() != token) {
            throw new ParserException("Expected [" + token + "], read [" + tokeniser.ttype + "]", this.getLineNumber(tokeniser, in));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("[" + token + "]");
        }
    }

    private void assertToken(StreamTokenizer tokeniser, Reader in, String token) throws IOException, ParserException {
        this.assertToken(tokeniser, in, token, false);
    }

    private void assertToken(StreamTokenizer tokeniser, Reader in, String token, boolean ignoreCase) throws IOException, ParserException {
        this.assertToken(tokeniser, in, -3);
        if (ignoreCase ? !token.equalsIgnoreCase(tokeniser.sval) : !token.equals(tokeniser.sval)) {
            throw new ParserException("Expected [" + token + "], read [" + tokeniser.sval + "]", this.getLineNumber(tokeniser, in));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("[" + token + "]");
        }
    }

    private void absorbWhitespace(StreamTokenizer tokeniser) throws IOException {
        while (tokeniser.nextToken() == 10) {
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("Absorbing extra whitespace..");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Aborting: absorbing extra whitespace complete");
        }
    }

    private int getLineNumber(StreamTokenizer tokeniser, Reader in) {
        int line = tokeniser.lineno();
        if (tokeniser.ttype == 10) {
            --line;
        }
        if (in instanceof UnfoldingReader) {
            int unfolded = ((UnfoldingReader)in).getLinesUnfolded();
            line += unfolded;
        }
        return line;
    }
}

