/*
 * Decompiled with CFR 0.152.
 */
package net.klazz.soccf.runtime;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.klazz.soccf.runtime.Reporter;

public class TimedCoverageLogger {
    private final Timer mTimer = new Timer();
    private final int mPeriod;
    private final List<Reporter> mReporters;
    private final List<Logger> mStatementLoggers;
    private final List<Logger> mBranchLoggers;

    public TimedCoverageLogger(int period) {
        this.mPeriod = period;
        this.mReporters = new ArrayList<Reporter>();
        this.mStatementLoggers = new ArrayList<Logger>();
        this.mBranchLoggers = new ArrayList<Logger>();
    }

    public void start() {
        this.mTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TimedCoverageLogger.this.log();
            }
        }, 0L, (long)this.mPeriod);
    }

    public void addReporter(Reporter reporter, String filename) {
        this.mReporters.add(reporter);
        this.mStatementLoggers.add(new Logger(filename + ".stmt"));
        this.mBranchLoggers.add(new Logger(filename + ".br"));
    }

    private void log() {
        for (int i = 0; i < this.mReporters.size(); ++i) {
            Reporter reporter = this.mReporters.get(i);
            this.mStatementLoggers.get(i).log(reporter.getCoveredStatements());
            this.mBranchLoggers.get(i).log(reporter.getCoveredBranches());
        }
    }

    private static class Logger {
        private BufferedWriter mWriter;

        public Logger(String fileName) {
            try {
                this.mWriter = new BufferedWriter(new FileWriter(fileName, true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void log(int num) {
            if (this.mWriter == null) {
                return;
            }
            try {
                this.mWriter.write(String.valueOf(num));
                this.mWriter.write(System.lineSeparator());
                this.mWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

