/*
 * Decompiled with CFR 0.152.
 */
package net.klazz.soccf.runtime;

import net.klazz.soccf.runtime.Collector;
import net.klazz.soccf.runtime.CoverageCounter;
import net.klazz.soccf.runtime.Reporter;

public class DefaultCollector
implements Collector,
Reporter {
    private final CoverageCounter mCounter;

    public DefaultCollector() {
        this("soccf.cov.gz", true);
    }

    public DefaultCollector(String filename, boolean gzip) {
        final String _filename = filename;
        final boolean _gzip = gzip;
        this.mCounter = new CoverageCounter();
        this.mCounter.readFile(filename, gzip);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                DefaultCollector.this.mCounter.writeFile(_filename, _gzip);
            }
        }));
    }

    @Override
    public synchronized int getCoveredStatements() {
        return this.mCounter.getStatements().size();
    }

    @Override
    public synchronized int getCoveredBranches() {
        return this.mCounter.getBranches().size();
    }

    @Override
    public synchronized void stmt(int id) {
        this.mCounter.stmt(id);
    }

    @Override
    public synchronized void branch(int id, boolean value) {
        this.mCounter.branch(id, value);
    }
}

