/*
 * Decompiled with CFR 0.152.
 */
package net.klazz.soccf.runtime;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.klazz.soccf.runtime.Collector;

public class CoverageCounter
implements Collector {
    private final Map<Integer, Long> mStatements = new HashMap<Integer, Long>();
    private final Map<Integer, Long> mBranches = new HashMap<Integer, Long>();
    private final Map<Integer, Long> mTrueBranches = new HashMap<Integer, Long>();
    private final Map<Integer, Long> mFalseBranches = new HashMap<Integer, Long>();

    public Map<Integer, Long> getStatements() {
        return Collections.unmodifiableMap(this.mStatements);
    }

    public Map<Integer, Long> getBranches() {
        return Collections.unmodifiableMap(this.mBranches);
    }

    public Map<Integer, Long> getTrueBranches() {
        return Collections.unmodifiableMap(this.mTrueBranches);
    }

    public Map<Integer, Long> getFalseBranches() {
        return Collections.unmodifiableMap(this.mFalseBranches);
    }

    @Override
    public synchronized void stmt(int id) {
        this.increment(this.mStatements, id);
    }

    @Override
    public synchronized void branch(int id, boolean value) {
        this.increment(value ? this.mTrueBranches : this.mFalseBranches, id);
        Long trueCount = this.mTrueBranches.get(id);
        Long falseCount = this.mFalseBranches.get(id);
        if (trueCount != null && falseCount != null) {
            this.mBranches.put(id, Math.min(trueCount, falseCount));
        }
    }

    private void increment(Map<Integer, Long> idToCount, int id) {
        Long prev = idToCount.get(id);
        idToCount.put(id, prev == null ? 1L : prev + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void readFile(String filename, boolean gzip) {
        block8: {
            InputStream in = null;
            InputStreamReader reader = null;
            try {
                in = new FileInputStream(filename);
                if (gzip) {
                    in = new GZIPInputStream(in);
                }
                reader = new InputStreamReader(in);
                this.read(reader);
                this.doClose(reader);
                this.doClose(in);
            }
            catch (FileNotFoundException e) {
                this.doClose(reader);
                this.doClose(in);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.doClose(reader);
                this.doClose(in);
            }
        }
    }

    public void read(Reader reader) throws IOException {
        BufferedReader buffered = new BufferedReader(reader);
        String sig = buffered.readLine();
        this.assertSignature("soccf_coverage 0.1", sig);
        this.readCountMap(this.mStatements, "statements", buffered);
        this.readCountMap(this.mTrueBranches, "true_branches", buffered);
        this.readCountMap(this.mFalseBranches, "false_branches", buffered);
        this.updateBranches();
    }

    public synchronized void writeFile(String filename, boolean gzip) {
        this.writeToFile(filename, gzip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeToFile(String filename, boolean gzip) {
        OutputStream out = null;
        BufferedWriter writer = null;
        try {
            out = new FileOutputStream(filename);
            if (gzip) {
                out = new GZIPOutputStream(out);
            }
            writer = new BufferedWriter(new OutputStreamWriter(out));
            this.write(writer);
            writer.close();
            writer = null;
            out = null;
            boolean bl = true;
            this.doClose(writer);
            this.doClose(out);
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.doClose(writer);
            this.doClose(out);
        }
    }

    public synchronized void write(Writer writer) throws IOException {
        String sep = System.lineSeparator();
        writer.write("soccf_coverage 0.1");
        writer.write(sep);
        this.writeCountMap(this.mStatements, "statements", writer);
        this.writeCountMap(this.mTrueBranches, "true_branches", writer);
        this.writeCountMap(this.mFalseBranches, "false_branches", writer);
    }

    private void readCountMap(Map<Integer, Long> counts, String signature, BufferedReader reader) throws IOException {
        String sig = reader.readLine();
        this.assertSignature(signature, sig);
        int num = Integer.valueOf(reader.readLine());
        for (int i = 0; i < num; ++i) {
            String[] words = reader.readLine().split(" ");
            Integer id = Integer.valueOf(words[0]);
            Long cnt = Long.valueOf(words[1]);
            counts.put(id, cnt);
        }
    }

    private void writeCountMap(Map<Integer, Long> counts, String signature, Writer writer) throws IOException {
        String sep = System.lineSeparator();
        writer.write(signature);
        writer.write(sep);
        writer.write(String.valueOf(counts.size()));
        writer.write(sep);
        for (Integer key : new TreeSet<Integer>(counts.keySet())) {
            writer.write(key.toString());
            writer.write(32);
            writer.write(counts.get(key).toString());
            writer.write(sep);
        }
    }

    private void updateBranches() {
        this.mBranches.clear();
        for (Integer id : this.mTrueBranches.keySet()) {
            Long trueCount = this.mTrueBranches.get(id);
            Long falseCount = this.mFalseBranches.get(id);
            if (trueCount == null || falseCount == null) continue;
            this.mBranches.put(id, Math.min(trueCount, falseCount));
        }
    }

    private void doClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void assertSignature(String signature, String actual) throws IOException {
        if (!signature.equals(actual)) {
            throw new IOException("invalid soccf_coverage format");
        }
    }
}

